/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hive.common.util.BloomKFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorUDAFBloomFilterMerge
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorUDAFBloomFilterMerge.class);
    private long expectedEntries = -1L;
    private transient int aggBufferSize;
    private transient int numThreads;

    public VectorUDAFBloomFilterMerge() {
        this.numThreads = HiveConf.ConfVars.TEZ_BLOOM_FILTER_MERGE_THREADS.defaultIntVal;
    }

    public VectorUDAFBloomFilterMerge(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        this.numThreads = HiveConf.ConfVars.TEZ_BLOOM_FILTER_MERGE_THREADS.defaultIntVal;
        this.init();
    }

    public VectorUDAFBloomFilterMerge(VectorAggregationDesc vecAggrDesc, int numThreads) {
        super(vecAggrDesc);
        this.numThreads = HiveConf.ConfVars.TEZ_BLOOM_FILTER_MERGE_THREADS.defaultIntVal;
        this.numThreads = numThreads;
        this.init();
    }

    private void init() {
        GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator udafBloomFilter = (GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator)this.vecAggrDesc.getEvaluator();
        this.expectedEntries = udafBloomFilter.getExpectedEntries();
        this.aggBufferSize = -1;
    }

    @Override
    public void finish(VectorAggregateExpression.AggregationBuffer myagg, boolean aborted) {
        Aggregation agg = (Aggregation)myagg;
        if (agg.numThreads > 0) {
            LOG.info("bloom filter merge: finishing aggregation, waiting tasks: {}", (Object)agg.getNumberOfWaitingMergeTasks());
            agg.shutdownAndWaitForMergeTasks(agg, aborted);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        if (this.expectedEntries < 0L) {
            throw new IllegalStateException("expectedEntries not initialized");
        }
        return new Aggregation(this.expectedEntries, this.numThreads);
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        ColumnVector inputColumn = batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputColumn.isRepeating) {
            if (inputColumn.noNulls || !inputColumn.isNull[0]) {
                this.processValue(myagg, inputColumn, 0);
            }
            return;
        }
        if (myagg.numThreads != 0) {
            this.processValues(myagg, inputColumn, batchSize, batch.selectedInUse, batch.selected);
        } else if (!batch.selectedInUse && inputColumn.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, inputColumn, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, inputColumn, batchSize);
        } else if (inputColumn.noNulls) {
            this.iterateSelectionNoNulls(myagg, inputColumn, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, inputColumn, batchSize, batch.selected);
        }
    }

    private void processValues(Aggregation myagg, ColumnVector inputColumn, int batchSize, boolean selectedInUse, int[] selected) {
        Aggregation agg = myagg;
        agg.mergeBloomFilterBytesFromInputColumn((BytesColumnVector)inputColumn, batchSize, selectedInUse, selected);
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (inputColumn.isNull[i]) continue;
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (inputColumn.isNull[i]) continue;
            this.processValue(myagg, inputColumn, i);
        }
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        ColumnVector inputColumn = batch.cols[this.inputExpression.getOutputColumnNum()];
        if (inputColumn.noNulls) {
            if (inputColumn.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            }
        } else if (inputColumn.isRepeating) {
            if (!inputColumn.isNull[0]) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize, batch.selected);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            this.processValue(myagg, inputColumn, 0);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, ColumnVector inputColumn, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            int row = selection[i];
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            this.processValue(myagg, inputColumn, row);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, ColumnVector inputColumn, int batchSize, int[] selection) {
        for (int i = 0; i < batchSize; ++i) {
            int row = selection[i];
            if (inputColumn.isNull[row]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (inputColumn.isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            this.processValue(myagg, inputColumn, i);
        }
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        agg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        if (this.aggBufferSize < 0) {
            try {
                Aggregation agg = (Aggregation)this.getNewAggregationBuffer();
                this.aggBufferSize = agg.bfBytes.length;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error while creating AggregationBuffer", e);
            }
        }
        return this.aggBufferSize;
    }

    void processValue(Aggregation myagg, ColumnVector columnVector, int i) {
        BytesColumnVector inputColumn = (BytesColumnVector)columnVector;
        BloomKFilter.mergeBloomFilterBytes((byte[])myagg.bfBytes, (int)0, (int)myagg.bfBytes.length, (byte[])inputColumn.vector[i], (int)inputColumn.start[i], (int)inputColumn.length[i]);
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("bloom_filter") && inputColVectorType == ColumnVector.Type.BYTES && outputColVectorType == ColumnVector.Type.BYTES && (mode == GenericUDAFEvaluator.Mode.PARTIAL2 || mode == GenericUDAFEvaluator.Mode.FINAL);
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[columnNum];
        outputColVector.isNull[batchIndex] = false;
        Aggregation bfAgg = (Aggregation)agg;
        outputColVector.setVal(batchIndex, bfAgg.bfBytes, 0, bfAgg.bfBytes.length);
    }

    @Override
    public boolean batchNeedsClone() {
        return this.numThreads > 0;
    }

    static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        byte[] bfBytes;
        private ExecutorService executor;
        private int numThreads;
        private BloomFilterMergeWorker[] workers;
        private AtomicBoolean aborted = new AtomicBoolean(false);

        public Aggregation(long expectedEntries, int numThreads) {
            this.bfBytes = BloomKFilter.getInitialBytes((long)expectedEntries);
            if (numThreads < 0) {
                throw new RuntimeException("invalid number of threads for bloom filter merge: " + numThreads);
            }
            this.numThreads = numThreads;
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            Arrays.fill(this.bfBytes, 5, this.bfBytes.length, (byte)0);
        }

        public void mergeBloomFilterBytesFromInputColumn(BytesColumnVector inputColumn, int batchSize, boolean selectedInUse, int[] selected) {
            if (this.executor == null) {
                this.initExecutor();
            }
            for (int j = 0; j < batchSize; ++j) {
                int i;
                if (!selectedInUse) {
                    if (inputColumn.noNulls) {
                        Aggregation.splitVectorAcrossWorkers(this.workers, inputColumn.vector[j], inputColumn.start[j], inputColumn.length[j]);
                        continue;
                    }
                    if (inputColumn.isNull[j]) continue;
                    Aggregation.splitVectorAcrossWorkers(this.workers, inputColumn.vector[j], inputColumn.start[j], inputColumn.length[j]);
                    continue;
                }
                if (inputColumn.noNulls) {
                    i = selected[j];
                    Aggregation.splitVectorAcrossWorkers(this.workers, inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
                    continue;
                }
                i = selected[j];
                if (inputColumn.isNull[i]) continue;
                Aggregation.splitVectorAcrossWorkers(this.workers, inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
            }
        }

        private void initExecutor() {
            LOG.info("Number of threads used for bloom filter merge: {}", (Object)this.numThreads);
            this.executor = Executors.newFixedThreadPool(this.numThreads);
            this.workers = new BloomFilterMergeWorker[this.numThreads];
            for (int f = 0; f < this.numThreads; ++f) {
                this.workers[f] = new BloomFilterMergeWorker(this.bfBytes, 0, this.bfBytes.length, this.aborted);
                this.executor.submit(this.workers[f]);
            }
        }

        public int getNumberOfWaitingMergeTasks() {
            int size = 0;
            for (BloomFilterMergeWorker w : this.workers) {
                size += w.queue.size();
            }
            return size;
        }

        private static void splitVectorAcrossWorkers(BloomFilterMergeWorker[] workers, byte[] bytes, int start, int length) {
            if (bytes == null || length == 0) {
                return;
            }
            int elementPerBatch = (int)Math.ceil((double)(length - 5) / (double)workers.length);
            for (int w = 0; w < workers.length; ++w) {
                int modifiedStart = 5 + w * elementPerBatch;
                int modifiedLength = w == workers.length - 1 ? length - (5 + w * elementPerBatch) : elementPerBatch;
                ElementWrapper wrapper = new ElementWrapper(bytes, start, length, modifiedStart, modifiedLength);
                workers[w].add(wrapper);
            }
        }

        public void shutdownAndWaitForMergeTasks(Aggregation agg, boolean aborted) {
            if (aborted) {
                agg.aborted.set(true);
            }
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(180L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Bloom filter merge is interrupted while waiting to finish, this is unexpected", (Throwable)e);
            }
        }
    }

    public static class ElementWrapper {
        public byte[] bytes;
        public int start;
        public int length;
        public int modifiedStart;
        public int modifiedLength;

        public ElementWrapper(byte[] bytes, int start, int length, int modifiedStart, int modifiedLength) {
            this.bytes = bytes;
            this.start = start;
            this.length = length;
            this.modifiedStart = modifiedStart;
            this.modifiedLength = modifiedLength;
        }
    }

    private static class BloomFilterMergeWorker
    implements Runnable {
        private BlockingQueue<ElementWrapper> queue;
        private byte[] bfAggregation;
        private int bfAggregationStart;
        private int bfAggregationLength;
        private AtomicBoolean aborted;

        public BloomFilterMergeWorker(byte[] bfAggregation, int bfAggregationStart, int bfAggregationLength, AtomicBoolean aborted) {
            this.bfAggregation = bfAggregation;
            this.bfAggregationStart = bfAggregationStart;
            this.bfAggregationLength = bfAggregationLength;
            this.queue = new LinkedBlockingDeque<ElementWrapper>();
            this.aborted = aborted;
        }

        public void add(ElementWrapper wrapper) {
            this.queue.add(wrapper);
        }

        @Override
        public void run() {
            while (true) {
                ElementWrapper currentBf = null;
                try {
                    currentBf = this.queue.take();
                    this.merge(currentBf);
                }
                catch (InterruptedException e) {
                    if (!this.queue.isEmpty()) {
                        LOG.info("bloom filter merge was interrupted while processing and queue is still not empty (size: {}), this is fine in case of shutdownNow", (Object)this.queue.size());
                    }
                    if (this.aborted.get()) {
                        LOG.info("bloom filter merge was aborted, won't finish merging...");
                    } else {
                        while (!this.queue.isEmpty()) {
                            ElementWrapper lastBloomFilter = (ElementWrapper)this.queue.poll();
                            this.merge(lastBloomFilter);
                        }
                    }
                    return;
                }
            }
        }

        private void merge(ElementWrapper bloomFilterWrapper) {
            BloomKFilter.mergeBloomFilterBytes((byte[])this.bfAggregation, (int)this.bfAggregationStart, (int)this.bfAggregationLength, (byte[])bloomFilterWrapper.bytes, (int)bloomFilterWrapper.start, (int)bloomFilterWrapper.length, (int)bloomFilterWrapper.modifiedStart, (int)(bloomFilterWrapper.modifiedStart + bloomFilterWrapper.modifiedLength));
        }
    }
}

