/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputSplit;
import org.apache.hadoop.hive.ql.io.HiveContextAwareRecordReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;

public class BucketizedHiveRecordReader<K extends WritableComparable, V extends Writable>
extends HiveContextAwareRecordReader<K, V> {
    protected final BucketizedHiveInputSplit split;
    protected final InputFormat inputFormat;
    protected final Reporter reporter;
    protected long progress;
    protected int idx;

    public BucketizedHiveRecordReader(InputFormat inputFormat, BucketizedHiveInputSplit bucketizedSplit, JobConf jobConf, Reporter reporter) throws IOException {
        super(jobConf);
        this.split = bucketizedSplit;
        this.inputFormat = inputFormat;
        this.reporter = reporter;
        this.initNextRecordReader();
    }

    @Override
    public void doClose() throws IOException {
        if (this.recordReader != null) {
            this.recordReader.close();
            this.recordReader = null;
        }
        this.idx = 0;
    }

    public K createKey() {
        return (K)((WritableComparable)this.recordReader.createKey());
    }

    public V createValue() {
        return (V)((Writable)this.recordReader.createValue());
    }

    public long getPos() throws IOException {
        if (this.recordReader != null) {
            return this.recordReader.getPos();
        }
        return 0L;
    }

    @Override
    public float getProgress() throws IOException {
        return Math.min(1.0f, (float)(this.recordReader == null || this.getIOContext().isBinarySearching() ? this.progress : this.recordReader.getPos()) / (float)this.split.getLength());
    }

    @Override
    public boolean doNext(K key, V value) throws IOException {
        while (this.recordReader == null || !this.doNextWithExceptionHandler(key, value)) {
            if (this.initNextRecordReader()) continue;
            return false;
        }
        return true;
    }

    private boolean doNextWithExceptionHandler(K key, V value) throws IOException {
        return super.doNext(key, value);
    }

    protected boolean initNextRecordReader() throws IOException {
        if (this.recordReader != null) {
            this.recordReader.close();
            this.recordReader = null;
            if (this.idx > 0) {
                this.progress += this.split.getLength(this.idx - 1);
            }
        }
        if (this.idx == this.split.getNumSplits()) {
            return false;
        }
        this.recordReader = this.inputFormat.getRecordReader(this.split.getSplit(this.idx), this.jobConf, this.reporter);
        if (this.isSorted) {
            this.initIOContextSortedProps((FileSplit)this.split.getSplit(this.idx), this.recordReader, this.jobConf);
        }
        ++this.idx;
        return true;
    }
}

