/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterPartitionEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(AlterPartitionEvent.class);
    private String COMMAND_STR = "alter table %s partition %s";

    public AlterPartitionEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.ALTERPARTITION_FILEFORMAT, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        LOG.debug("==> AlterPartitionEvent.getInputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterPartitionEvent event = (PreAlterPartitionEvent)this.preEventContext;
        ret.add(this.getHivePrivilegeObject(event.getTable()));
        LOG.debug("<== AlterPartitionEvent.getInputHObjs() ret={}", ret);
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        String newUri;
        LOG.debug("==> AlterPartitionEvent.getOutputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterPartitionEvent event = (PreAlterPartitionEvent)this.preEventContext;
        ret.add(this.getHivePrivilegeObject(event.getTable()));
        Partition newPartition = event.getNewPartition();
        String oldUri = "";
        if (event.getOldPartVals() != null && event.getOldPartVals().size() > 0) {
            oldUri = this.getOldPartSdLocation(event);
        }
        String string = newUri = newPartition != null ? this.getSdLocation(newPartition.getSd()) : "";
        if (StringUtils.isNotEmpty((CharSequence)newUri) && !StringUtils.equalsIgnoreCase((CharSequence)oldUri, (CharSequence)newUri)) {
            ret.add(this.getHivePrivilegeObjectDfsUri(newUri));
        }
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, event.getTableName(), newPartition);
        LOG.debug("<== AlterPartitionEvent.getOutputHObjs() ret={}", ret);
        return ret;
    }

    private String getOldPartSdLocation(PreAlterPartitionEvent event) {
        Table table = new Table(event.getTable());
        try {
            org.apache.hadoop.hive.ql.metadata.Partition partition = Hive.get().getPartition(table, Warehouse.makeSpecFromValues((List)event.getTable().getPartitionKeys(), (List)event.getOldPartVals()));
            return partition.getLocation();
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildCommandString(String cmdStr, String tbl, Partition partition) {
        String ret = cmdStr;
        if (tbl != null) {
            Object tblName = StringUtils.isNotEmpty((CharSequence)tbl) ? " " + tbl : "";
            String partitionStr = partition != null ? partition.toString() : "";
            ret = String.format(cmdStr, tblName, partitionStr);
        }
        return ret;
    }
}

