/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.vfs.gs.config;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class GoogleCloudConfig {

  public static final String HOP_CONFIG_GOOGLE_CLOUD_CONFIG_KEY = "googleCloud";

  private String serviceAccountKeyFile;
  private Boolean scanFoldersForLastModifDate;
  private String maxAttempts;
  private String initialRetryDelay;
  private String retryDelayMultiplier;
  private String maxRetryDelay;
  private String totalTimeout;
  private String initialRpcTimeout;
  private String rpcTimeoutMultiplier;
  private String maxRpcTimeout;
  private String connectionTimeout;
  private String readTimeout;

  public GoogleCloudConfig() {
    scanFoldersForLastModifDate = false;
    maxAttempts = "6";
    initialRetryDelay = "1";
    retryDelayMultiplier = "2.0";
    maxRetryDelay = "32";
    totalTimeout = "50";
    initialRpcTimeout = "50";
    rpcTimeoutMultiplier = "1.0";
    maxRpcTimeout = "50";
    connectionTimeout = "20";
    readTimeout = "20";
  }

  public GoogleCloudConfig(GoogleCloudConfig config) {
    this();
    serviceAccountKeyFile = config.serviceAccountKeyFile;
    scanFoldersForLastModifDate = config.scanFoldersForLastModifDate;
    maxAttempts = config.maxAttempts;
    initialRetryDelay = config.initialRetryDelay;
    retryDelayMultiplier = config.retryDelayMultiplier;
    maxRetryDelay = config.maxRetryDelay;
    totalTimeout = config.totalTimeout;
    initialRpcTimeout = config.initialRpcTimeout;
    rpcTimeoutMultiplier = config.rpcTimeoutMultiplier;
    maxRpcTimeout = config.maxRpcTimeout;
    connectionTimeout = config.connectionTimeout;
    readTimeout = config.readTimeout;
  }
}
