/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.interceptors;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.observation.MetricConfig;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.util.Args;

public final class AsyncIoByteCounterExec
implements AsyncExecChainHandler {
    private final MeterRegistry meterRegistry;
    private final ObservingOptions opts;
    private final MetricConfig mc;
    private final Counter.Builder reqBuilder;
    private final Counter.Builder respBuilder;

    public AsyncIoByteCounterExec(MeterRegistry meterRegistry, ObservingOptions opts, MetricConfig mc) {
        this.meterRegistry = (MeterRegistry)Args.notNull((Object)meterRegistry, (String)"meterRegistry");
        this.opts = (ObservingOptions)Args.notNull((Object)opts, (String)"observingOptions");
        this.mc = (MetricConfig)Args.notNull((Object)mc, (String)"metricConfig");
        this.reqBuilder = Counter.builder((String)(mc.prefix + ".request.bytes")).description("HTTP request payload size").baseUnit("bytes");
        this.respBuilder = Counter.builder((String)(mc.prefix + ".response.bytes")).description("HTTP response payload size").baseUnit("bytes");
    }

    public void execute(final HttpRequest request, AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback callback) throws HttpException, IOException {
        if (!this.opts.spanSampling.test(request.getRequestUri())) {
            chain.proceed(request, entityProducer, scope, callback);
            return;
        }
        final long reqBytes = entityProducer != null ? entityProducer.getContentLength() : -1L;
        final AtomicReference respRef = new AtomicReference();
        final AtomicLong respLen = new AtomicLong(-1L);
        AsyncExecCallback wrapped = new AsyncExecCallback(){

            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                respRef.set(response);
                if (entityDetails != null) {
                    respLen.set(entityDetails.getContentLength());
                }
                return callback.handleResponse(response, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                callback.handleInformationResponse(response);
            }

            public void completed() {
                this.record();
                callback.completed();
            }

            public void failed(Exception cause) {
                this.record();
                callback.failed(cause);
            }

            private void record() {
                long rb;
                HttpResponse rsp = (HttpResponse)respRef.get();
                int status = rsp != null ? rsp.getCode() : 599;
                String protocol = scope.route.getTargetHost().getSchemeName();
                String target = scope.route.getTargetHost().getHostName();
                String uri = request.getRequestUri();
                List tags = AsyncIoByteCounterExec.this.buildTags(request.getMethod(), status, protocol, target, uri);
                if (reqBytes >= 0L) {
                    AsyncIoByteCounterExec.this.reqBuilder.tags((Iterable)tags).tags(((AsyncIoByteCounterExec)AsyncIoByteCounterExec.this).mc.commonTags).register(AsyncIoByteCounterExec.this.meterRegistry).increment((double)reqBytes);
                }
                if ((rb = respLen.get()) >= 0L) {
                    AsyncIoByteCounterExec.this.respBuilder.tags((Iterable)tags).tags(((AsyncIoByteCounterExec)AsyncIoByteCounterExec.this).mc.commonTags).register(AsyncIoByteCounterExec.this.meterRegistry).increment((double)rb);
                }
            }
        };
        chain.proceed(request, entityProducer, scope, wrapped);
    }

    private List<Tag> buildTags(String method, int status, String protocol, String target, String uri) {
        ArrayList<Tag> tags = new ArrayList<Tag>(8);
        tags.add(Tag.of((String)"method", (String)method));
        tags.add(Tag.of((String)"status", (String)Integer.toString(status)));
        if (this.opts.tagLevel == ObservingOptions.TagLevel.EXTENDED) {
            tags.add(Tag.of((String)"protocol", (String)protocol));
            tags.add(Tag.of((String)"target", (String)target));
        }
        if (this.mc.perUriIo) {
            tags.add(Tag.of((String)"uri", (String)uri));
        }
        return this.opts.tagCustomizer.apply(tags, method, status, protocol, target, uri);
    }
}

