/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.AlterZoneEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;

public class AlterZoneEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class AlterZoneEntrySerializerV2
    implements CatalogObjectSerializer<AlterZoneEntry> {
        AlterZoneEntrySerializerV2() {
        }

        @Override
        public AlterZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogZoneDescriptor descriptor = input.readEntry(CatalogZoneDescriptor.class);
            return new AlterZoneEntry(descriptor);
        }

        @Override
        public void writeTo(AlterZoneEntry object, CatalogObjectDataOutput output) throws IOException {
            output.writeEntry(object.descriptor());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class AlterZoneEntrySerializerV1
    implements CatalogObjectSerializer<AlterZoneEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public AlterZoneEntrySerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public AlterZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_ZONE.id());
            CatalogZoneDescriptor descriptor = (CatalogZoneDescriptor)serializer.readFrom(input);
            return new AlterZoneEntry(descriptor);
        }

        @Override
        public void writeTo(AlterZoneEntry object, CatalogObjectDataOutput output) throws IOException {
            this.serializers.get(1, object.descriptor().typeId()).writeTo(object.descriptor(), output);
        }
    }
}

