/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.SecurityContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.BearerAuthenticationParameters;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.CatalogPrivilege;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.NamespaceGrant;
import org.apache.polaris.core.admin.model.NamespacePrivilege;
import org.apache.polaris.core.admin.model.OAuthClientCredentialsParameters;
import org.apache.polaris.core.admin.model.PolicyGrant;
import org.apache.polaris.core.admin.model.PolicyPrivilege;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.PrincipalWithCredentialsCredentials;
import org.apache.polaris.core.admin.model.ResetPrincipalRequest;
import org.apache.polaris.core.admin.model.TableGrant;
import org.apache.polaris.core.admin.model.TablePrivilege;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.ViewGrant;
import org.apache.polaris.core.admin.model.ViewPrivilege;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.CatalogRoleEntity;
import org.apache.polaris.core.entity.NamespaceEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.entity.PrincipalRoleEntity;
import org.apache.polaris.core.entity.table.IcebergTableLikeEntity;
import org.apache.polaris.core.entity.table.federated.FederatedEntities;
import org.apache.polaris.core.exceptions.CommitConflictException;
import org.apache.polaris.core.identity.dpo.ServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.provider.ServiceIdentityProvider;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.CreateCatalogResult;
import org.apache.polaris.core.persistence.dao.entity.CreatePrincipalResult;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.LoadGrantsResult;
import org.apache.polaris.core.persistence.dao.entity.PrivilegeResult;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.persistence.resolver.ResolverPath;
import org.apache.polaris.core.persistence.resolver.ResolverStatus;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.exceptions.NoSuchPolicyException;
import org.apache.polaris.core.secrets.SecretReference;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.StorageLocation;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.apache.polaris.service.catalog.common.CatalogHandler;
import org.apache.polaris.service.config.ReservedProperties;
import org.apache.polaris.service.types.PolicyIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class PolarisAdminService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisAdminService.class);
    private final CallContext callContext;
    private final RealmConfig realmConfig;
    private final ResolutionManifestFactory resolutionManifestFactory;
    private final SecurityContext securityContext;
    private final PolarisPrincipal polarisPrincipal;
    private final PolarisAuthorizer authorizer;
    private final PolarisMetaStoreManager metaStoreManager;
    private final UserSecretsManager userSecretsManager;
    private final ServiceIdentityProvider serviceIdentityProvider;
    private final ReservedProperties reservedProperties;

    @Inject
    public PolarisAdminService(@Nonnull PolarisDiagnostics diagnostics, @Nonnull CallContext callContext, @Nonnull ResolutionManifestFactory resolutionManifestFactory, @Nonnull PolarisMetaStoreManager metaStoreManager, @Nonnull UserSecretsManager userSecretsManager, @Nonnull ServiceIdentityProvider serviceIdentityProvider, @Nonnull SecurityContext securityContext, @Nonnull PolarisAuthorizer authorizer, @Nonnull ReservedProperties reservedProperties) {
        this.callContext = callContext;
        this.realmConfig = callContext.getRealmConfig();
        this.resolutionManifestFactory = resolutionManifestFactory;
        this.metaStoreManager = metaStoreManager;
        this.securityContext = securityContext;
        diagnostics.checkNotNull((Object)securityContext, "null_security_context");
        diagnostics.checkNotNull((Object)securityContext.getUserPrincipal(), "null_security_context");
        diagnostics.check(securityContext.getUserPrincipal() instanceof PolarisPrincipal, "unexpected_principal_type", "class={}", new Object[]{securityContext.getUserPrincipal().getClass().getName()});
        this.polarisPrincipal = (PolarisPrincipal)securityContext.getUserPrincipal();
        this.authorizer = authorizer;
        this.userSecretsManager = userSecretsManager;
        this.serviceIdentityProvider = serviceIdentityProvider;
        this.reservedProperties = reservedProperties;
    }

    private PolarisCallContext getCurrentPolarisContext() {
        return this.callContext.getPolarisCallContext();
    }

    private UserSecretsManager getUserSecretsManager() {
        return this.userSecretsManager;
    }

    private ServiceIdentityProvider getServiceIdentityProvider() {
        return this.serviceIdentityProvider;
    }

    private PolarisResolutionManifest newResolutionManifest(@Nullable String catalogName) {
        return this.resolutionManifestFactory.createResolutionManifest(this.securityContext, catalogName);
    }

    private static PrincipalEntity getPrincipalByName(PolarisResolutionManifest resolutionManifest, String principalName) {
        return Optional.ofNullable(resolutionManifest.getResolvedTopLevelEntity(principalName, PolarisEntityType.PRINCIPAL)).map(PolarisResolvedPathWrapper::getRawLeafEntity).map(PrincipalEntity::of).orElseThrow(() -> new NotFoundException("Principal %s not found", new Object[]{principalName}));
    }

    private static PrincipalRoleEntity getPrincipalRoleByName(PolarisResolutionManifest resolutionManifest, String principalRoleName) {
        return Optional.ofNullable(resolutionManifest.getResolvedTopLevelEntity(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE)).map(PolarisResolvedPathWrapper::getRawLeafEntity).map(PrincipalRoleEntity::of).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
    }

    private static CatalogEntity getCatalogByName(PolarisResolutionManifest resolutionManifest, String catalogName) {
        return Optional.ofNullable(resolutionManifest.getResolvedCatalogEntity()).filter(c -> c.getName().equals(catalogName)).orElseThrow(() -> new NotFoundException("Catalog %s not found", new Object[]{catalogName}));
    }

    private static CatalogRoleEntity getCatalogRoleByName(PolarisResolutionManifest resolutionManifest, String catalogRoleName) {
        return Optional.ofNullable(resolutionManifest.getResolvedPath((Object)catalogRoleName)).map(PolarisResolvedPathWrapper::getRawLeafEntity).map(CatalogRoleEntity::of).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
    }

    private void authorizeBasicRootOperationOrThrow(PolarisAuthorizableOperation op) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(null);
        resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper rootContainerWrapper = resolutionManifest.getResolvedRootContainerEntityAsPath();
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedPrincipalRoleEntities(), op, rootContainerWrapper, null);
    }

    private PolarisResolutionManifest authorizeBasicTopLevelEntityOperationOrThrow(PolarisAuthorizableOperation op, String topLevelEntityName, PolarisEntityType entityType) {
        String referenceCatalogName = entityType == PolarisEntityType.CATALOG ? topLevelEntityName : null;
        return this.authorizeBasicTopLevelEntityOperationOrThrow(op, topLevelEntityName, entityType, referenceCatalogName);
    }

    private PolarisResolutionManifest authorizeBasicTopLevelEntityOperationOrThrow(PolarisAuthorizableOperation op, String topLevelEntityName, PolarisEntityType entityType, @Nullable String referenceCatalogName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(referenceCatalogName);
        resolutionManifest.addTopLevelName(topLevelEntityName, entityType, false);
        ResolverStatus status = resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("TopLevelEntity of type %s does not exist: %s", new Object[]{entityType, topLevelEntityName});
        }
        PolarisResolvedPathWrapper topLevelEntityWrapper = resolutionManifest.getResolvedTopLevelEntity(topLevelEntityName, entityType);
        PolarisEntity entity = topLevelEntityWrapper.getResolvedLeafEntity().getEntity();
        if (this.isSelfEntity(entity) && PolarisAdminService.isSelfOperation(op)) {
            LOGGER.atDebug().addKeyValue("principalName", (Object)topLevelEntityName).log("Allowing rotate own credentials");
        } else {
            this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, topLevelEntityWrapper, null);
        }
        return resolutionManifest;
    }

    private boolean isSelfEntity(PolarisEntity entity) {
        return entity.getType() == PolarisEntityType.PRINCIPAL && entity.getName().equals(this.polarisPrincipal.getName());
    }

    private static boolean isSelfOperation(PolarisAuthorizableOperation op) {
        return op.equals((Object)PolarisAuthorizableOperation.ROTATE_CREDENTIALS);
    }

    private PolarisResolutionManifest authorizeBasicCatalogRoleOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, String catalogRoleName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(catalogName);
        resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper target = resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        if (target == null) {
            throw new NotFoundException("CatalogRole does not exist: %s", new Object[]{catalogRoleName});
        }
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, target, null);
        return resolutionManifest;
    }

    private PolarisResolutionManifest authorizeGrantOnRootContainerToPrincipalRoleOperationOrThrow(PolarisAuthorizableOperation op, String principalRoleName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(null);
        resolutionManifest.addTopLevelName(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, false);
        ResolverStatus status = resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to grant on root to %s", new Object[]{status.getFailedToResolvedEntityName(), principalRoleName});
        }
        PolarisResolvedPathWrapper rootContainerWrapper = resolutionManifest.getResolvedRootContainerEntityAsPath();
        PolarisResolvedPathWrapper principalRoleWrapper = resolutionManifest.getResolvedTopLevelEntity(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, rootContainerWrapper, principalRoleWrapper);
        return resolutionManifest;
    }

    private PolarisResolutionManifest authorizeGrantOnPrincipalRoleToPrincipalOperationOrThrow(PolarisAuthorizableOperation op, String principalRoleName, String principalName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(null);
        resolutionManifest.addTopLevelName(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, false);
        resolutionManifest.addTopLevelName(principalName, PolarisEntityType.PRINCIPAL, false);
        ResolverStatus status = resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to assign %s to %s", new Object[]{status.getFailedToResolvedEntityName(), principalRoleName, principalName});
        }
        PolarisResolvedPathWrapper principalRoleWrapper = resolutionManifest.getResolvedTopLevelEntity(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        PolarisResolvedPathWrapper principalWrapper = resolutionManifest.getResolvedTopLevelEntity(principalName, PolarisEntityType.PRINCIPAL);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, principalRoleWrapper, principalWrapper);
        return resolutionManifest;
    }

    private PolarisResolutionManifest authorizeGrantOnCatalogRoleToPrincipalRoleOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, String catalogRoleName, String principalRoleName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(catalogName);
        resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        resolutionManifest.addTopLevelName(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, false);
        ResolverStatus status = resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to assign %s.%s to %s", new Object[]{status.getFailedToResolvedEntityName(), catalogName, catalogRoleName, principalRoleName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to assign %s.%s to %s", new Object[]{status.getFailedToResolvePath(), catalogName, catalogRoleName, principalRoleName});
        }
        PolarisResolvedPathWrapper principalRoleWrapper = resolutionManifest.getResolvedTopLevelEntity(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        PolarisResolvedPathWrapper catalogRoleWrapper = resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, catalogRoleWrapper, principalRoleWrapper);
        return resolutionManifest;
    }

    private PolarisResolutionManifest authorizeGrantOnCatalogOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, String catalogRoleName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(catalogName);
        resolutionManifest.addTopLevelName(catalogName, PolarisEntityType.CATALOG, false);
        resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        ResolverStatus status = resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Catalog not found: %s", new Object[]{catalogName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            throw new NotFoundException("CatalogRole not found: %s.%s", new Object[]{catalogName, catalogRoleName});
        }
        PolarisResolvedPathWrapper catalogWrapper = resolutionManifest.getResolvedTopLevelEntity(catalogName, PolarisEntityType.CATALOG);
        PolarisResolvedPathWrapper catalogRoleWrapper = resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, catalogWrapper, catalogRoleWrapper);
        return resolutionManifest;
    }

    private PolarisResolutionManifest authorizeGrantOnNamespaceOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, Namespace namespace, String catalogRoleName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(catalogName);
        resolutionManifest.addPassthroughPath(new ResolverPath(Arrays.asList(namespace.levels()), PolarisEntityType.NAMESPACE), (Object)namespace);
        resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        ResolverStatus status = resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Catalog not found: %s", new Object[]{catalogName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            if (status.getFailedToResolvePath().getLastEntityType() == PolarisEntityType.NAMESPACE) {
                throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{status.getFailedToResolvePath().getEntityNames()});
            }
            throw new NotFoundException("CatalogRole not found: %s.%s", new Object[]{catalogName, catalogRoleName});
        }
        PolarisResolvedPathWrapper namespaceWrapper = resolutionManifest.getResolvedPath((Object)namespace, true);
        PolarisResolvedPathWrapper catalogRoleWrapper = resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, namespaceWrapper, catalogRoleWrapper);
        return resolutionManifest;
    }

    private PolarisResolutionManifest authorizeGrantOnTableLikeOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, List<PolarisEntitySubType> subTypes, TableIdentifier identifier, String catalogRoleName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(catalogName);
        resolutionManifest.addPassthroughPath(new ResolverPath(Arrays.asList(identifier.namespace().levels()), PolarisEntityType.NAMESPACE), (Object)identifier.namespace());
        resolutionManifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)identifier), PolarisEntityType.TABLE_LIKE), (Object)identifier);
        resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        ResolverStatus status = resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Catalog not found: %s", new Object[]{catalogName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            if (status.getFailedToResolvePath().getLastEntityType() == PolarisEntityType.TABLE_LIKE) {
                CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, subTypes);
            } else {
                throw new NotFoundException("CatalogRole not found: %s.%s", new Object[]{catalogName, catalogRoleName});
            }
        }
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        PolarisResolvedPathWrapper tableLikeWrapper = resolutionManifest.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE, true);
        boolean rbacForFederatedCatalogsEnabled = (Boolean)this.getCurrentPolarisContext().getRealmConfig().getConfig((PolarisConfiguration)FeatureConfiguration.ENABLE_SUB_CATALOG_RBAC_FOR_FEDERATED_CATALOGS, catalogEntity);
        if (!(resolutionManifest.getIsPassthroughFacade() && rbacForFederatedCatalogsEnabled || subTypes.contains(tableLikeWrapper.getRawLeafEntity().getSubType()))) {
            CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, subTypes);
        }
        PolarisResolvedPathWrapper catalogRoleWrapper = resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, tableLikeWrapper, catalogRoleWrapper);
        return resolutionManifest;
    }

    private PolarisResolutionManifest authorizeGrantOnPolicyOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, PolicyIdentifier identifier, String catalogRoleName) {
        PolarisResolutionManifest resolutionManifest = this.newResolutionManifest(catalogName);
        resolutionManifest.addPath(new ResolverPath(PolarisCatalogHelpers.identifierToList((Namespace)identifier.getNamespace(), (String)identifier.getName()), PolarisEntityType.POLICY), (Object)identifier);
        resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        ResolverStatus status = resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Catalog not found: %s", new Object[]{catalogName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            if (status.getFailedToResolvePath().getLastEntityType() == PolarisEntityType.POLICY) {
                throw new NoSuchPolicyException(String.format("Policy does not exist: %s", identifier));
            }
            throw new NotFoundException("CatalogRole not found: %s.%s", new Object[]{catalogName, catalogRoleName});
        }
        PolarisResolvedPathWrapper policyWrapper = resolutionManifest.getResolvedPath((Object)identifier, true);
        PolarisResolvedPathWrapper catalogRoleWrapper = resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, policyWrapper, catalogRoleWrapper);
        return resolutionManifest;
    }

    private Set<String> getCatalogLocations(CatalogEntity catalogEntity) {
        HashSet<String> catalogLocations = new HashSet<String>();
        catalogLocations.add(this.terminateWithSlash(catalogEntity.getBaseLocation()));
        if (catalogEntity.getStorageConfigurationInfo() != null) {
            catalogLocations.addAll(catalogEntity.getStorageConfigurationInfo().getAllowedLocations().stream().map(this::terminateWithSlash).toList());
        }
        return catalogLocations;
    }

    private String terminateWithSlash(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith("/")) {
            return path;
        }
        return path + "/";
    }

    private boolean catalogOverlapsWithExistingCatalog(CatalogEntity catalogEntity) {
        boolean allowOverlappingCatalogUrls = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_OVERLAPPING_CATALOG_URLS);
        if (allowOverlappingCatalogUrls) {
            return false;
        }
        Set<String> newCatalogLocations = this.getCatalogLocations(catalogEntity);
        return this.listCatalogsUnsafe().anyMatch(existingCatalog -> {
            if (existingCatalog.getName().equals(catalogEntity.getName())) {
                return false;
            }
            return this.getCatalogLocations((CatalogEntity)existingCatalog).stream().map(StorageLocation::of).anyMatch(existingLocation -> newCatalogLocations.stream().anyMatch(newLocationString -> {
                StorageLocation newLocation = StorageLocation.of((String)newLocationString);
                return newLocation.isChildOf(existingLocation) || existingLocation.isChildOf(newLocation);
            }));
        });
    }

    private Map<String, SecretReference> extractSecretReferences(CreateCatalogRequest catalogRequest, PolarisEntity forEntity) {
        ExternalCatalog externalCatalog;
        HashMap<String, SecretReference> secretReferences = new HashMap<String, SecretReference>();
        Catalog catalog = catalogRequest.getCatalog();
        UserSecretsManager secretsManager = this.getUserSecretsManager();
        if (catalog instanceof ExternalCatalog && (externalCatalog = (ExternalCatalog)catalog).getConnectionConfigInfo() != null) {
            ConnectionConfigInfo connectionConfig = externalCatalog.getConnectionConfigInfo();
            AuthenticationParameters authenticationParameters = connectionConfig.getAuthenticationParameters();
            switch (authenticationParameters.getAuthenticationType()) {
                case OAUTH: {
                    OAuthClientCredentialsParameters oauthClientCredentialsModel = (OAuthClientCredentialsParameters)authenticationParameters;
                    String inlineClientSecret = oauthClientCredentialsModel.getClientSecret();
                    SecretReference secretReference = secretsManager.writeSecret(inlineClientSecret, (PolarisEntityCore)forEntity);
                    secretReferences.put("inlineClientSecretReference", secretReference);
                    break;
                }
                case BEARER: {
                    BearerAuthenticationParameters bearerAuthenticationParametersModel = (BearerAuthenticationParameters)authenticationParameters;
                    String inlineBearerToken = bearerAuthenticationParametersModel.getBearerToken();
                    SecretReference secretReference = secretsManager.writeSecret(inlineBearerToken, (PolarisEntityCore)forEntity);
                    secretReferences.put("inlineBearerTokenReference", secretReference);
                    break;
                }
                case SIGV4: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported authentication type: " + String.valueOf(authenticationParameters.getAuthenticationType()));
                }
            }
        }
        return secretReferences;
    }

    private boolean requiresSecretReferenceExtraction(@Nonnull ConnectionConfigInfo connectionConfigInfo) {
        return connectionConfigInfo.getAuthenticationParameters().getAuthenticationType() != AuthenticationParameters.AuthenticationTypeEnum.IMPLICIT;
    }

    public PolarisEntity createCatalog(CreateCatalogRequest catalogRequest) {
        CreateCatalogResult catalogResult;
        ExternalCatalog externalCatalog;
        ConnectionConfigInfo connectionConfigInfo;
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_CATALOG;
        this.authorizeBasicRootOperationOrThrow(op);
        CatalogEntity entity = CatalogEntity.fromCatalog((RealmConfig)this.realmConfig, (Catalog)catalogRequest.getCatalog());
        Preconditions.checkArgument((entity.getId() == -1L ? 1 : 0) != 0, (Object)"Entity to be created must have no ID assigned");
        if (this.catalogOverlapsWithExistingCatalog(entity)) {
            throw new ValidationException("Cannot create Catalog %s. One or more of its locations overlaps with an existing catalog", new Object[]{entity.getName()});
        }
        entity = ((CatalogEntity.Builder)((CatalogEntity.Builder)((CatalogEntity.Builder)new CatalogEntity.Builder(entity).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCreateTimestamp(System.currentTimeMillis())).setProperties(this.reservedProperties.removeReservedProperties(entity.getPropertiesAsMap()))).build();
        Catalog catalog = catalogRequest.getCatalog();
        if (catalog instanceof ExternalCatalog && (connectionConfigInfo = (externalCatalog = (ExternalCatalog)catalog).getConnectionConfigInfo()) != null) {
            LOGGER.atDebug().addKeyValue("catalogName", (Object)entity.getName()).log("Creating a federated catalog");
            FeatureConfiguration.enforceFeatureEnabledOrThrow((RealmConfig)this.realmConfig, (FeatureConfiguration)FeatureConfiguration.ENABLE_CATALOG_FEDERATION);
            Map<Object, Object> processedSecretReferences = Map.of();
            List<String> supportedAuthenticationTypes = ((List)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.SUPPORTED_EXTERNAL_CATALOG_AUTHENTICATION_TYPES)).stream().map(s -> s.toUpperCase(Locale.ROOT)).toList();
            if (this.requiresSecretReferenceExtraction(connectionConfigInfo)) {
                Preconditions.checkState((boolean)supportedAuthenticationTypes.contains(connectionConfigInfo.getAuthenticationParameters().getAuthenticationType().name()), (String)"Authentication type %s is not supported.", (Object)connectionConfigInfo.getAuthenticationParameters().getAuthenticationType());
                processedSecretReferences = this.extractSecretReferences(catalogRequest, (PolarisEntity)entity);
            } else {
                Preconditions.checkState((boolean)supportedAuthenticationTypes.contains(AuthenticationParameters.AuthenticationTypeEnum.IMPLICIT.name()), (Object)"Implicit authentication based catalog federation is not supported.");
            }
            Optional serviceIdentityInfoDpoOptional = this.serviceIdentityProvider.allocateServiceIdentity(connectionConfigInfo);
            entity = new CatalogEntity.Builder(entity).setConnectionConfigInfoDpoWithSecrets(connectionConfigInfo, processedSecretReferences, (ServiceIdentityInfoDpo)serviceIdentityInfoDpoOptional.orElse(null)).build();
        }
        if ((catalogResult = this.metaStoreManager.createCatalog(this.getCurrentPolarisContext(), (PolarisBaseEntity)entity, List.of())).alreadyExists()) {
            throw new AlreadyExistsException("Cannot create Catalog %s. Catalog already exists or resolution failed", new Object[]{entity.getName()});
        }
        if (!catalogResult.isSuccess()) {
            throw new IllegalStateException(String.format("Cannot create Catalog %s: %s with extraInfo %s", entity.getName(), catalogResult.getReturnStatus(), catalogResult.getExtraInformation()));
        }
        return PolarisEntity.of((PolarisBaseEntity)catalogResult.getCatalog());
    }

    public void deleteCatalog(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DELETE_CATALOG;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.CATALOG);
        CatalogEntity entity = PolarisAdminService.getCatalogByName(resolutionManifest, name);
        boolean cleanup = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.CLEANUP_ON_CATALOG_DROP);
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)entity, Map.of(), cleanup);
        if (!dropEntityResult.isSuccess()) {
            if (dropEntityResult.failedBecauseNotEmpty()) {
                throw new BadRequestException("Catalog '%s' cannot be dropped, it is not empty", new Object[]{entity.getName()});
            }
            throw new BadRequestException("Catalog '%s' cannot be dropped, concurrent modification detected. Please try again", new Object[]{entity.getName()});
        }
    }

    @Nonnull
    public CatalogEntity getCatalog(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_CATALOG;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.CATALOG);
        return PolarisAdminService.getCatalogByName(resolutionManifest, name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateUpdateCatalogDiffOrThrow(CatalogEntity currentEntity, CatalogEntity newEntity) {
        PolarisStorageConfigurationInfo currentStorageConfig = currentEntity.getStorageConfigurationInfo();
        PolarisStorageConfigurationInfo newStorageConfig = newEntity.getStorageConfigurationInfo();
        if (currentStorageConfig == null || newStorageConfig == null) {
            return;
        }
        if (!currentStorageConfig.getClass().equals(newStorageConfig.getClass())) {
            throw new BadRequestException("Cannot modify storage type of storage config from %s to %s", new Object[]{currentStorageConfig, newStorageConfig});
        }
        if (currentStorageConfig instanceof AwsStorageConfigurationInfo) {
            AwsStorageConfigurationInfo currentAwsConfig = (AwsStorageConfigurationInfo)currentStorageConfig;
            if (newStorageConfig instanceof AwsStorageConfigurationInfo) {
                AwsStorageConfigurationInfo newAwsConfig = (AwsStorageConfigurationInfo)newStorageConfig;
                if (!Objects.equals(currentAwsConfig.getAwsAccountId(), newAwsConfig.getAwsAccountId())) {
                    throw new BadRequestException("Cannot modify Role ARN in storage config from %s to %s", new Object[]{currentStorageConfig, newStorageConfig});
                }
                if ((currentAwsConfig.getExternalId() == null || currentAwsConfig.getExternalId().equals(newAwsConfig.getExternalId())) && (newAwsConfig.getExternalId() == null || newAwsConfig.getExternalId().equals(currentAwsConfig.getExternalId()))) return;
                throw new BadRequestException("Cannot modify ExternalId in storage config from %s to %s", new Object[]{currentStorageConfig, newStorageConfig});
            }
        }
        if (!(currentStorageConfig instanceof AzureStorageConfigurationInfo)) return;
        AzureStorageConfigurationInfo currentAzureConfig = (AzureStorageConfigurationInfo)currentStorageConfig;
        if (!(newStorageConfig instanceof AzureStorageConfigurationInfo)) return;
        AzureStorageConfigurationInfo newAzureConfig = (AzureStorageConfigurationInfo)newStorageConfig;
        if (currentAzureConfig.getTenantId().equals(newAzureConfig.getTenantId()) && newAzureConfig.getTenantId().equals(currentAzureConfig.getTenantId())) return;
        throw new BadRequestException("Cannot modify TenantId in storage config from %s to %s", new Object[]{currentStorageConfig, newStorageConfig});
    }

    @Nonnull
    public CatalogEntity updateCatalog(String name, UpdateCatalogRequest updateRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_CATALOG;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.CATALOG);
        CatalogEntity currentCatalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, name);
        if (currentCatalogEntity.getEntityVersion() != updateRequest.getCurrentEntityVersion().intValue()) {
            throw new CommitConflictException("Failed to update Catalog; currentEntityVersion '%s', expected '%s'", new Object[]{currentCatalogEntity.getEntityVersion(), updateRequest.getCurrentEntityVersion()});
        }
        CatalogEntity.Builder updateBuilder = new CatalogEntity.Builder(currentCatalogEntity);
        String defaultBaseLocation = currentCatalogEntity.getBaseLocation();
        if (updateRequest.getProperties() != null) {
            Map<String, String> updateProperties = this.reservedProperties.removeReservedPropertiesFromUpdate(currentCatalogEntity.getPropertiesAsMap(), updateRequest.getProperties());
            updateBuilder.setProperties(updateProperties);
            String newDefaultBaseLocation = (String)updateRequest.getProperties().get("default-base-location");
            if (Strings.isNullOrEmpty((String)newDefaultBaseLocation)) {
                updateBuilder.setDefaultBaseLocation(defaultBaseLocation);
            } else {
                defaultBaseLocation = newDefaultBaseLocation;
            }
        }
        if (updateRequest.getStorageConfigInfo() != null) {
            updateBuilder.setStorageConfigurationInfo(this.realmConfig, updateRequest.getStorageConfigInfo(), defaultBaseLocation);
        }
        CatalogEntity updatedEntity = updateBuilder.build();
        this.validateUpdateCatalogDiffOrThrow(currentCatalogEntity, updatedEntity);
        if (this.catalogOverlapsWithExistingCatalog(updatedEntity)) {
            throw new ValidationException("Cannot update Catalog %s. One or more of its new locations overlaps with an existing catalog", new Object[]{updatedEntity.getName()});
        }
        CatalogEntity returnedEntity = Optional.ofNullable(CatalogEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)updatedEntity)))).orElseThrow(() -> new CommitConflictException("Concurrent modification on Catalog '%s'; retry later", new Object[]{name}));
        return returnedEntity;
    }

    public List<Catalog> listCatalogs() {
        this.authorizeBasicRootOperationOrThrow(PolarisAuthorizableOperation.LIST_CATALOGS);
        return this.listCatalogsUnsafe().map(catalogEntity -> catalogEntity.asCatalog(this.getServiceIdentityProvider())).toList();
    }

    private Stream<CatalogEntity> listCatalogsUnsafe() {
        return this.metaStoreManager.loadEntitiesAll(this.getCurrentPolarisContext(), null, PolarisEntityType.CATALOG, PolarisEntitySubType.ANY_SUBTYPE).stream().map(CatalogEntity::of);
    }

    public PrincipalWithCredentials createPrincipal(PrincipalEntity entity) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_PRINCIPAL;
        this.authorizeBasicRootOperationOrThrow(op);
        if (FederatedEntities.isFederated((PolarisBaseEntity)entity)) {
            throw new ValidationException("Cannot create a federated principal", new Object[0]);
        }
        Preconditions.checkArgument((entity.getId() == -1L ? 1 : 0) != 0, (Object)"Entity to be created must have no ID assigned");
        CreatePrincipalResult principalResult = this.metaStoreManager.createPrincipal(this.getCurrentPolarisContext(), ((PrincipalEntity.Builder)((PrincipalEntity.Builder)new PrincipalEntity.Builder(entity).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCreateTimestamp(System.currentTimeMillis())).build());
        if (principalResult.alreadyExists()) {
            throw new AlreadyExistsException("Cannot create Principal %s. Principal already exists or resolution failed", new Object[]{entity.getName()});
        }
        return new PrincipalWithCredentials(principalResult.getPrincipal().asPrincipal(), new PrincipalWithCredentialsCredentials(principalResult.getPrincipalSecrets().getPrincipalClientId(), principalResult.getPrincipalSecrets().getMainSecret()));
    }

    public void deletePrincipal(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DELETE_PRINCIPAL;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL);
        PrincipalEntity entity = PolarisAdminService.getPrincipalByName(resolutionManifest, name);
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)entity, Map.of(), false);
        if (!dropEntityResult.isSuccess()) {
            if (dropEntityResult.isEntityUnDroppable()) {
                throw new BadRequestException("Root principal cannot be dropped", new Object[0]);
            }
            throw new BadRequestException("Root principal cannot be dropped, concurrent modification detected. Please try again", new Object[0]);
        }
    }

    @Nonnull
    public PrincipalEntity getPrincipal(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_PRINCIPAL;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL);
        return PolarisAdminService.getPrincipalByName(resolutionManifest, name);
    }

    @Nonnull
    public PrincipalEntity updatePrincipal(String name, UpdatePrincipalRequest updateRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_PRINCIPAL;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL);
        PrincipalEntity currentPrincipalEntity = PolarisAdminService.getPrincipalByName(resolutionManifest, name);
        if (FederatedEntities.isFederated((PolarisBaseEntity)currentPrincipalEntity)) {
            throw new ValidationException("Cannot update a federated principal: %s", new Object[]{currentPrincipalEntity.getName()});
        }
        if (currentPrincipalEntity.getEntityVersion() != updateRequest.getCurrentEntityVersion().intValue()) {
            throw new CommitConflictException("Failed to update Principal; currentEntityVersion '%s', expected '%s'", new Object[]{currentPrincipalEntity.getEntityVersion(), updateRequest.getCurrentEntityVersion()});
        }
        PrincipalEntity.Builder updateBuilder = new PrincipalEntity.Builder(currentPrincipalEntity);
        if (updateRequest.getProperties() != null) {
            Map<String, String> updateProperties = this.reservedProperties.removeReservedPropertiesFromUpdate(currentPrincipalEntity.getPropertiesAsMap(), updateRequest.getProperties());
            updateBuilder.setProperties(updateProperties);
        }
        PrincipalEntity updatedEntity = updateBuilder.build();
        PrincipalEntity returnedEntity = Optional.ofNullable(PrincipalEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)updatedEntity)))).orElseThrow(() -> new CommitConflictException("Concurrent modification on Principal '%s'; retry later", new Object[]{name}));
        return returnedEntity;
    }

    @Nonnull
    private PrincipalWithCredentials resetCredentialsHelper(PolarisResolutionManifest resolutionManifest, String principalName, String customClientId, String customClientSecret) {
        PrincipalEntity currentPrincipalEntity = PolarisAdminService.getPrincipalByName(resolutionManifest, principalName);
        if (FederatedEntities.isFederated((PolarisBaseEntity)currentPrincipalEntity)) {
            throw new ValidationException("Cannot reset credentials for a federated principal: %s", new Object[]{principalName});
        }
        PolarisPrincipalSecrets currentSecrets = this.metaStoreManager.loadPrincipalSecrets(this.getCurrentPolarisContext(), currentPrincipalEntity.getClientId()).getPrincipalSecrets();
        if (currentSecrets != null) {
            this.metaStoreManager.deletePrincipalSecrets(this.getCurrentPolarisContext(), currentPrincipalEntity.getClientId(), currentPrincipalEntity.getId());
        }
        PrincipalEntity newPrincipalEntity = currentPrincipalEntity;
        if (customClientId != null) {
            PrincipalEntity.Builder updateBuilder = new PrincipalEntity.Builder(newPrincipalEntity);
            updateBuilder.setClientId(customClientId);
            PrincipalEntity updatedNewPrincipalEntity = updateBuilder.build();
            newPrincipalEntity = Optional.ofNullable(PrincipalEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)updatedNewPrincipalEntity)))).orElseThrow(() -> new CommitConflictException("Concurrent modification on Principal '%s'; retry later", new Object[]{principalName}));
        }
        String resolvedClientId = customClientId != null ? customClientId : currentPrincipalEntity.getClientId();
        PolarisPrincipalSecrets newSecrets = this.metaStoreManager.resetPrincipalSecrets(this.getCurrentPolarisContext(), currentPrincipalEntity.getId(), resolvedClientId, customClientSecret).getPrincipalSecrets();
        if (newSecrets == null) {
            throw new IllegalStateException(String.format("Failed to %s secrets for principal '%s'", "reset", principalName));
        }
        return new PrincipalWithCredentials(newPrincipalEntity.asPrincipal(), new PrincipalWithCredentialsCredentials(newSecrets.getPrincipalClientId(), newSecrets.getMainSecret()));
    }

    @Nonnull
    private PrincipalWithCredentials rotateOrResetCredentialsHelper(PolarisResolutionManifest resolutionManifest, String principalName, boolean shouldReset) {
        PrincipalEntity currentPrincipalEntity = PolarisAdminService.getPrincipalByName(resolutionManifest, principalName);
        if (FederatedEntities.isFederated((PolarisBaseEntity)currentPrincipalEntity)) {
            throw new ValidationException("Cannot rotate/reset credentials for a federated principal: %s", new Object[]{principalName});
        }
        PolarisPrincipalSecrets currentSecrets = this.metaStoreManager.loadPrincipalSecrets(this.getCurrentPolarisContext(), currentPrincipalEntity.getClientId()).getPrincipalSecrets();
        if (currentSecrets == null) {
            throw new IllegalArgumentException(String.format("Failed to load current secrets for principal '%s'", principalName));
        }
        PolarisPrincipalSecrets newSecrets = this.metaStoreManager.rotatePrincipalSecrets(this.getCurrentPolarisContext(), currentPrincipalEntity.getClientId(), currentPrincipalEntity.getId(), shouldReset, currentSecrets.getMainSecretHash()).getPrincipalSecrets();
        if (newSecrets == null) {
            throw new IllegalStateException(String.format("Failed to %s secrets for principal '%s'", shouldReset ? "reset" : "rotate", principalName));
        }
        PolarisEntity newPrincipal = PolarisEntity.of((EntityResult)this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), 0L, currentPrincipalEntity.getId(), currentPrincipalEntity.getType()));
        return new PrincipalWithCredentials(PrincipalEntity.of((PolarisBaseEntity)newPrincipal).asPrincipal(), new PrincipalWithCredentialsCredentials(newSecrets.getPrincipalClientId(), newSecrets.getMainSecret()));
    }

    @Nonnull
    public PrincipalWithCredentials rotateCredentials(String principalName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ROTATE_CREDENTIALS;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalName, PolarisEntityType.PRINCIPAL);
        return this.rotateOrResetCredentialsHelper(resolutionManifest, principalName, false);
    }

    @Nonnull
    public PrincipalWithCredentials resetCredentials(String principalName, ResetPrincipalRequest resetPrincipalRequest) {
        FeatureConfiguration.enforceFeatureEnabledOrThrow((RealmConfig)this.realmConfig, (FeatureConfiguration)FeatureConfiguration.ENABLE_CREDENTIAL_RESET);
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.RESET_CREDENTIALS;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalName, PolarisEntityType.PRINCIPAL);
        String customClientId = resetPrincipalRequest.getClientId();
        String customClientSecret = resetPrincipalRequest.getClientSecret();
        return this.resetCredentialsHelper(resolutionManifest, principalName, customClientId, customClientSecret);
    }

    public List<Principal> listPrincipals() {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_PRINCIPALS;
        this.authorizeBasicRootOperationOrThrow(op);
        return this.metaStoreManager.loadEntitiesAll(this.getCurrentPolarisContext(), null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE).stream().map(PrincipalEntity::of).map(PrincipalEntity::asPrincipal).toList();
    }

    public PolarisEntity createPrincipalRole(PolarisEntity entity) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_PRINCIPAL_ROLE;
        this.authorizeBasicRootOperationOrThrow(op);
        Preconditions.checkArgument((entity.getId() == -1L ? 1 : 0) != 0, (Object)"Entity to be created must have no ID assigned");
        PolarisEntity returnedEntity = PolarisEntity.of((EntityResult)this.metaStoreManager.createEntityIfNotExists(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)((PolarisEntity.Builder)((PolarisEntity.Builder)new PolarisEntity.Builder(entity).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCreateTimestamp(System.currentTimeMillis())).build()));
        if (returnedEntity == null) {
            throw new AlreadyExistsException("Cannot create PrincipalRole %s. PrincipalRole already exists or resolution failed", new Object[]{entity.getName()});
        }
        return returnedEntity;
    }

    public void deletePrincipalRole(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DELETE_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL_ROLE);
        PrincipalRoleEntity entity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, name);
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)entity, Map.of(), true);
        if (!dropEntityResult.isSuccess()) {
            if (dropEntityResult.isEntityUnDroppable()) {
                throw new BadRequestException("Polaris service admin principal role cannot be dropped", new Object[0]);
            }
            throw new BadRequestException("Polaris service admin principal role cannot be dropped, concurrent modification detected. Please try again", new Object[0]);
        }
    }

    @Nonnull
    public PrincipalRoleEntity getPrincipalRole(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL_ROLE);
        return PolarisAdminService.getPrincipalRoleByName(resolutionManifest, name);
    }

    @Nonnull
    public PrincipalRoleEntity updatePrincipalRole(String name, UpdatePrincipalRoleRequest updateRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL_ROLE);
        PrincipalRoleEntity currentPrincipalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, name);
        if (currentPrincipalRoleEntity.getEntityVersion() != updateRequest.getCurrentEntityVersion().intValue()) {
            throw new CommitConflictException("Failed to update PrincipalRole; currentEntityVersion '%s', expected '%s'", new Object[]{currentPrincipalRoleEntity.getEntityVersion(), updateRequest.getCurrentEntityVersion()});
        }
        PrincipalRoleEntity.Builder updateBuilder = new PrincipalRoleEntity.Builder(currentPrincipalRoleEntity);
        if (updateRequest.getProperties() != null) {
            Map<String, String> updateProperties = this.reservedProperties.removeReservedPropertiesFromUpdate(currentPrincipalRoleEntity.getPropertiesAsMap(), updateRequest.getProperties());
            updateBuilder.setProperties(updateProperties);
        }
        PrincipalRoleEntity updatedEntity = updateBuilder.build();
        PrincipalRoleEntity returnedEntity = Optional.ofNullable(PrincipalRoleEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)updatedEntity)))).orElseThrow(() -> new CommitConflictException("Concurrent modification on PrincipalRole '%s'; retry later", new Object[]{name}));
        return returnedEntity;
    }

    public List<PrincipalRole> listPrincipalRoles() {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_PRINCIPAL_ROLES;
        this.authorizeBasicRootOperationOrThrow(op);
        return this.metaStoreManager.loadEntitiesAll(this.getCurrentPolarisContext(), null, PolarisEntityType.PRINCIPAL_ROLE, PolarisEntitySubType.NULL_SUBTYPE).stream().map(PrincipalRoleEntity::of).map(PrincipalRoleEntity::asPrincipalRole).toList();
    }

    public PolarisEntity createCatalogRole(String catalogName, PolarisEntity entity) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, catalogName, PolarisEntityType.CATALOG);
        Preconditions.checkArgument((entity.getId() == -1L ? 1 : 0) != 0, (Object)"Entity to be created must have no ID assigned");
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        PolarisEntity returnedEntity = PolarisEntity.of((EntityResult)this.metaStoreManager.createEntityIfNotExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisBaseEntity)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)new PolarisEntity.Builder(entity).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCatalogId(catalogEntity.getId())).setParentId(catalogEntity.getId())).setCreateTimestamp(System.currentTimeMillis())).build()));
        if (returnedEntity == null) {
            throw new AlreadyExistsException("Cannot create CatalogRole %s in %s. CatalogRole already exists or resolution failed", new Object[]{entity.getName(), catalogName});
        }
        return returnedEntity;
    }

    public void deleteCatalogRole(String catalogName, String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DELETE_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, name);
        PolarisResolvedPathWrapper resolvedCatalogRoleEntity = resolutionManifest.getResolvedPath((Object)name);
        if (resolvedCatalogRoleEntity == null) {
            throw new NotFoundException("CatalogRole %s not found in catalog %s", new Object[]{name, catalogName});
        }
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)resolvedCatalogRoleEntity.getRawParentPath()), (PolarisBaseEntity)resolvedCatalogRoleEntity.getRawLeafEntity(), Map.of(), true);
        if (!dropEntityResult.isSuccess()) {
            if (dropEntityResult.isEntityUnDroppable()) {
                throw new BadRequestException("Catalog admin role cannot be dropped", new Object[0]);
            }
            throw new BadRequestException("Catalog admin role cannot be dropped, concurrent modification detected. Please try again", new Object[0]);
        }
    }

    @Nonnull
    public CatalogRoleEntity getCatalogRole(String catalogName, String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, name);
        return PolarisAdminService.getCatalogRoleByName(resolutionManifest, name);
    }

    @Nonnull
    public CatalogRoleEntity updateCatalogRole(String catalogName, String name, UpdateCatalogRoleRequest updateRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, name);
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity currentCatalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, name);
        if (currentCatalogRoleEntity.getEntityVersion() != updateRequest.getCurrentEntityVersion().intValue()) {
            throw new CommitConflictException("Failed to update CatalogRole; currentEntityVersion '%s', expected '%s'", new Object[]{currentCatalogRoleEntity.getEntityVersion(), updateRequest.getCurrentEntityVersion()});
        }
        CatalogRoleEntity.Builder updateBuilder = new CatalogRoleEntity.Builder(currentCatalogRoleEntity);
        if (updateRequest.getProperties() != null) {
            Map<String, String> updateProperties = this.reservedProperties.removeReservedPropertiesFromUpdate(currentCatalogRoleEntity.getPropertiesAsMap(), updateRequest.getProperties());
            updateBuilder.setProperties(updateProperties);
        }
        CatalogRoleEntity updatedEntity = updateBuilder.build();
        CatalogRoleEntity returnedEntity = Optional.ofNullable(CatalogRoleEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisBaseEntity)updatedEntity)))).orElseThrow(() -> new CommitConflictException("Concurrent modification on CatalogRole '%s'; retry later", new Object[]{name}));
        return returnedEntity;
    }

    public List<CatalogRole> listCatalogRoles(String catalogName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_CATALOG_ROLES;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, catalogName, PolarisEntityType.CATALOG);
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        List catalogPath = PolarisEntity.toCoreList(List.of(catalogEntity));
        return this.metaStoreManager.loadEntitiesAll(this.getCurrentPolarisContext(), catalogPath, PolarisEntityType.CATALOG_ROLE, PolarisEntitySubType.NULL_SUBTYPE).stream().map(CatalogRoleEntity::of).map(CatalogRoleEntity::asCatalogRole).toList();
    }

    public PrivilegeResult assignPrincipalRole(String principalName, String principalRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ASSIGN_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnPrincipalRoleToPrincipalOperationOrThrow(op, principalRoleName, principalName);
        PrincipalEntity principalEntity = PolarisAdminService.getPrincipalByName(resolutionManifest, principalName);
        if (FederatedEntities.isFederated((PolarisBaseEntity)principalEntity)) {
            throw new ValidationException("Cannot assign a role to a federated principal", new Object[0]);
        }
        PrincipalRoleEntity principalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, principalRoleName);
        if (FederatedEntities.isFederated((PolarisBaseEntity)principalRoleEntity)) {
            throw new ValidationException("Cannot assign a federated role to a principal", new Object[0]);
        }
        return this.metaStoreManager.grantUsageOnRoleToGrantee(this.getCurrentPolarisContext(), null, (PolarisEntityCore)principalRoleEntity, (PolarisEntityCore)principalEntity);
    }

    public PrivilegeResult revokePrincipalRole(String principalName, String principalRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnPrincipalRoleToPrincipalOperationOrThrow(op, principalRoleName, principalName);
        PrincipalEntity principalEntity = PolarisAdminService.getPrincipalByName(resolutionManifest, principalName);
        if (FederatedEntities.isFederated((PolarisBaseEntity)principalEntity)) {
            throw new ValidationException("Cannot revoke a role from a federated principal", new Object[0]);
        }
        PrincipalRoleEntity principalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, principalRoleName);
        if (FederatedEntities.isFederated((PolarisBaseEntity)principalRoleEntity)) {
            throw new ValidationException("Cannot revoke a federated role from a principal", new Object[0]);
        }
        return this.metaStoreManager.revokeUsageOnRoleFromGrantee(this.getCurrentPolarisContext(), null, (PolarisEntityCore)principalRoleEntity, (PolarisEntityCore)principalEntity);
    }

    public List<PolarisEntity> listPrincipalRolesAssigned(String principalName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_PRINCIPAL_ROLES_ASSIGNED;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalName, PolarisEntityType.PRINCIPAL);
        PrincipalEntity principalEntity = PolarisAdminService.getPrincipalByName(resolutionManifest, principalName);
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsToGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)principalEntity);
        return this.buildEntitiesFromGrantResults(grantList, false, PolarisEntityType.PRINCIPAL_ROLE, null);
    }

    public PrivilegeResult assignCatalogRoleToPrincipalRole(String principalRoleName, String catalogName, String catalogRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ASSIGN_CATALOG_ROLE_TO_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnCatalogRoleToPrincipalRoleOperationOrThrow(op, catalogName, catalogRoleName, principalRoleName);
        PrincipalRoleEntity principalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, principalRoleName);
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        return this.metaStoreManager.grantUsageOnRoleToGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogEntity, (PolarisEntityCore)catalogRoleEntity, (PolarisEntityCore)principalRoleEntity);
    }

    public PrivilegeResult revokeCatalogRoleFromPrincipalRole(String principalRoleName, String catalogName, String catalogRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_CATALOG_ROLE_FROM_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnCatalogRoleToPrincipalRoleOperationOrThrow(op, catalogName, catalogRoleName, principalRoleName);
        PrincipalRoleEntity principalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, principalRoleName);
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        return this.metaStoreManager.revokeUsageOnRoleFromGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogEntity, (PolarisEntityCore)catalogRoleEntity, (PolarisEntityCore)principalRoleEntity);
    }

    public List<PolarisEntity> listAssigneePrincipalsForPrincipalRole(String principalRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_ASSIGNEE_PRINCIPALS_FOR_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        PrincipalRoleEntity principalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, principalRoleName);
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsOnSecurable(this.getCurrentPolarisContext(), (PolarisEntityCore)principalRoleEntity);
        return this.buildEntitiesFromGrantResults(grantList, true, PolarisEntityType.PRINCIPAL, null);
    }

    private List<PolarisEntity> buildEntitiesFromGrantResults(@Nonnull LoadGrantsResult grantList, boolean grantees, PolarisEntityType entityType, @Nullable Function<PolarisGrantRecord, Boolean> grantFilter) {
        Map granteeMap = grantList.getEntitiesAsMap();
        ArrayList<PolarisEntity> toReturn = new ArrayList<PolarisEntity>(grantList.getGrantRecords().size());
        for (PolarisGrantRecord grantRecord : grantList.getGrantRecords()) {
            long entityId;
            long catalogId;
            PolarisBaseEntity entity;
            if (grantFilter != null && !grantFilter.apply(grantRecord).booleanValue() || (entity = this.getOrLoadEntity(granteeMap, catalogId = grantees ? grantRecord.getGranteeCatalogId() : grantRecord.getSecurableCatalogId(), entityId = grantees ? grantRecord.getGranteeId() : grantRecord.getSecurableId(), entityType)) == null) continue;
            toReturn.add(PolarisEntity.of((PolarisBaseEntity)entity));
        }
        return toReturn;
    }

    public List<PolarisEntity> listCatalogRolesForPrincipalRole(String principalRoleName, String catalogName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_CATALOG_ROLES_FOR_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, catalogName);
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        PrincipalRoleEntity principalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, principalRoleName);
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsToGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)principalRoleEntity);
        return this.buildEntitiesFromGrantResults(grantList, false, PolarisEntityType.CATALOG_ROLE, grantRec -> grantRec.getSecurableCatalogId() == catalogEntity.getId());
    }

    public PrivilegeResult grantPrivilegeOnRootContainerToPrincipalRole(String principalRoleName, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_ROOT_GRANT_TO_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnRootContainerToPrincipalRoleOperationOrThrow(op, principalRoleName);
        PolarisEntity rootContainerEntity = resolutionManifest.getResolvedRootContainerEntityAsPath().getRawLeafEntity();
        PrincipalRoleEntity principalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, principalRoleName);
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)principalRoleEntity, null, (PolarisEntityCore)rootContainerEntity, privilege);
    }

    public PrivilegeResult revokePrivilegeOnRootContainerFromPrincipalRole(String principalRoleName, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_ROOT_GRANT_FROM_PRINCIPAL_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnRootContainerToPrincipalRoleOperationOrThrow(op, principalRoleName);
        PolarisEntity rootContainerEntity = resolutionManifest.getResolvedRootContainerEntityAsPath().getRawLeafEntity();
        PrincipalRoleEntity principalRoleEntity = PolarisAdminService.getPrincipalRoleByName(resolutionManifest, principalRoleName);
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)principalRoleEntity, null, (PolarisEntityCore)rootContainerEntity, privilege);
    }

    public PrivilegeResult grantPrivilegeOnCatalogToRole(String catalogName, String catalogRoleName, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_CATALOG_GRANT_TO_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnCatalogOperationOrThrow(op, catalogName, catalogRoleName);
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisEntityCore)catalogEntity, privilege);
    }

    public PrivilegeResult revokePrivilegeOnCatalogFromRole(String catalogName, String catalogRoleName, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_CATALOG_GRANT_FROM_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnCatalogOperationOrThrow(op, catalogName, catalogRoleName);
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisEntityCore)catalogEntity, privilege);
    }

    public PrivilegeResult grantPrivilegeOnNamespaceToRole(String catalogName, String catalogRoleName, Namespace namespace, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_NAMESPACE_GRANT_TO_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnNamespaceOperationOrThrow(op, catalogName, namespace, catalogRoleName);
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        PolarisResolvedPathWrapper resolvedPathWrapper = resolutionManifest.getResolvedPath((Object)namespace);
        if (resolvedPathWrapper == null || !resolvedPathWrapper.isFullyResolvedNamespace(catalogName, namespace)) {
            boolean rbacForFederatedCatalogsEnabled = (Boolean)this.getCurrentPolarisContext().getRealmConfig().getConfig((PolarisConfiguration)FeatureConfiguration.ENABLE_SUB_CATALOG_RBAC_FOR_FEDERATED_CATALOGS, catalogEntity);
            if (resolutionManifest.getIsPassthroughFacade() && rbacForFederatedCatalogsEnabled) {
                if ((resolvedPathWrapper = this.createSyntheticNamespaceEntities(resolutionManifest, catalogEntity, namespace, resolvedPathWrapper)) == null || !resolvedPathWrapper.isFullyResolvedNamespace(catalogName, namespace)) {
                    throw new RuntimeException(String.format("Failed to create synthetic namespace entities for namespace %s in catalog %s", namespace, catalogName));
                }
            } else {
                throw new NotFoundException("Namespace %s not found", new Object[]{namespace});
            }
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity namespaceEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)namespaceEntity, privilege);
    }

    public PrivilegeResult revokePrivilegeOnNamespaceFromRole(String catalogName, String catalogRoleName, Namespace namespace, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_NAMESPACE_GRANT_FROM_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnNamespaceOperationOrThrow(op, catalogName, namespace, catalogRoleName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        PolarisResolvedPathWrapper resolvedPathWrapper = resolutionManifest.getResolvedPath((Object)namespace);
        if (resolvedPathWrapper == null || !resolvedPathWrapper.isFullyResolvedNamespace(catalogName, namespace)) {
            throw new NotFoundException("Namespace %s not found", new Object[]{namespace});
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity namespaceEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)namespaceEntity, privilege);
    }

    private PolarisResolvedPathWrapper createSyntheticNamespaceEntities(PolarisResolutionManifest resolutionManifest, CatalogEntity catalogEntity, Namespace namespace, PolarisResolvedPathWrapper existingPath) {
        PolarisEntity entity;
        if (existingPath == null) {
            throw new IllegalStateException(String.format("Catalog entity %s does not exist.", catalogEntity.getName()));
        }
        ArrayList<NamespaceEntity> completePath = new ArrayList<NamespaceEntity>(existingPath.getRawFullPath());
        PolarisEntity currentParent = existingPath.getRawLeafEntity();
        String[] allNamespaceLevels = namespace.levels();
        int numMatchingLevels = 0;
        Iterator iterator = completePath.subList(1, completePath.size()).iterator();
        while (iterator.hasNext() && (entity = (PolarisEntity)iterator.next()).getName().equals(allNamespaceLevels[numMatchingLevels])) {
            ++numMatchingLevels;
        }
        for (int i = numMatchingLevels; i < allNamespaceLevels.length; ++i) {
            String[] namespacePart = Arrays.copyOfRange(allNamespaceLevels, 0, i + 1);
            String leafNamespace = namespacePart[namespacePart.length - 1];
            Namespace currentNamespace = Namespace.of((String[])namespacePart);
            NamespaceEntity syntheticNamespace = ((NamespaceEntity.Builder)((NamespaceEntity.Builder)((NamespaceEntity.Builder)((NamespaceEntity.Builder)new NamespaceEntity.Builder(currentNamespace).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCatalogId(catalogEntity.getId())).setParentId(currentParent.getId())).setCreateTimestamp(System.currentTimeMillis())).build();
            EntityResult result = this.metaStoreManager.createEntityIfNotExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList(completePath), (PolarisBaseEntity)syntheticNamespace);
            if (result.isSuccess()) {
                syntheticNamespace = PolarisEntity.of((PolarisBaseEntity)result.getEntity());
            } else if (result.getReturnStatus() == BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS) {
                PolarisEntity partialLeafEntity;
                PolarisResolvedPathWrapper partialPath = resolutionManifest.getPassthroughResolvedPath((Object)namespace);
                PolarisEntity polarisEntity = partialLeafEntity = partialPath != null ? partialPath.getRawLeafEntity() : null;
                if (partialLeafEntity == null || !partialLeafEntity.getName().equals(leafNamespace) || partialLeafEntity.getType() != PolarisEntityType.NAMESPACE) {
                    throw new RuntimeException(String.format("Failed to create or find namespace entity '%s' in federated catalog '%s'", leafNamespace, catalogEntity.getName()));
                }
                syntheticNamespace = partialLeafEntity;
            } else {
                throw new RuntimeException(String.format("Failed to create or find namespace entity '%s' in federated catalog '%s'", leafNamespace, catalogEntity.getName()));
            }
            completePath.add(syntheticNamespace);
            currentParent = syntheticNamespace;
        }
        PolarisResolvedPathWrapper resolvedPathWrapper = resolutionManifest.getPassthroughResolvedPath((Object)namespace);
        return resolvedPathWrapper;
    }

    public PrivilegeResult grantPrivilegeOnTableToRole(String catalogName, String catalogRoleName, TableIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_TABLE_GRANT_TO_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnTableLikeOperationOrThrow(op, catalogName, List.of(PolarisEntitySubType.GENERIC_TABLE, PolarisEntitySubType.ICEBERG_TABLE), identifier, catalogRoleName);
        return this.grantPrivilegeOnTableLikeToRole(resolutionManifest, catalogName, catalogRoleName, identifier, List.of(PolarisEntitySubType.GENERIC_TABLE, PolarisEntitySubType.ICEBERG_TABLE), privilege);
    }

    public PrivilegeResult revokePrivilegeOnTableFromRole(String catalogName, String catalogRoleName, TableIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_TABLE_GRANT_FROM_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnTableLikeOperationOrThrow(op, catalogName, List.of(PolarisEntitySubType.GENERIC_TABLE, PolarisEntitySubType.ICEBERG_TABLE), identifier, catalogRoleName);
        return this.revokePrivilegeOnTableLikeFromRole(resolutionManifest, catalogName, catalogRoleName, identifier, List.of(PolarisEntitySubType.GENERIC_TABLE, PolarisEntitySubType.ICEBERG_TABLE), privilege);
    }

    public PrivilegeResult grantPrivilegeOnViewToRole(String catalogName, String catalogRoleName, TableIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_VIEW_GRANT_TO_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnTableLikeOperationOrThrow(op, catalogName, List.of(PolarisEntitySubType.ICEBERG_VIEW), identifier, catalogRoleName);
        return this.grantPrivilegeOnTableLikeToRole(resolutionManifest, catalogName, catalogRoleName, identifier, List.of(PolarisEntitySubType.ICEBERG_VIEW), privilege);
    }

    public PrivilegeResult revokePrivilegeOnViewFromRole(String catalogName, String catalogRoleName, TableIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_VIEW_GRANT_FROM_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnTableLikeOperationOrThrow(op, catalogName, List.of(PolarisEntitySubType.ICEBERG_VIEW), identifier, catalogRoleName);
        return this.revokePrivilegeOnTableLikeFromRole(resolutionManifest, catalogName, catalogRoleName, identifier, List.of(PolarisEntitySubType.ICEBERG_VIEW), privilege);
    }

    public PrivilegeResult grantPrivilegeOnPolicyToRole(String catalogName, String catalogRoleName, PolicyIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_POLICY_GRANT_TO_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnPolicyOperationOrThrow(op, catalogName, identifier, catalogRoleName);
        return this.grantPrivilegeOnPolicyEntityToRole(resolutionManifest, catalogName, catalogRoleName, identifier, privilege);
    }

    public PrivilegeResult revokePrivilegeOnPolicyFromRole(String catalogName, String catalogRoleName, PolicyIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_POLICY_GRANT_FROM_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeGrantOnPolicyOperationOrThrow(op, catalogName, identifier, catalogRoleName);
        return this.revokePrivilegeOnPolicyEntityFromRole(resolutionManifest, catalogName, catalogRoleName, identifier, privilege);
    }

    public List<PolarisEntity> listAssigneePrincipalRolesForCatalogRole(String catalogName, String catalogRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_ASSIGNEE_PRINCIPAL_ROLES_FOR_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, catalogRoleName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsOnSecurable(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity);
        return this.buildEntitiesFromGrantResults(grantList, true, PolarisEntityType.PRINCIPAL_ROLE, null);
    }

    public List<GrantResource> listGrantsForCatalogRole(String catalogName, String catalogRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_GRANTS_FOR_CATALOG_ROLE;
        PolarisResolutionManifest resolutionManifest = this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, catalogRoleName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsToGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity);
        ArrayList<CatalogGrant> catalogGrants = new ArrayList<CatalogGrant>();
        ArrayList<CatalogGrant> namespaceGrants = new ArrayList<CatalogGrant>();
        ArrayList<PolicyGrant> tableGrants = new ArrayList<PolicyGrant>();
        ArrayList<PolicyGrant> viewGrants = new ArrayList<PolicyGrant>();
        ArrayList<PolicyGrant> policyGrants = new ArrayList<PolicyGrant>();
        Map entityMap = grantList.getEntitiesAsMap();
        block6: for (PolarisGrantRecord record : grantList.getGrantRecords()) {
            PolarisPrivilege privilege = PolarisPrivilege.fromCode((int)record.getPrivilegeCode());
            PolarisBaseEntity baseEntity = this.getOrLoadEntityForGrant(entityMap, record);
            if (baseEntity == null) continue;
            switch (baseEntity.getType()) {
                case CATALOG: {
                    CatalogGrant grant = new CatalogGrant(CatalogPrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.CATALOG);
                    catalogGrants.add(grant);
                    continue block6;
                }
                case NAMESPACE: {
                    CatalogGrant grant = new NamespaceGrant(List.of(NamespaceEntity.of((PolarisBaseEntity)baseEntity).asNamespace().levels()), NamespacePrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.NAMESPACE);
                    namespaceGrants.add(grant);
                    continue block6;
                }
                case TABLE_LIKE: {
                    PolicyGrant grant;
                    TableIdentifier identifier;
                    if (baseEntity.getSubType() == PolarisEntitySubType.ICEBERG_TABLE || baseEntity.getSubType() == PolarisEntitySubType.GENERIC_TABLE) {
                        identifier = IcebergTableLikeEntity.of((PolarisBaseEntity)baseEntity).getTableIdentifier();
                        grant = new TableGrant(List.of(identifier.namespace().levels()), identifier.name(), TablePrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.TABLE);
                        tableGrants.add(grant);
                        continue block6;
                    }
                    if (baseEntity.getSubType() == PolarisEntitySubType.ICEBERG_VIEW) {
                        identifier = IcebergTableLikeEntity.of((PolarisBaseEntity)baseEntity).getTableIdentifier();
                        grant = new ViewGrant(List.of(identifier.namespace().levels()), identifier.name(), ViewPrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.VIEW);
                        viewGrants.add(grant);
                        continue block6;
                    }
                    throw new IllegalStateException("Unrecognized entity subtype " + String.valueOf(baseEntity.getSubType()));
                }
                case POLICY: {
                    PolicyEntity policyEntity = PolicyEntity.of((PolarisBaseEntity)baseEntity);
                    PolicyGrant grant = new PolicyGrant(Arrays.asList(policyEntity.getParentNamespace().levels()), policyEntity.getName(), PolicyPrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.POLICY);
                    policyGrants.add(grant);
                    continue block6;
                }
            }
            throw new IllegalArgumentException(String.format("Unexpected entity type '%s' listing grants for catalogRole '%s' in catalog '%s'", baseEntity.getType(), catalogRoleName, catalogName));
        }
        ArrayList<GrantResource> allGrants = new ArrayList<GrantResource>();
        allGrants.addAll(catalogGrants);
        allGrants.addAll(namespaceGrants);
        allGrants.addAll(tableGrants);
        allGrants.addAll(viewGrants);
        allGrants.addAll(policyGrants);
        return allGrants;
    }

    @Nullable
    private PolarisBaseEntity getOrLoadEntity(@Nullable Map<Long, PolarisBaseEntity> entitiesMap, long catalogId, long id, PolarisEntityType entityType) {
        return entitiesMap == null ? this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), catalogId, id, entityType).getEntity() : entitiesMap.get(id);
    }

    @Nullable
    private PolarisBaseEntity getOrLoadEntityForGrant(@Nullable Map<Long, PolarisBaseEntity> entitiesMap, PolarisGrantRecord record) {
        if (entitiesMap != null) {
            return entitiesMap.get(record.getSecurableId());
        }
        for (PolarisEntityType type : PolarisEntityType.values()) {
            EntityResult entityResult = this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), record.getSecurableCatalogId(), record.getSecurableId(), type);
            if (!entityResult.isSuccess()) continue;
            return entityResult.getEntity();
        }
        return null;
    }

    private PrivilegeResult grantPrivilegeOnTableLikeToRole(PolarisResolutionManifest resolutionManifest, String catalogName, String catalogRoleName, TableIdentifier identifier, List<PolarisEntitySubType> subTypes, PolarisPrivilege privilege) {
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        PolarisResolvedPathWrapper resolvedPathWrapper = resolutionManifest.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE);
        if (resolvedPathWrapper == null || !subTypes.contains(resolvedPathWrapper.getRawLeafEntity().getSubType())) {
            boolean rbacForFederatedCatalogsEnabled = (Boolean)this.getCurrentPolarisContext().getRealmConfig().getConfig((PolarisConfiguration)FeatureConfiguration.ENABLE_SUB_CATALOG_RBAC_FOR_FEDERATED_CATALOGS, catalogEntity);
            if (resolutionManifest.getIsPassthroughFacade() && rbacForFederatedCatalogsEnabled) {
                if ((resolvedPathWrapper = this.createSyntheticTableLikeEntities(resolutionManifest, catalogEntity, identifier, subTypes, resolvedPathWrapper)) == null || !subTypes.contains(resolvedPathWrapper.getRawLeafEntity().getSubType())) {
                    throw new RuntimeException(String.format("Failed to create synthetic table-like entity for table %s in catalog %s", identifier.name(), catalogEntity.getName()));
                }
            } else {
                CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, subTypes);
            }
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity tableLikeEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)tableLikeEntity, privilege);
    }

    private PolarisResolvedPathWrapper createSyntheticTableLikeEntities(PolarisResolutionManifest resolutionManifest, CatalogEntity catalogEntity, TableIdentifier identifier, List<PolarisEntitySubType> subTypes, PolarisResolvedPathWrapper existingPathWrapper) {
        PolarisEntity leafEntity;
        PolarisResolvedPathWrapper resolvedNamespacePathWrapper;
        Namespace namespace = identifier.namespace();
        PolarisResolvedPathWrapper polarisResolvedPathWrapper = resolvedNamespacePathWrapper = !namespace.isEmpty() ? this.createSyntheticNamespaceEntities(resolutionManifest, catalogEntity, namespace, existingPathWrapper) : existingPathWrapper;
        if (resolvedNamespacePathWrapper == null || !namespace.isEmpty() && !resolvedNamespacePathWrapper.isFullyResolvedNamespace(catalogEntity.getName(), namespace)) {
            throw new RuntimeException(String.format("Failed to create synthetic namespace entities for namespace %s in catalog %s", namespace.toString(), catalogEntity.getName()));
        }
        PolarisEntity parentNamespaceEntity = resolvedNamespacePathWrapper.getRawLeafEntity();
        PolarisEntitySubType syntheticEntitySubType = PolarisAdminService.selectEntitySubType(subTypes);
        IcebergTableLikeEntity syntheticTableEntity = ((IcebergTableLikeEntity.Builder)((IcebergTableLikeEntity.Builder)((IcebergTableLikeEntity.Builder)((IcebergTableLikeEntity.Builder)new IcebergTableLikeEntity.Builder(syntheticEntitySubType, identifier, "").setParentId(parentNamespaceEntity.getId())).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCatalogId(parentNamespaceEntity.getCatalogId())).setCreateTimestamp(System.currentTimeMillis())).build();
        this.metaStoreManager.createEntityIfNotExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)resolvedNamespacePathWrapper.getRawFullPath()), (PolarisBaseEntity)syntheticTableEntity);
        PolarisResolvedPathWrapper completePathWrapper = resolutionManifest.getPassthroughResolvedPath((Object)identifier);
        PolarisEntity polarisEntity = leafEntity = completePathWrapper != null ? completePathWrapper.getRawLeafEntity() : null;
        if (completePathWrapper == null || leafEntity == null || leafEntity.getType() != PolarisEntityType.TABLE_LIKE || leafEntity.getSubType() != PolarisEntitySubType.ICEBERG_TABLE || !Objects.equals(leafEntity.getName(), identifier.name())) {
            throw new RuntimeException(String.format("Failed to create or find table entity '%s' in federated catalog '%s'", identifier.name(), catalogEntity.getName()));
        }
        return completePathWrapper;
    }

    private PrivilegeResult revokePrivilegeOnTableLikeFromRole(PolarisResolutionManifest resolutionManifest, String catalogName, String catalogRoleName, TableIdentifier identifier, List<PolarisEntitySubType> subTypes, PolarisPrivilege privilege) {
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        PolarisResolvedPathWrapper resolvedPathWrapper = resolutionManifest.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE);
        if (resolvedPathWrapper == null || !subTypes.contains(resolvedPathWrapper.getRawLeafEntity().getSubType())) {
            CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, subTypes);
        }
        PolarisEntity tableLikeEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisEntityCore)tableLikeEntity, privilege);
    }

    private PrivilegeResult grantPrivilegeOnPolicyEntityToRole(PolarisResolutionManifest resolutionManifest, String catalogName, String catalogRoleName, PolicyIdentifier identifier, PolarisPrivilege privilege) {
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        PolarisResolvedPathWrapper resolvedPathWrapper = resolutionManifest.getResolvedPath((Object)identifier);
        if (resolvedPathWrapper == null) {
            throw new NoSuchPolicyException(String.format("Policy not exists: %s", identifier));
        }
        PolarisEntity policyEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisEntityCore)policyEntity, privilege);
    }

    private PrivilegeResult revokePrivilegeOnPolicyEntityFromRole(PolarisResolutionManifest resolutionManifest, String catalogName, String catalogRoleName, PolicyIdentifier identifier, PolarisPrivilege privilege) {
        CatalogEntity catalogEntity = PolarisAdminService.getCatalogByName(resolutionManifest, catalogName);
        CatalogRoleEntity catalogRoleEntity = PolarisAdminService.getCatalogRoleByName(resolutionManifest, catalogRoleName);
        PolarisResolvedPathWrapper resolvedPathWrapper = resolutionManifest.getResolvedPath((Object)identifier);
        if (resolvedPathWrapper == null) {
            throw new NoSuchPolicyException(String.format("Policy not exists: %s", identifier));
        }
        PolarisEntity policyEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisEntityCore)policyEntity, privilege);
    }

    private static PolarisEntitySubType selectEntitySubType(List<PolarisEntitySubType> subTypes) {
        if (subTypes.contains(PolarisEntitySubType.ICEBERG_TABLE)) {
            return PolarisEntitySubType.ICEBERG_TABLE;
        }
        if (subTypes.contains(PolarisEntitySubType.ICEBERG_VIEW)) {
            return PolarisEntitySubType.ICEBERG_VIEW;
        }
        throw new IllegalStateException(String.format("No supported subtype found in %s. Only ICEBERG_TABLE and ICEBERG_VIEW are supported for synthetic entities in external catalogs.", subTypes));
    }
}

