/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse;

public class ListLogGroupsForQueryIterable
implements SdkIterable<ListLogGroupsForQueryResponse> {
    private final CloudWatchLogsClient client;
    private final ListLogGroupsForQueryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLogGroupsForQueryIterable(CloudWatchLogsClient client, ListLogGroupsForQueryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLogGroupsForQueryResponseFetcher();
    }

    public Iterator<ListLogGroupsForQueryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> logGroupIdentifiers() {
        Function<ListLogGroupsForQueryResponse, Iterator> getIterator = response -> {
            if (response != null && response.logGroupIdentifiers() != null) {
                return response.logGroupIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLogGroupsForQueryResponseFetcher
    implements SyncPageFetcher<ListLogGroupsForQueryResponse> {
        private ListLogGroupsForQueryResponseFetcher() {
        }

        public boolean hasNextPage(ListLogGroupsForQueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLogGroupsForQueryResponse nextPage(ListLogGroupsForQueryResponse previousPage) {
            if (previousPage == null) {
                return ListLogGroupsForQueryIterable.this.client.listLogGroupsForQuery(ListLogGroupsForQueryIterable.this.firstRequest);
            }
            return ListLogGroupsForQueryIterable.this.client.listLogGroupsForQuery((ListLogGroupsForQueryRequest)((Object)ListLogGroupsForQueryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

