/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.BeforeRetryConfig;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class BeforeRetryConfigImpl
implements BeforeRetryConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final BeforeRetry instance;
    private Class<? extends BeforeRetryHandler> _value;
    private String _methodName;

    private BeforeRetryConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(BeforeRetry.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.beforeRetry;
    }

    public static BeforeRetryConfigImpl create(FaultToleranceMethod method) {
        if (method.beforeRetry == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"before-retry.enabled", (String)"BeforeRetry/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new BeforeRetryConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return BeforeRetry.class;
    }

    public Class<? extends BeforeRetryHandler> value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".before-retry.value";
            Object oldKey = this.configKey + "/BeforeRetry/value";
            this._value = config.getOptionalValue((String)newKey, Class.class).or(() -> BeforeRetryConfigImpl.lambda$value$0(config, (String)oldKey)).orElse(null);
            if (this._value == null) {
                newKey = "smallrye.faulttolerance.global.before-retry.value";
                oldKey = "BeforeRetry/value";
                this._value = config.getOptionalValue((String)newKey, Class.class).or(() -> BeforeRetryConfigImpl.lambda$value$1(config, (String)oldKey)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public String methodName() {
        if (this._methodName == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".before-retry.method-name";
            Object oldKey = this.configKey + "/BeforeRetry/methodName";
            this._methodName = config.getOptionalValue((String)newKey, String.class).or(() -> BeforeRetryConfigImpl.lambda$methodName$2(config, (String)oldKey)).orElse(null);
            if (this._methodName == null) {
                newKey = "smallrye.faulttolerance.global.before-retry.method-name";
                oldKey = "BeforeRetry/methodName";
                this._methodName = config.getOptionalValue((String)newKey, String.class).or(() -> BeforeRetryConfigImpl.lambda$methodName$3(config, (String)oldKey)).orElse(null);
            }
            if (this._methodName == null) {
                this._methodName = this.instance.methodName();
            }
        }
        return this._methodName;
    }

    public void materialize() {
        this.value();
        this.methodName();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @BeforeRetry on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @BeforeRetry." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$methodName$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, String.class);
    }

    private static /* synthetic */ Optional lambda$methodName$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, String.class);
    }

    private static /* synthetic */ Optional lambda$value$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }

    private static /* synthetic */ Optional lambda$value$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }
}

