/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.thrift.annotation.Nullable;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataTool {
    protected static final String FILE_TYPE_ARGS = "ft";
    protected static final String FILE_TYPE_NAME = "file_type";
    protected static final String FILE_TYPE_ARGS_NAME = "format";
    protected static final String HOST_ARGS = "h";
    protected static final String HOST_NAME = "host";
    protected static final String HOST_DEFAULT_VALUE = "127.0.0.1";
    protected static final String HELP_ARGS = "help";
    protected static final String PORT_ARGS = "p";
    protected static final String PORT_NAME = "port";
    protected static final String PORT_DEFAULT_VALUE = "6667";
    protected static final String PW_ARGS = "pw";
    protected static final String PW_NAME = "password";
    protected static final String PW_DEFAULT_VALUE = "root";
    protected static final String USERNAME_ARGS = "u";
    protected static final String USERNAME_NAME = "username";
    protected static final String USERNAME_DEFAULT_VALUE = "root";
    protected static final String TIME_FORMAT_ARGS = "tf";
    protected static final String TIME_FORMAT_NAME = "time_format";
    protected static final String TIME_ZONE_ARGS = "tz";
    protected static final String TIME_ZONE_NAME = "timezone";
    protected static final String TIMEOUT_ARGS = "timeout";
    protected static final String TIMEOUT_NAME = "query_timeout";
    protected static final int MAX_HELP_CONSOLE_WIDTH = 92;
    protected static final String[] TIME_FORMAT = new String[]{"default", "long", "number", "timestamp"};
    protected static final String[] STRING_TIME_FORMAT = new String[]{"yyyy-MM-dd HH:mm:ss.SSSX", "yyyy/MM/dd HH:mm:ss.SSSX", "yyyy.MM.dd HH:mm:ss.SSSX", "yyyy-MM-dd HH:mm:ssX", "yyyy/MM/dd HH:mm:ssX", "yyyy.MM.dd HH:mm:ssX", "yyyy-MM-dd HH:mm:ss.SSSz", "yyyy/MM/dd HH:mm:ss.SSSz", "yyyy.MM.dd HH:mm:ss.SSSz", "yyyy-MM-dd HH:mm:ssz", "yyyy/MM/dd HH:mm:ssz", "yyyy.MM.dd HH:mm:ssz", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy.MM.dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy.MM.dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy/MM/dd'T'HH:mm:ss.SSSX", "yyyy.MM.dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ssX", "yyyy/MM/dd'T'HH:mm:ssX", "yyyy.MM.dd'T'HH:mm:ssX", "yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyy/MM/dd'T'HH:mm:ss.SSSz", "yyyy.MM.dd'T'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy/MM/dd'T'HH:mm:ssz", "yyyy.MM.dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy/MM/dd'T'HH:mm:ss.SSS", "yyyy.MM.dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy/MM/dd'T'HH:mm:ss", "yyyy.MM.dd'T'HH:mm:ss"};
    protected static final String INSERT_CSV_MEET_ERROR_MSG = "Meet error when insert csv because ";
    protected static final String CSV_SUFFIXS = "csv";
    protected static final String TXT_SUFFIXS = "txt";
    protected static final String SQL_SUFFIXS = "sql";
    protected static final String TSFILE_SUFFIXS = "tsfile";
    protected static final String TSFILEDB_CLI_DIVIDE = "-------------------";
    protected static final String COLON = ": ";
    protected static final String MINUS = "-";
    protected static String failedFileDirectory = null;
    protected static String timeColumn = "Time";
    protected static String deviceColumn = "Device";
    protected static int linesPerFailedFile = 10000;
    protected static String timestampPrecision = "ms";
    protected static final int CODE_OK = 0;
    protected static final int CODE_ERROR = 1;
    protected static String host;
    protected static String port;
    protected static String username;
    protected static String password;
    protected static ZoneId zoneId;
    protected static String timeZoneID;
    protected static String timeFormat;
    protected static String exportType;
    protected static Boolean aligned;
    protected static Session session;
    protected static final LongAdder loadFileSuccessfulNum;
    protected static final String DATATYPE_BOOLEAN = "boolean";
    protected static final String DATATYPE_INT = "int";
    protected static final String DATATYPE_LONG = "long";
    protected static final String DATATYPE_FLOAT = "float";
    protected static final String DATATYPE_DOUBLE = "double";
    protected static final String DATATYPE_TIMESTAMP = "timestamp";
    protected static final String DATATYPE_DATE = "date";
    protected static final String DATATYPE_BLOB = "blob";
    protected static final String DATATYPE_NAN = "NaN";
    protected static final String DATATYPE_TEXT = "text";
    protected static final String DATATYPE_STRING = "string";
    protected static final String DATATYPE_NULL = "null";
    protected static int batchPointSize;
    protected static final Map<String, TSDataType> TYPE_INFER_KEY_DICT;
    protected static final Map<String, TSDataType> TYPE_INFER_VALUE_DICT;
    private static final IoTPrinter ioTPrinter;
    private static final Logger LOGGER;

    protected AbstractDataTool() {
    }

    protected static String checkRequiredArg(String arg, String name, CommandLine commandLine, String defaultValue) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                return defaultValue;
            }
            String msg = String.format("Required values for option '%s' not provided", name);
            LOGGER.info(msg);
            LOGGER.info("Use -help for more information");
            throw new ArgsErrorException(msg);
        }
        return str;
    }

    protected static void setTimeZone() throws IoTDBConnectionException, StatementExecutionException {
        if (timeZoneID != null) {
            session.setTimeZone(timeZoneID);
        }
        zoneId = ZoneId.of(session.getTimeZone());
    }

    protected static void parseBasicParams(CommandLine commandLine) throws ArgsErrorException {
        host = AbstractDataTool.checkRequiredArg(HOST_ARGS, HOST_NAME, commandLine, HOST_DEFAULT_VALUE);
        port = AbstractDataTool.checkRequiredArg(PORT_ARGS, PORT_NAME, commandLine, PORT_DEFAULT_VALUE);
        username = AbstractDataTool.checkRequiredArg(USERNAME_ARGS, USERNAME_NAME, commandLine, "root");
        password = commandLine.getOptionValue(PW_ARGS, "root");
    }

    protected static void printHelpOptions(String cmdLineHead, String cmdLineSyntax, HelpFormatter hf, Options tsFileOptions, Options csvOptions, Options sqlOptions, boolean printFileType) {
        ioTPrinter.println("-------------------\n" + cmdLineSyntax + "\n" + TSFILEDB_CLI_DIVIDE);
        if (StringUtils.isNotBlank((CharSequence)cmdLineHead)) {
            ioTPrinter.println(cmdLineHead);
        }
        String usageName = cmdLineSyntax.replaceAll(" ", "");
        if (ObjectUtils.isNotEmpty((Object)tsFileOptions)) {
            if (printFileType) {
                ioTPrinter.println("\nfile_type: tsfile\n-------------------");
            }
            hf.printHelp(usageName, tsFileOptions, true);
        }
        if (ObjectUtils.isNotEmpty((Object)csvOptions)) {
            if (printFileType) {
                ioTPrinter.println("\nfile_type: csv\n-------------------");
            }
            hf.printHelp(usageName, csvOptions, true);
        }
        if (ObjectUtils.isNotEmpty((Object)sqlOptions)) {
            if (printFileType) {
                ioTPrinter.println("\nfile_type: sql\n-------------------");
            }
            hf.printHelp(usageName, sqlOptions, true);
        }
    }

    protected static boolean checkTimeFormat() {
        for (String format : TIME_FORMAT) {
            if (!timeFormat.equals(format)) continue;
            return true;
        }
        for (String format : STRING_TIME_FORMAT) {
            if (!timeFormat.equals(format)) continue;
            return true;
        }
        LOGGER.info("Input time format {} is not supported, please input like yyyy-MM-dd\\ HH:mm:ss.SSS or yyyy-MM-dd'T'HH:mm:ss.SSS%n", (Object)timeFormat);
        return false;
    }

    protected static Options createImportOptions() {
        Options options = new Options();
        Option opFileType = Option.builder((String)FILE_TYPE_ARGS).longOpt(FILE_TYPE_NAME).argName(FILE_TYPE_ARGS_NAME).required().hasArg().desc("Types of imported files: CSV, SQL, TSfile (required)").build();
        options.addOption(opFileType);
        return AbstractDataTool.createNewOptions(options);
    }

    protected static Options createExportOptions() {
        Options options = new Options();
        Option opFileType = Option.builder((String)FILE_TYPE_ARGS).longOpt(FILE_TYPE_NAME).argName(FILE_TYPE_ARGS_NAME).required().hasArg().desc("Export file type ?You can choose tsfile)\u3001csv) or sql) . (required)").build();
        options.addOption(opFileType);
        return AbstractDataTool.createNewOptions(options);
    }

    protected static Options createNewOptions(Options options) {
        Option opHost = Option.builder((String)HOST_ARGS).longOpt(HOST_NAME).argName(HOST_NAME).hasArg().desc("Host Name (optional)").build();
        options.addOption(opHost);
        Option opPort = Option.builder((String)PORT_ARGS).longOpt(PORT_NAME).argName(PORT_NAME).hasArg().desc("Port (optional)").build();
        options.addOption(opPort);
        Option opUsername = Option.builder((String)USERNAME_ARGS).longOpt(USERNAME_NAME).argName(USERNAME_NAME).hasArg().desc("Username (optional)").build();
        options.addOption(opUsername);
        Option opPassword = Option.builder((String)PW_ARGS).longOpt(PW_NAME).optionalArg(true).argName(PW_NAME).hasArg().desc("Password (optional)").build();
        options.addOption(opPassword);
        return options;
    }

    protected static void writeDataAlignedByDevice(SessionPool sessionPool, List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        AbstractDataTool.parseHeaders(headerNames, null, headerTypeMap, headerNameMap);
        AtomicReference<Object> deviceName = new AtomicReference<Object>(null);
        HashSet typeQueriedDevice = new HashSet();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            if (deviceName.get() == null) {
                deviceName.set(recordObj.get(1));
            } else if (!Objects.equals(deviceName.get(), recordObj.get(1))) {
                AbstractDataTool.writeAndEmptyDataSet(sessionPool, (String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                deviceName.set(recordObj.get(1));
                pointSize.set(0);
            } else if (pointSize.get() >= batchPointSize) {
                AbstractDataTool.writeAndEmptyDataSet(sessionPool, (String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            ArrayList<TSDataType> types = new ArrayList<TSDataType>();
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<String> measurements = new ArrayList<String>();
            AtomicReference<Boolean> isFail = new AtomicReference<Boolean>(false);
            for (Map.Entry headerNameEntry : headerNameMap.entrySet()) {
                TSDataType type;
                String headerNameWithoutType = (String)headerNameEntry.getKey();
                String headerName = (String)headerNameEntry.getValue();
                String value = recordObj.get(headerName);
                if ("".equals(value)) continue;
                if (!headerTypeMap.containsKey(headerNameWithoutType)) {
                    boolean hasResult = false;
                    if (!typeQueriedDevice.contains(deviceName.get())) {
                        if (headerTypeMap.isEmpty()) {
                            HashSet<String> devices = new HashSet<String>();
                            devices.add((String)deviceName.get());
                            AbstractDataTool.queryType(sessionPool, devices, headerTypeMap, deviceColumn);
                        }
                        typeQueriedDevice.add((String)deviceName.get());
                    }
                    if ((type = AbstractDataTool.typeInfer(value)) != null) {
                        headerTypeMap.put(headerNameWithoutType, type);
                    } else {
                        ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), headerNameWithoutType, value);
                        isFail.set(true);
                    }
                }
                if ((type = (TSDataType)headerTypeMap.get(headerNameWithoutType)) == null) continue;
                Object valueTrans = AbstractDataTool.typeTrans(value, type);
                if (valueTrans == null) {
                    isFail.set(true);
                    ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), headerNameWithoutType, value, type);
                    continue;
                }
                values.add(valueTrans);
                measurements.add(headerNameWithoutType);
                types.add(type);
                pointSize.getAndIncrement();
            }
            if (Boolean.TRUE.equals(isFail.get())) {
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
            }
            if (!measurements.isEmpty()) {
                times.add(AbstractDataTool.parseTimestamp(recordObj.get(timeColumn)));
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
        });
        if (!times.isEmpty()) {
            AbstractDataTool.writeAndEmptyDataSet(sessionPool, (String)deviceName.get(), times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            AbstractDataTool.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(SessionPool sessionPool, String device, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        try {
            if (Boolean.FALSE.equals(aligned)) {
                sessionPool.insertRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
            } else {
                sessionPool.insertAlignedRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
            }
        }
        catch (IoTDBConnectionException e) {
            if (retryTime > 0) {
                AbstractDataTool.writeAndEmptyDataSet(sessionPool, device, times, typesList, valuesList, measurementsList, --retryTime);
            }
        }
        catch (StatementExecutionException e) {
            ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
            System.exit(1);
        }
        finally {
            times.clear();
            typesList.clear();
            valuesList.clear();
            measurementsList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(Session session, List<String> deviceIds, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        block13: {
            try {
                if (Boolean.FALSE.equals(aligned)) {
                    session.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                } else {
                    session.insertAlignedRecords(deviceIds, times, measurementsList, typesList, valuesList);
                }
            }
            catch (IoTDBConnectionException e) {
                if (retryTime <= 0) break block13;
                try {
                    session.open();
                }
                catch (IoTDBConnectionException ex) {
                    ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
                }
                AbstractDataTool.writeAndEmptyDataSet(session, deviceIds, times, typesList, valuesList, measurementsList, --retryTime);
            }
            catch (StatementExecutionException e) {
                ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
                try {
                    session.close();
                }
                catch (IoTDBConnectionException ioTDBConnectionException) {
                    // empty catch block
                }
                System.exit(1);
            }
            finally {
                deviceIds.clear();
                times.clear();
                typesList.clear();
                valuesList.clear();
                measurementsList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(Session session, String device, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        block13: {
            try {
                if (Boolean.FALSE.equals(aligned)) {
                    session.insertRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
                } else {
                    session.insertAlignedRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
                }
            }
            catch (IoTDBConnectionException e) {
                if (retryTime <= 0) break block13;
                try {
                    session.open();
                }
                catch (IoTDBConnectionException ex) {
                    ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
                }
                AbstractDataTool.writeAndEmptyDataSet(session, device, times, typesList, valuesList, measurementsList, --retryTime);
            }
            catch (StatementExecutionException e) {
                ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
                try {
                    session.close();
                }
                catch (IoTDBConnectionException ioTDBConnectionException) {
                    // empty catch block
                }
                System.exit(1);
            }
            finally {
                times.clear();
                typesList.clear();
                valuesList.clear();
                measurementsList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(SessionPool sessionPool, List<String> deviceIds, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        try {
            if (Boolean.FALSE.equals(aligned)) {
                sessionPool.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
            } else {
                sessionPool.insertAlignedRecords(deviceIds, times, measurementsList, typesList, valuesList);
            }
        }
        catch (IoTDBConnectionException e) {
            if (retryTime > 0) {
                AbstractDataTool.writeAndEmptyDataSet(sessionPool, deviceIds, times, typesList, valuesList, measurementsList, --retryTime);
            }
        }
        catch (StatementExecutionException e) {
            ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
            System.exit(1);
        }
        finally {
            deviceIds.clear();
            times.clear();
            typesList.clear();
            valuesList.clear();
            measurementsList.clear();
        }
    }

    private static void writeFailedLinesFile(List<String> headerNames, String failedFilePath, ArrayList<List<Object>> failedRecords) {
        int failedRecordsSize;
        int fileIndex = 0;
        int from = 0;
        int restFailedRecords = failedRecordsSize = failedRecords.size();
        while (from < failedRecordsSize) {
            int step = Math.min(restFailedRecords, linesPerFailedFile);
            AbstractDataTool.writeCsvFile(headerNames, failedRecords.subList(from, from + step), failedFilePath + "_" + fileIndex++);
            from += step;
            restFailedRecords -= step;
        }
    }

    private static TSDataType typeInfer(String strValue) {
        if (strValue.contains("\"")) {
            return strValue.length() <= 514 ? TSDataType.STRING : TSDataType.TEXT;
        }
        if (AbstractDataTool.isBoolean(strValue)) {
            return TYPE_INFER_KEY_DICT.get(DATATYPE_BOOLEAN);
        }
        if (AbstractDataTool.isTimeStamp(strValue)) {
            return TYPE_INFER_KEY_DICT.get(DATATYPE_TIMESTAMP);
        }
        if (AbstractDataTool.isNumber(strValue)) {
            if (!strValue.contains(".")) {
                if (AbstractDataTool.isConvertFloatPrecisionLack(StringUtils.trim((String)strValue))) {
                    return TYPE_INFER_KEY_DICT.get(DATATYPE_LONG);
                }
                return TYPE_INFER_KEY_DICT.get(DATATYPE_INT);
            }
            return TYPE_INFER_KEY_DICT.get(DATATYPE_FLOAT);
        }
        if (DATATYPE_NULL.equals(strValue) || DATATYPE_NULL.toUpperCase().equals(strValue)) {
            return null;
        }
        if (DATATYPE_NAN.equals(strValue)) {
            return TYPE_INFER_KEY_DICT.get(DATATYPE_NAN);
        }
        if (AbstractDataTool.isDate(strValue)) {
            return TYPE_INFER_KEY_DICT.get(DATATYPE_DATE);
        }
        if (AbstractDataTool.isBlob(strValue)) {
            return TYPE_INFER_KEY_DICT.get(DATATYPE_BLOB);
        }
        if (strValue.length() <= 512) {
            return TSDataType.STRING;
        }
        return TSDataType.TEXT;
    }

    private static boolean isDate(String s) {
        return s.equalsIgnoreCase(DATATYPE_DATE);
    }

    private static boolean isTimeStamp(String s) {
        return s.equalsIgnoreCase(DATATYPE_TIMESTAMP);
    }

    static boolean isNumber(String s) {
        if (s == null || s.equals(DATATYPE_NAN)) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isBlob(String s) {
        return s.length() >= 3 && s.startsWith("X'") && s.endsWith("'");
    }

    private static boolean isBoolean(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    private static boolean isConvertFloatPrecisionLack(String s) {
        return Long.parseLong(s) > 0x2000000L;
    }

    private static Object typeTrans(String value, TSDataType type) {
        try {
            switch (type) {
                case TEXT: 
                case STRING: {
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        return value.substring(1, value.length() - 1);
                    }
                    return value;
                }
                case BOOLEAN: {
                    if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                        return null;
                    }
                    return Boolean.parseBoolean(value);
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case TIMESTAMP: {
                    return Long.parseLong(value);
                }
                case DATE: {
                    return LocalDate.parse(value);
                }
                case BLOB: {
                    return new Binary(AbstractDataTool.parseHexStringToByteArray(value.replaceFirst("0x", "")));
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static byte[] parseHexStringToByteArray(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            int value = Integer.parseInt(hexString.substring(i, i + 2), 16);
            bytes[i / 2] = (byte)value;
        }
        return bytes;
    }

    private static long parseTimestamp(String str) {
        long timestamp;
        try {
            timestamp = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            timestamp = DateTimeUtils.convertDatetimeStrToLong(str, zoneId, timestampPrecision);
        }
        return timestamp;
    }

    private static void queryType(SessionPool sessionPool, Set<String> deviceNames, HashMap<String, TSDataType> headerTypeMap, String alignedType) {
        for (String deviceName : deviceNames) {
            String sql = "show timeseries " + deviceName + ".*";
            try {
                SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
                try {
                    int tsIndex = sessionDataSetWrapper.getColumnNames().indexOf("Timeseries");
                    int dtIndex = sessionDataSetWrapper.getColumnNames().indexOf("DataType");
                    while (sessionDataSetWrapper.hasNext()) {
                        RowRecord rowRecord = sessionDataSetWrapper.next();
                        List fields = rowRecord.getFields();
                        String timeseries = ((Field)fields.get(tsIndex)).getStringValue();
                        String dataType = ((Field)fields.get(dtIndex)).getStringValue();
                        if (Objects.equals(alignedType, "Time")) {
                            headerTypeMap.put(timeseries, AbstractDataTool.getType(dataType));
                            continue;
                        }
                        if (!Objects.equals(alignedType, deviceColumn)) continue;
                        String[] split = PathUtils.splitPathToDetachedNodes((String)timeseries);
                        String measurement = split[split.length - 1];
                        headerTypeMap.put(measurement, AbstractDataTool.getType(dataType));
                    }
                }
                finally {
                    if (sessionDataSetWrapper == null) continue;
                    sessionDataSetWrapper.close();
                }
            }
            catch (IllegalPathException | IoTDBConnectionException | StatementExecutionException e) {
                ioTPrinter.println("Meet error when query the type of timeseries because " + e.getMessage());
                System.exit(1);
            }
        }
    }

    private static void queryType(Session session, Set<String> deviceNames, HashMap<String, TSDataType> headerTypeMap, String alignedType) {
        for (String deviceName : deviceNames) {
            String sql = "show timeseries " + deviceName + ".*";
            SessionDataSet sessionDataSet = null;
            try {
                sessionDataSet = session.executeQueryStatement(sql);
                int tsIndex = sessionDataSet.getColumnNames().indexOf("Timeseries");
                int dtIndex = sessionDataSet.getColumnNames().indexOf("DataType");
                while (sessionDataSet.hasNext()) {
                    RowRecord rowRecord = sessionDataSet.next();
                    List fields = rowRecord.getFields();
                    String timeseries = ((Field)fields.get(tsIndex)).getStringValue();
                    String dataType = ((Field)fields.get(dtIndex)).getStringValue();
                    if (Objects.equals(alignedType, "Time")) {
                        headerTypeMap.put(timeseries, AbstractDataTool.getType(dataType));
                        continue;
                    }
                    if (!Objects.equals(alignedType, deviceColumn)) continue;
                    String[] split = PathUtils.splitPathToDetachedNodes((String)timeseries);
                    String measurement = split[split.length - 1];
                    headerTypeMap.put(measurement, AbstractDataTool.getType(dataType));
                }
            }
            catch (IllegalPathException | IoTDBConnectionException | StatementExecutionException e) {
                ioTPrinter.println("Meet error when query the type of timeseries because " + e.getMessage());
                try {
                    session.close();
                }
                catch (IoTDBConnectionException ioTDBConnectionException) {
                    // empty catch block
                }
                System.exit(1);
            }
        }
    }

    private static void parseHeaders(List<String> headerNames, @Nullable HashMap<String, List<String>> deviceAndMeasurementNames, HashMap<String, TSDataType> headerTypeMap, HashMap<String, String> headerNameMap) throws IllegalPathException {
        String regex = "(?<=\\()\\S+(?=\\))";
        Pattern pattern = Pattern.compile(regex);
        for (String headerName : headerNames) {
            String headerNameWithoutType;
            if ("Time".equalsIgnoreCase(AbstractDataTool.filterBomHeader(headerName))) {
                timeColumn = headerName;
                continue;
            }
            if ("Device".equalsIgnoreCase(headerName)) {
                deviceColumn = headerName;
                continue;
            }
            Matcher matcher = pattern.matcher(headerName);
            if (matcher.find()) {
                String type = matcher.group();
                headerNameWithoutType = headerName.replace("(" + type + ")", "").replaceAll("\\s+", "");
                headerNameMap.put(headerNameWithoutType, headerName);
                headerTypeMap.put(headerNameWithoutType, AbstractDataTool.getType(type));
            } else {
                headerNameWithoutType = headerName;
                headerNameMap.put(headerName, headerName);
            }
            String[] split = PathUtils.splitPathToDetachedNodes((String)headerNameWithoutType);
            String measurementName = split[split.length - 1];
            String deviceName = StringUtils.join((Object[])Arrays.copyOfRange(split, 0, split.length - 1), (char)'.');
            if (deviceAndMeasurementNames == null) continue;
            deviceAndMeasurementNames.putIfAbsent(deviceName, new ArrayList());
            deviceAndMeasurementNames.get(deviceName).add(measurementName);
        }
    }

    private static TSDataType getType(String typeStr) {
        try {
            return TSDataType.valueOf((String)typeStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static void writeDataAlignedByTime(SessionPool sessionPool, List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        HashMap<String, List<String>> deviceAndMeasurementNames = new HashMap<String, List<String>>();
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        AbstractDataTool.parseHeaders(headerNames, deviceAndMeasurementNames, headerTypeMap, headerNameMap);
        Set<String> devices = deviceAndMeasurementNames.keySet();
        if (headerTypeMap.isEmpty()) {
            AbstractDataTool.queryType(sessionPool, devices, headerTypeMap, "Time");
        }
        ArrayList<String> deviceIds = new ArrayList<String>();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        AtomicReference<Boolean> hasStarted = new AtomicReference<Boolean>(false);
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            if (Boolean.FALSE.equals(hasStarted.get())) {
                hasStarted.set(true);
            } else if (pointSize.get() >= batchPointSize) {
                AbstractDataTool.writeAndEmptyDataSet(sessionPool, (List<String>)deviceIds, (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            boolean isFail = false;
            for (Map.Entry entry : deviceAndMeasurementNames.entrySet()) {
                String deviceId = (String)entry.getKey();
                List measurementNames = (List)entry.getValue();
                ArrayList<TSDataType> types = new ArrayList<TSDataType>();
                ArrayList<Object> values = new ArrayList<Object>();
                ArrayList<String> measurements = new ArrayList<String>();
                for (String measurement : measurementNames) {
                    TSDataType type;
                    String header = deviceId + "." + measurement;
                    String value = recordObj.get((String)headerNameMap.get(header));
                    if ("".equals(value)) continue;
                    if (!headerTypeMap.containsKey(header)) {
                        AbstractDataTool.queryType(sessionPool, header, headerTypeMap);
                        if (!headerTypeMap.containsKey(header)) {
                            type = AbstractDataTool.typeInfer(value);
                            if (type != null) {
                                headerTypeMap.put(header, type);
                            } else {
                                ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), header, value);
                                isFail = true;
                            }
                        }
                    }
                    if ((type = (TSDataType)headerTypeMap.get(header)) == null) continue;
                    Object valueTrans = AbstractDataTool.typeTrans(value, type);
                    if (valueTrans == null) {
                        isFail = true;
                        ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), header, value, type);
                        continue;
                    }
                    measurements.add(header.replace(deviceId + '.', ""));
                    types.add(type);
                    values.add(valueTrans);
                    pointSize.getAndIncrement();
                }
                if (measurements.isEmpty()) continue;
                times.add(AbstractDataTool.parseTimestamp(recordObj.get(timeColumn)));
                deviceIds.add(deviceId);
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
            if (isFail) {
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
            }
        });
        if (!deviceIds.isEmpty()) {
            AbstractDataTool.writeAndEmptyDataSet(sessionPool, deviceIds, times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            AbstractDataTool.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
    }

    private static void queryType(SessionPool sessionPool, String series, HashMap<String, TSDataType> headerTypeMap) {
        String sql = "show timeseries " + series;
        try (SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);){
            int tsIndex = sessionDataSetWrapper.getColumnNames().indexOf("Timeseries");
            int dtIndex = sessionDataSetWrapper.getColumnNames().indexOf("DataType");
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord rowRecord = sessionDataSetWrapper.next();
                List fields = rowRecord.getFields();
                String timeseries = ((Field)fields.get(tsIndex)).getStringValue();
                String dataType = ((Field)fields.get(dtIndex)).getStringValue();
                if (!Objects.equals(series, timeseries)) continue;
                headerTypeMap.put(timeseries, AbstractDataTool.getType(dataType));
            }
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Meet error when query the type of timeseries because " + e.getMessage());
            System.exit(1);
        }
    }

    protected static void writeDataAlignedByDevice(Session session, List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        AbstractDataTool.parseHeaders(headerNames, null, headerTypeMap, headerNameMap);
        AtomicReference<Object> deviceName = new AtomicReference<Object>(null);
        HashSet typeQueriedDevice = new HashSet();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            if (deviceName.get() == null) {
                deviceName.set(recordObj.get(1));
            } else if (!Objects.equals(deviceName.get(), recordObj.get(1))) {
                AbstractDataTool.writeAndEmptyDataSet(session, (String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                deviceName.set(recordObj.get(1));
                pointSize.set(0);
            } else if (pointSize.get() >= batchPointSize) {
                AbstractDataTool.writeAndEmptyDataSet(session, (String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            ArrayList<TSDataType> types = new ArrayList<TSDataType>();
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<String> measurements = new ArrayList<String>();
            AtomicReference<Boolean> isFail = new AtomicReference<Boolean>(false);
            for (Map.Entry headerNameEntry : headerNameMap.entrySet()) {
                TSDataType type;
                String headerNameWithoutType = (String)headerNameEntry.getKey();
                String headerName = (String)headerNameEntry.getValue();
                String value = recordObj.get(headerName);
                if ("".equals(value)) continue;
                if (!headerTypeMap.containsKey(headerNameWithoutType)) {
                    if (!typeQueriedDevice.contains(deviceName.get())) {
                        if (headerTypeMap.isEmpty()) {
                            HashSet<String> devices = new HashSet<String>();
                            devices.add((String)deviceName.get());
                            AbstractDataTool.queryType(session, devices, headerTypeMap, deviceColumn);
                        }
                        typeQueriedDevice.add((String)deviceName.get());
                    }
                    if (!headerTypeMap.containsKey(headerNameWithoutType)) {
                        type = AbstractDataTool.typeInfer(value);
                        if (type != null) {
                            headerTypeMap.put(headerNameWithoutType, type);
                        } else {
                            ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), headerNameWithoutType, value);
                            isFail.set(true);
                        }
                    }
                }
                if ((type = (TSDataType)headerTypeMap.get(headerNameWithoutType)) == null) continue;
                Object valueTrans = AbstractDataTool.typeTrans(value, type);
                if (valueTrans == null) {
                    isFail.set(true);
                    ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), headerNameWithoutType, value, type);
                    continue;
                }
                values.add(valueTrans);
                measurements.add(headerNameWithoutType);
                types.add(type);
                pointSize.getAndIncrement();
            }
            if (Boolean.TRUE.equals(isFail.get())) {
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
            }
            if (!measurements.isEmpty()) {
                times.add(AbstractDataTool.parseTimestamp(recordObj.get(timeColumn)));
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
        });
        if (!times.isEmpty()) {
            AbstractDataTool.writeAndEmptyDataSet(session, (String)deviceName.get(), times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            AbstractDataTool.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
        ioTPrinter.println("Import completely!");
    }

    protected static void writeDataAlignedByTime(Session session, List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        HashMap<String, List<String>> deviceAndMeasurementNames = new HashMap<String, List<String>>();
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        AbstractDataTool.parseHeaders(headerNames, deviceAndMeasurementNames, headerTypeMap, headerNameMap);
        Set<String> devices = deviceAndMeasurementNames.keySet();
        if (headerTypeMap.isEmpty()) {
            AbstractDataTool.queryType(session, devices, headerTypeMap, "Time");
        }
        ArrayList<String> deviceIds = new ArrayList<String>();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        AtomicReference<Boolean> hasStarted = new AtomicReference<Boolean>(false);
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            if (Boolean.FALSE.equals(hasStarted.get())) {
                hasStarted.set(true);
            } else if (pointSize.get() >= batchPointSize) {
                AbstractDataTool.writeAndEmptyDataSet(session, (List<String>)deviceIds, (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            boolean isFail = false;
            for (Map.Entry entry : deviceAndMeasurementNames.entrySet()) {
                String deviceId = (String)entry.getKey();
                List measurementNames = (List)entry.getValue();
                ArrayList<TSDataType> types = new ArrayList<TSDataType>();
                ArrayList<Object> values = new ArrayList<Object>();
                ArrayList<String> measurements = new ArrayList<String>();
                for (String measurement : measurementNames) {
                    TSDataType type;
                    String header = deviceId + "." + measurement;
                    String value = recordObj.get((String)headerNameMap.get(header));
                    if ("".equals(value)) continue;
                    if (!headerTypeMap.containsKey(header)) {
                        type = AbstractDataTool.typeInfer(value);
                        if (type != null) {
                            headerTypeMap.put(header, type);
                        } else {
                            ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), header, value);
                            isFail = true;
                        }
                    }
                    if ((type = (TSDataType)headerTypeMap.get(header)) == null) continue;
                    Object valueTrans = AbstractDataTool.typeTrans(value, type);
                    if (valueTrans == null) {
                        isFail = true;
                        ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), header, value, type);
                        continue;
                    }
                    measurements.add(header.replace(deviceId + '.', ""));
                    types.add(type);
                    values.add(valueTrans);
                    pointSize.getAndIncrement();
                }
                if (measurements.isEmpty()) continue;
                times.add(AbstractDataTool.parseTimestamp(recordObj.get(timeColumn)));
                deviceIds.add(deviceId);
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
            if (isFail) {
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
            }
        });
        if (!deviceIds.isEmpty()) {
            AbstractDataTool.writeAndEmptyDataSet(session, deviceIds, times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            AbstractDataTool.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
        if (Boolean.TRUE.equals(hasStarted.get())) {
            ioTPrinter.println("Import completely!");
        } else {
            ioTPrinter.println("No records!");
        }
    }

    protected static String filterBomHeader(String s) {
        byte[] bom = new byte[]{-17, -69, -65};
        byte[] bytes = Arrays.copyOf(s.getBytes(), 3);
        if (Arrays.equals(bom, bytes)) {
            return s.substring(1);
        }
        return s;
    }

    protected static Options createHelpOptions() {
        Options options = new Options();
        Option opHelp = Option.builder((String)HELP_ARGS).longOpt(HELP_ARGS).hasArg().desc("Display help information").build();
        options.addOption(opHelp);
        Option opFileType = Option.builder((String)FILE_TYPE_ARGS).longOpt(FILE_TYPE_NAME).argName(FILE_TYPE_ARGS_NAME).hasArg().desc("Export file type ?You can choose tsfile)\u3001csv) or sql) . (required)").build();
        options.addOption(opFileType);
        return options;
    }

    protected static CSVParser readCsvFile(String path) throws IOException {
        return CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setQuote('`').setEscape('\\').setIgnoreEmptyLines(true).build().parse((Reader)new InputStreamReader(new FileInputStream(path)));
    }

    public static Boolean writeCsvFile(List<String> headerNames, List<List<Object>> records, String filePath) {
        try {
            CSVPrinterWrapper csvPrinterWrapper = new CSVPrinterWrapper(filePath);
            if (headerNames != null) {
                csvPrinterWrapper.printRecord(headerNames);
            }
            for (List<Object> CsvRecord : records) {
                csvPrinterWrapper.printRecord(CsvRecord);
            }
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
            return true;
        }
        catch (IOException e) {
            ioTPrinter.printException(e);
            return false;
        }
    }

    static {
        zoneId = ZoneId.systemDefault();
        loadFileSuccessfulNum = new LongAdder();
        batchPointSize = 100000;
        TYPE_INFER_KEY_DICT = new HashMap<String, TSDataType>();
        TYPE_INFER_KEY_DICT.put(DATATYPE_BOOLEAN, TSDataType.BOOLEAN);
        TYPE_INFER_KEY_DICT.put(DATATYPE_INT, TSDataType.FLOAT);
        TYPE_INFER_KEY_DICT.put(DATATYPE_LONG, TSDataType.DOUBLE);
        TYPE_INFER_KEY_DICT.put(DATATYPE_FLOAT, TSDataType.FLOAT);
        TYPE_INFER_KEY_DICT.put(DATATYPE_DOUBLE, TSDataType.DOUBLE);
        TYPE_INFER_KEY_DICT.put(DATATYPE_TIMESTAMP, TSDataType.TIMESTAMP);
        TYPE_INFER_KEY_DICT.put(DATATYPE_DATE, TSDataType.TIMESTAMP);
        TYPE_INFER_KEY_DICT.put(DATATYPE_BLOB, TSDataType.BLOB);
        TYPE_INFER_KEY_DICT.put(DATATYPE_NAN, TSDataType.DOUBLE);
        TYPE_INFER_KEY_DICT.put(DATATYPE_STRING, TSDataType.STRING);
        TYPE_INFER_VALUE_DICT = new HashMap<String, TSDataType>();
        TYPE_INFER_VALUE_DICT.put(DATATYPE_BOOLEAN, TSDataType.BOOLEAN);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_INT, TSDataType.INT32);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_LONG, TSDataType.INT64);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_FLOAT, TSDataType.FLOAT);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_DOUBLE, TSDataType.DOUBLE);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_TIMESTAMP, TSDataType.TIMESTAMP);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_DATE, TSDataType.DATE);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_BLOB, TSDataType.BLOB);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_TEXT, TSDataType.TEXT);
        TYPE_INFER_VALUE_DICT.put(DATATYPE_STRING, TSDataType.STRING);
        ioTPrinter = new IoTPrinter(System.out);
        LOGGER = LoggerFactory.getLogger(AbstractDataTool.class);
    }

    static class CSVPrinterWrapper {
        private final String filePath;
        private final CSVFormat csvFormat;
        private CSVPrinter csvPrinter;

        public CSVPrinterWrapper(String filePath) {
            this.filePath = filePath;
            this.csvFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setEscape('\\').setQuoteMode(QuoteMode.NONE).build();
        }

        public void printRecord(Iterable<?> values) throws IOException {
            if (this.csvPrinter == null) {
                this.csvPrinter = this.csvFormat.print((Appendable)new PrintWriter(this.filePath));
            }
            this.csvPrinter.printRecord(values);
        }

        public void print(Object value) {
            if (this.csvPrinter == null) {
                try {
                    this.csvPrinter = this.csvFormat.print((Appendable)new PrintWriter(this.filePath));
                }
                catch (IOException e) {
                    ioTPrinter.printException(e);
                    return;
                }
            }
            try {
                this.csvPrinter.print(value);
            }
            catch (IOException e) {
                ioTPrinter.printException(e);
            }
        }

        public void println() throws IOException {
            this.csvPrinter.println();
        }

        public void close() throws IOException {
            if (this.csvPrinter != null) {
                this.csvPrinter.close();
            }
        }

        public void flush() throws IOException {
            if (this.csvPrinter != null) {
                this.csvPrinter.flush();
            }
        }
    }
}

