/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionScheduleTaskWorker
implements Callable<Void> {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final List<DataRegion> dataRegionList;
    private final int workerId;
    private final int workerNum;

    public CompactionScheduleTaskWorker(List<DataRegion> dataRegionList, int workerId, int workerNum) {
        this.dataRegionList = dataRegionList;
        this.workerId = workerId;
        this.workerNum = workerNum;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Void call() {
        try {
            block2: while (true) {
                Thread.sleep(IoTDBDescriptor.getInstance().getConfig().getCompactionScheduleIntervalInMs());
                if (!StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) continue;
                dataRegionListSnapshot = new ArrayList<DataRegion>(this.dataRegionList);
                dataRegionsToScheduleCompaction = new ArrayList<DataRegion>();
                for (i = 0; i < dataRegionListSnapshot.size(); ++i) {
                    if (i % this.workerNum != this.workerId) continue;
                    dataRegionsToScheduleCompaction.add((DataRegion)dataRegionListSnapshot.get(i));
                }
                Collections.shuffle(dataRegionsToScheduleCompaction);
                var3_4 = dataRegionsToScheduleCompaction.iterator();
                while (true) {
                    if (var3_4.hasNext()) ** break;
                    continue block2;
                    dataRegion = (DataRegion)var3_4.next();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    dataRegion.executeCompaction();
                }
                break;
            }
        }
        catch (InterruptedException ignored) {
            CompactionScheduleTaskWorker.logger.info("[CompactionScheduleTaskWorker-{}] compaction schedule is interrupted", (Object)this.workerId);
            return null;
        }
    }
}

