/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableCharBag;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedCharCollection;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;

public class SynchronizedCharBag
extends AbstractSynchronizedCharCollection
implements MutableCharBag {
    private static final long serialVersionUID = 1L;

    public SynchronizedCharBag(MutableCharBag bag) {
        super(bag);
    }

    public SynchronizedCharBag(MutableCharBag bag, Object newLock) {
        super(bag, newLock);
    }

    private MutableCharBag getMutableCharBag() {
        return (MutableCharBag)this.getCharCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharBag with(char element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharBag without(char element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharBag withAll(CharIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharBag withoutAll(CharIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOccurrences(char item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOccurrences(char item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int occurrencesOf(char item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithOccurrences(CharIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag select(CharPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag selectByOccurrences(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().selectByOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet selectUnique() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().selectUnique();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<CharIntPair> topOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().topOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<CharIntPair> bottomOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().bottomOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag reject(CharPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().collect((CharToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyCharIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyCharIterableAdapter(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return new UnmodifiableCharBag(this);
        }
    }

    @Override
    public MutableCharBag asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableCharBag toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return CharBags.immutable.withAll(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharBag().newEmpty();
        }
    }
}

