/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionRecoverException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.SimpleCompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;

public class SettleCompactionTask
extends InnerSpaceCompactionTask {
    private List<TsFileResource> fullyDirtyFiles;
    private double fullyDirtyFileSize = 0.0;
    private double partiallyDirtyFileSize = 0.0;
    private int fullyDeletedSuccessNum = 0;
    private long totalModsFileSize;

    public SettleCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> fullyDirtyFiles, List<TsFileResource> partiallyDirtyFiles, boolean isSequence, ICompactionPerformer performer, long serialId) {
        super(timePartition, tsFileManager, partiallyDirtyFiles, isSequence, performer, serialId);
        this.fullyDirtyFiles = fullyDirtyFiles;
        fullyDirtyFiles.forEach(x -> this.fullyDirtyFileSize += (double)x.getTsFileSize());
        partiallyDirtyFiles.forEach(x -> {
            this.partiallyDirtyFileSize += (double)x.getTsFileSize();
            this.totalModsFileSize += x.getModFile().getSize();
        });
        this.hashCode = this.toString().hashCode();
    }

    public SettleCompactionTask(String databaseName, String dataRegionId, TsFileManager tsFileManager, File logFile) {
        super(databaseName, dataRegionId, tsFileManager, logFile);
    }

    @Override
    public List<TsFileResource> getAllSourceTsFiles() {
        ArrayList<TsFileResource> allSourceFiles = new ArrayList<TsFileResource>(this.fullyDirtyFiles);
        allSourceFiles.addAll(this.filesView.sourceFilesInCompactionPerformer);
        return allSourceFiles;
    }

    @Override
    protected void calculateSourceFilesAndTargetFiles() throws IOException {
        this.filesView.renamedTargetFiles = Collections.emptyList();
        this.filesView.targetFilesInLog = this.filesView.sourceFilesInCompactionPerformer.isEmpty() ? Collections.emptyList() : Collections.singletonList(TsFileNameGenerator.getSettleCompactionTargetFileResources(this.filesView.sourceFilesInCompactionPerformer, this.filesView.sequence));
        this.filesView.targetFilesInPerformer = this.filesView.targetFilesInLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCompaction() {
        boolean isSuccess;
        this.recoverMemoryStatus = true;
        if (!this.tsFileManager.isAllowCompaction()) {
            return true;
        }
        if (this.fullyDirtyFiles.isEmpty() && this.filesView.sourceFilesInCompactionPerformer.isEmpty()) {
            LOGGER.info("{}-{} [Compaction] Settle compaction file list is empty, end it", (Object)this.storageGroupName, (Object)this.dataRegionId);
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info("{}-{} [Compaction] SettleCompaction task starts with {} fully_dirty files and {} partially_dirty files. Fully_dirty files : {}, partially_dirty files : {} . Fully_dirty files size is {} MB, partially_dirty file size is {} MB. Memory cost is {} MB.", new Object[]{this.storageGroupName, this.dataRegionId, this.fullyDirtyFiles.size(), this.filesView.sourceFilesInCompactionPerformer.size(), this.fullyDirtyFiles, this.filesView.sourceFilesInCompactionPerformer, this.fullyDirtyFileSize / 1024.0 / 1024.0, this.partiallyDirtyFileSize / 1024.0 / 1024.0, this.memoryCost == 0L ? 0.0 : (double)this.memoryCost / 1024.0 / 1024.0});
        List<TsFileResource> allSourceFiles = this.getAllSourceTsFiles();
        this.logFile = new File(allSourceFiles.get(0).getTsFile().getAbsolutePath() + ".settle-compaction.log");
        try (SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(this.logFile);){
            this.calculateSourceFilesAndTargetFiles();
            this.isHoldingWriteLock = new boolean[this.filesView.sourceFilesInLog.size()];
            Arrays.fill(this.isHoldingWriteLock, false);
            compactionLogger.logSourceFiles(this.fullyDirtyFiles);
            compactionLogger.logEmptyTargetFiles(this.fullyDirtyFiles);
            compactionLogger.logSourceFiles(this.filesView.sourceFilesInCompactionPerformer);
            compactionLogger.logTargetFiles(this.filesView.targetFilesInLog);
            compactionLogger.force();
            isSuccess = this.settleWithFullyDirtyFiles();
            if (isSuccess) {
                this.settleWithPartiallyDirtyFiles(compactionLogger);
            }
            double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            if (isSuccess) {
                if (this.partiallyDirtyFileSize == 0.0) {
                    LOGGER.info("{}-{} [Compaction] SettleCompaction task finishes successfully, time cost is {} s.Fully_dirty files num is {}.", new Object[]{this.storageGroupName, this.dataRegionId, String.format("%.2f", costTime), this.fullyDirtyFiles.size()});
                } else {
                    LOGGER.info("{}-{} [Compaction] SettleCompaction task finishes successfully, time cost is {} s, compaction speed is {} MB/s.Fully_dirty files num is {} and partially_dirty files num is {}.", new Object[]{this.storageGroupName, this.dataRegionId, String.format("%.2f", costTime), String.format("%.2f", this.partiallyDirtyFileSize / 1024.0 / 1024.0 / costTime), this.fullyDirtyFiles.size(), this.filesView.sourceFilesInCompactionPerformer.size()});
                }
            } else {
                LOGGER.info("{}-{} [Compaction] SettleCompaction task finishes with some error, time cost is {} s.Fully_dirty files num is {} and there are {} files fail to delete.", new Object[]{this.storageGroupName, this.dataRegionId, String.format("%.2f", costTime), this.fullyDirtyFiles.size(), allSourceFiles.size() - this.fullyDeletedSuccessNum});
            }
        }
        catch (Exception e) {
            isSuccess = false;
            this.handleException(LOGGER, e);
            this.recover();
        }
        finally {
            this.releaseAllLocks();
            try {
                Files.deleteIfExists(this.logFile.toPath());
            }
            catch (IOException e) {
                this.handleException(LOGGER, e);
            }
            for (TsFileResource resource : this.filesView.targetFilesInLog) {
                resource.setStatus(TsFileResourceStatus.NORMAL);
            }
        }
        return isSuccess;
    }

    public boolean settleWithFullyDirtyFiles() {
        if (this.fullyDirtyFiles.isEmpty()) {
            return true;
        }
        boolean isSuccess = true;
        for (TsFileResource resource : this.fullyDirtyFiles) {
            boolean res;
            if (this.recoverMemoryStatus) {
                this.tsFileManager.remove(resource, resource.isSeq());
                if (resource.getModFile().exists()) {
                    FileMetrics.getInstance().decreaseModFileNum(1);
                    FileMetrics.getInstance().decreaseModFileSize(resource.getModFile().getSize());
                }
            }
            if (res = this.deleteTsFileOnDisk(resource)) {
                ++this.fullyDeletedSuccessNum;
                LOGGER.debug("Settle task deletes fully_dirty tsfile {} successfully.", (Object)resource.getTsFile().getAbsolutePath());
                if (this.recoverMemoryStatus) {
                    FileMetrics.getInstance().deleteTsFile(resource.isSeq(), Collections.singletonList(resource));
                }
            } else {
                LOGGER.error("Settle task fail to delete fully_dirty tsfile {}.", (Object)resource.getTsFile().getAbsolutePath());
            }
            isSuccess = isSuccess && res;
        }
        return isSuccess;
    }

    private void settleWithPartiallyDirtyFiles(SimpleCompactionLogger logger) throws Exception {
        if (this.filesView.sourceFilesInCompactionPerformer.isEmpty()) {
            return;
        }
        LOGGER.info("{}-{} [Compaction] Start to settle {} {} partially_dirty files, total file size is {} MB", new Object[]{this.storageGroupName, this.dataRegionId, this.filesView.sourceFilesInCompactionPerformer.size(), this.filesView.sequence ? "Sequence" : "Unsequence", this.filesView.selectedFileSize / 1024L / 1024L});
        long startTime = System.currentTimeMillis();
        this.compact(logger);
        double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        LOGGER.info("{}-{} [Compaction] Finish to settle {} {} partially_dirty files successfully , target file is {},time cost is {} s, compaction speed is {} MB/s, {}", new Object[]{this.storageGroupName, this.dataRegionId, this.filesView.sourceFilesInCompactionPerformer.size(), this.filesView.sequence ? "Sequence" : "Unsequence", this.filesView.targetFilesInLog.get(0).getTsFile().getName(), String.format("%.2f", costTime), String.format("%.2f", (double)this.filesView.selectedFileSize / 1024.0 / 1024.0 / costTime), this.summary});
    }

    @Override
    public void recover() {
        LOGGER.info("{}-{} [Compaction][Recover] Start to recover settle compaction.", (Object)this.storageGroupName, (Object)this.dataRegionId);
        try {
            if (this.needRecoverTaskInfoFromLogFile) {
                this.recoverSettleTaskInfoFromLogFile();
            }
            this.recoverFullyDirtyFiles();
            this.recoverPartiallyDirtyFiles();
            LOGGER.info("{}-{} [Compaction][Recover] Finish to recover settle compaction successfully.", (Object)this.storageGroupName, (Object)this.dataRegionId);
            if (this.needRecoverTaskInfoFromLogFile) {
                Files.deleteIfExists(this.logFile.toPath());
            }
        }
        catch (Exception e) {
            this.handleRecoverException(e);
        }
    }

    public void recoverFullyDirtyFiles() {
        if (!this.settleWithFullyDirtyFiles()) {
            throw new CompactionRecoverException("Failed to delete fully_dirty source file.");
        }
    }

    private void recoverPartiallyDirtyFiles() throws IOException {
        if (this.shouldRollback()) {
            this.rollback();
        } else {
            this.finishTask();
        }
    }

    public void recoverSettleTaskInfoFromLogFile() throws IOException {
        LOGGER.info("{}-{} [Compaction][Recover] compaction log is {}", new Object[]{this.storageGroupName, this.dataRegionId, this.logFile});
        CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(this.logFile);
        logAnalyzer.analyze();
        List<TsFileIdentifier> sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
        List<TsFileIdentifier> targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
        List<TsFileIdentifier> deletedTargetFileIdentifiers = logAnalyzer.getDeletedTargetFileInfos();
        this.fullyDirtyFiles = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> selectedTsFileResourceList = new ArrayList<TsFileResource>();
        for (TsFileIdentifier x : sourceFileIdentifiers) {
            File sourceFile = x.getFileFromDataDirsIfAnyAdjuvantFileExists();
            TsFileResource resource = sourceFile == null ? new TsFileResource(new File(x.getFilePath())) : new TsFileResource(sourceFile);
            if (deletedTargetFileIdentifiers.contains(x)) {
                this.fullyDirtyFiles.add(resource);
                continue;
            }
            selectedTsFileResourceList.add(resource);
        }
        this.filesView.setSourceFilesForRecover(selectedTsFileResourceList);
        this.recoverTargetResource(targetFileIdentifiers, deletedTargetFileIdentifiers);
    }

    @Override
    public CompactionTaskType getCompactionTaskType() {
        return CompactionTaskType.SETTLE;
    }

    public List<TsFileResource> getFullyDirtyFiles() {
        return this.fullyDirtyFiles;
    }

    public List<TsFileResource> getPartiallyDirtyFiles() {
        return this.filesView.sourceFilesInCompactionPerformer;
    }

    public double getFullyDirtyFileSize() {
        return this.fullyDirtyFileSize;
    }

    public double getPartiallyDirtyFileSize() {
        return this.partiallyDirtyFileSize;
    }

    public long getTotalModsSize() {
        return this.totalModsFileSize;
    }

    @Override
    public long getEstimatedMemoryCost() {
        if (this.filesView.sourceFilesInCompactionPerformer.isEmpty()) {
            return 0L;
        }
        return super.getEstimatedMemoryCost();
    }

    @Override
    public String toString() {
        return this.storageGroupName + "-" + this.dataRegionId + "-" + this.timePartition + " fully_dirty file num is " + this.fullyDirtyFiles.size() + ", partially_dirty file num is " + this.filesView.sourceFilesInCompactionPerformer.size() + ", fully_dirty files is " + this.fullyDirtyFiles + ", partially_dirty files is " + this.filesView.sourceFilesInCompactionPerformer;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SettleCompactionTask)) {
            return false;
        }
        return this.equalsOtherTask((SettleCompactionTask)other);
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (!(otherTask instanceof SettleCompactionTask)) {
            return false;
        }
        SettleCompactionTask otherSettleCompactionTask = (SettleCompactionTask)otherTask;
        return this.fullyDirtyFiles.equals(otherSettleCompactionTask.fullyDirtyFiles) && this.filesView.sourceFilesInCompactionPerformer.equals(otherSettleCompactionTask.filesView.sourceFilesInCompactionPerformer) && this.performer.getClass().isInstance(otherSettleCompactionTask.performer);
    }

    @Override
    public long getSelectedFileSize() {
        return (long)(this.partiallyDirtyFileSize + this.fullyDirtyFileSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fullyDirtyFiles, this.filesView.sourceFilesInCompactionPerformer, this.performer);
    }
}

