/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;

public final class RecordsSnapshotWriter<T>
implements SnapshotWriter<T> {
    private final RawSnapshotWriter snapshot;
    private final BatchAccumulator<T> accumulator;
    private final Time time;

    private RecordsSnapshotWriter(RawSnapshotWriter snapshot, int maxBatchSize, MemoryPool memoryPool, Time time, Compression compression, RecordSerde<T> serde) {
        this.snapshot = snapshot;
        this.time = time;
        this.accumulator = new BatchAccumulator<T>(snapshot.snapshotId().epoch(), 0L, Integer.MAX_VALUE, maxBatchSize, 10, memoryPool, time, compression, serde);
    }

    private void finalizeSnapshotWithFooter() {
        SnapshotFooterRecord footerRecord = new SnapshotFooterRecord().setVersion((short)0);
        this.accumulator.appendSnapshotFooterRecord(footerRecord, this.time.milliseconds());
        this.accumulator.forceDrain();
    }

    @Override
    public OffsetAndEpoch snapshotId() {
        return this.snapshot.snapshotId();
    }

    @Override
    public long lastContainedLogOffset() {
        return this.snapshot.snapshotId().offset() - 1L;
    }

    @Override
    public int lastContainedLogEpoch() {
        return this.snapshot.snapshotId().epoch();
    }

    @Override
    public boolean isFrozen() {
        return this.snapshot.isFrozen();
    }

    @Override
    public void append(List<T> records) {
        if (this.snapshot.isFrozen()) {
            String message = String.format("Append not supported. Snapshot is already frozen: id = '%s'.", this.snapshot.snapshotId());
            throw new IllegalStateException(message);
        }
        this.accumulator.append(this.snapshot.snapshotId().epoch(), records, false);
        if (this.accumulator.needsDrain(this.time.milliseconds())) {
            this.appendBatches(this.accumulator.drain());
        }
    }

    @Override
    public long freeze() {
        this.finalizeSnapshotWithFooter();
        this.appendBatches(this.accumulator.drain());
        this.snapshot.freeze();
        this.accumulator.close();
        return this.snapshot.sizeInBytes();
    }

    @Override
    public void close() {
        this.snapshot.close();
        this.accumulator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendBatches(List<BatchAccumulator.CompletedBatch<T>> batches) {
        try {
            for (BatchAccumulator.CompletedBatch<BatchAccumulator.CompletedBatch> completedBatch : batches) {
                this.snapshot.append(completedBatch.data);
            }
        }
        finally {
            batches.forEach(BatchAccumulator.CompletedBatch::release);
        }
    }

    public static final class Builder {
        private long lastContainedLogTimestamp = 0L;
        private Compression compression = Compression.NONE;
        private Time time = Time.SYSTEM;
        private int maxBatchSize = 1024;
        private MemoryPool memoryPool = MemoryPool.NONE;
        private KRaftVersion kraftVersion = KRaftVersion.KRAFT_VERSION_1;
        private Optional<VoterSet> voterSet = Optional.empty();
        private Optional<RawSnapshotWriter> rawSnapshotWriter = Optional.empty();

        public Builder setLastContainedLogTimestamp(long lastContainedLogTimestamp) {
            this.lastContainedLogTimestamp = lastContainedLogTimestamp;
            return this;
        }

        public Builder setCompression(Compression compression) {
            this.compression = compression;
            return this;
        }

        public Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        public Builder setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder setMemoryPool(MemoryPool memoryPool) {
            this.memoryPool = memoryPool;
            return this;
        }

        public Builder setRawSnapshotWriter(RawSnapshotWriter rawSnapshotWriter) {
            this.rawSnapshotWriter = Optional.ofNullable(rawSnapshotWriter);
            return this;
        }

        public Builder setKraftVersion(KRaftVersion kraftVersion) {
            this.kraftVersion = kraftVersion;
            return this;
        }

        public Builder setVoterSet(Optional<VoterSet> voterSet) {
            this.voterSet = voterSet;
            return this;
        }

        public <T> RecordsSnapshotWriter<T> build(RecordSerde<T> serde) {
            if (this.rawSnapshotWriter.isEmpty()) {
                throw new IllegalStateException("Builder::build called without a RawSnapshotWriter");
            }
            if (this.rawSnapshotWriter.get().sizeInBytes() != 0L) {
                throw new IllegalStateException(String.format("Initializing writer with a non-empty snapshot: %s", this.rawSnapshotWriter.get().snapshotId()));
            }
            if (this.kraftVersion == KRaftVersion.KRAFT_VERSION_0 && this.voterSet.isPresent()) {
                throw new IllegalStateException(String.format("Voter set (%s) not expected when the kraft.version is 0", this.voterSet.get()));
            }
            RecordsSnapshotWriter<T> writer = new RecordsSnapshotWriter<T>(this.rawSnapshotWriter.get(), this.maxBatchSize, this.memoryPool, this.time, this.compression, serde);
            writer.accumulator.appendControlMessages((baseOffset, epoch, compression, buffer) -> {
                long now = this.time.milliseconds();
                try (MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 2, compression, TimestampType.CREATE_TIME, baseOffset, now, -1L, -1, -1, false, true, epoch, buffer.capacity());){
                    builder.appendSnapshotHeaderMessage(now, new SnapshotHeaderRecord().setVersion((short)0).setLastContainedLogTimestamp(this.lastContainedLogTimestamp));
                    if (this.kraftVersion.isReconfigSupported()) {
                        builder.appendKRaftVersionMessage(now, new KRaftVersionRecord().setVersion((short)0).setKRaftVersion(this.kraftVersion.featureLevel()));
                        if (this.voterSet.isPresent()) {
                            builder.appendVotersMessage(now, this.voterSet.get().toVotersRecord((short)0));
                        }
                    }
                    MemoryRecords memoryRecords = builder.build();
                    return memoryRecords;
                }
            });
            return writer;
        }
    }
}

