/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Collection;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface OptionalFeature {
    public static final OptionalFeature TRUE = new OptionalFeature(){

        @Override
        public boolean isSupported() {
            return true;
        }

        public String toString() {
            return "TRUE";
        }
    };
    public static final OptionalFeature FALSE = new OptionalFeature(){

        @Override
        public boolean isSupported() {
            return false;
        }

        public String toString() {
            return "FALSE";
        }
    };

    public boolean isSupported();

    public static OptionalFeature of(boolean supported) {
        return supported ? TRUE : FALSE;
    }

    public static OptionalFeature all(Collection<? extends OptionalFeature> features) {
        return () -> {
            if (GenericUtils.isEmpty(features)) {
                return false;
            }
            for (OptionalFeature f : features) {
                if (f.isSupported()) continue;
                return false;
            }
            return true;
        };
    }

    public static OptionalFeature any(Collection<? extends OptionalFeature> features) {
        return () -> {
            if (GenericUtils.isEmpty(features)) {
                return false;
            }
            for (OptionalFeature f : features) {
                if (!f.isSupported()) continue;
                return true;
            }
            return false;
        };
    }
}

