/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transaction.manager.XidImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryImpl
implements Recovery {
    private static final Logger log = LoggerFactory.getLogger((String)"Recovery");
    private final TransactionManagerImpl txManager;
    private final Map<Xid, TransactionImpl> externalXids = new HashMap<Xid, TransactionImpl>();
    private final Map<ByteArrayWrapper, Recovery.XidBranchesPair> ourXids = new HashMap<ByteArrayWrapper, Recovery.XidBranchesPair>();
    private final Map<String, Set<Recovery.XidBranchesPair>> nameToOurTxMap = new HashMap<String, Set<Recovery.XidBranchesPair>>();
    private final Map<byte[], TransactionImpl> externalGlobalIdMap = new HashMap<byte[], TransactionImpl>();
    private final List<Exception> recoveryErrors = new ArrayList<Exception>();

    public RecoveryImpl(TransactionManagerImpl txManager) {
        this.txManager = txManager;
    }

    @Override
    public synchronized void recoverLog() throws XAException {
        Collection<Recovery.XidBranchesPair> preparedXids;
        try {
            preparedXids = this.txManager.getTransactionLog().recover(this.txManager.getXidFactory());
        }
        catch (LogException e) {
            throw (XAException)new XAException(-3).initCause(e);
        }
        for (Recovery.XidBranchesPair xidBranchesPair : preparedXids) {
            Xid xid = xidBranchesPair.getXid();
            log.trace("read prepared global xid from log: " + RecoveryImpl.toString(xid));
            if (this.txManager.getXidFactory().matchesGlobalId(xid.getGlobalTransactionId())) {
                this.ourXids.put(new ByteArrayWrapper(xid.getGlobalTransactionId()), xidBranchesPair);
                for (TransactionBranchInfo transactionBranchInfo : xidBranchesPair.getBranches()) {
                    log.trace("read branch from log: " + transactionBranchInfo.toString());
                    String name = transactionBranchInfo.getResourceName();
                    Set<Recovery.XidBranchesPair> transactionsForName = this.nameToOurTxMap.get(name);
                    if (transactionsForName == null) {
                        transactionsForName = new HashSet<Recovery.XidBranchesPair>();
                        this.nameToOurTxMap.put(name, transactionsForName);
                    }
                    transactionsForName.add(xidBranchesPair);
                }
                continue;
            }
            log.trace("read external prepared xid from log: " + RecoveryImpl.toString(xid));
            ExternalTransaction externalTx = new ExternalTransaction(xid, this.txManager, xidBranchesPair.getBranches());
            this.externalXids.put(xid, externalTx);
            this.externalGlobalIdMap.put(xid.getGlobalTransactionId(), externalTx);
        }
    }

    @Override
    public synchronized void recoverResourceManager(NamedXAResource xaResource) throws XAException {
        String name = xaResource.getName();
        Xid[] prepared = xaResource.recover(0x1800000);
        for (int i = 0; prepared != null && i < prepared.length; ++i) {
            Xid xid = prepared[i];
            if (xid.getGlobalTransactionId() == null || xid.getBranchQualifier() == null) {
                log.warn("Ignoring bad xid from\n name: " + xaResource.getName() + "\n " + RecoveryImpl.toString(xid));
                continue;
            }
            log.trace("Considering recovered xid from\n name: " + xaResource.getName() + "\n " + RecoveryImpl.toString(xid));
            ByteArrayWrapper globalIdWrapper = new ByteArrayWrapper(xid.getGlobalTransactionId());
            Recovery.XidBranchesPair xidNamesPair = this.ourXids.get(globalIdWrapper);
            if (xidNamesPair != null) {
                if (this.isNameInTransaction(xidNamesPair, name, xid)) {
                    log.trace("This xid was prepared from this XAResource: committing");
                    this.commit(xaResource, xid);
                    this.removeNameFromTransaction(xidNamesPair, name, true);
                    continue;
                }
                log.trace("This xid was prepared from another XAResource, ignoring");
                continue;
            }
            if (this.txManager.getXidFactory().matchesGlobalId(xid.getGlobalTransactionId())) {
                log.trace("this xid was initiated from this tm but not prepared: rolling back");
                this.rollback(xaResource, xid);
                continue;
            }
            if (!this.txManager.getXidFactory().matchesBranchId(xid.getBranchQualifier())) continue;
            TransactionImpl externalTx = this.externalGlobalIdMap.get(xid.getGlobalTransactionId());
            if (externalTx == null) {
                log.trace("this xid is from an external transaction and was not prepared: rolling back");
                this.rollback(xaResource, xid);
                continue;
            }
            log.trace("this xid is from an external transaction and was prepared in this tm.  Waiting for instructions from transaction originator");
            externalTx.addBranchXid(xaResource, xid);
        }
        Set<Recovery.XidBranchesPair> transactionsForName = this.nameToOurTxMap.get(name);
        if (transactionsForName != null) {
            for (Recovery.XidBranchesPair xidBranchesPair : transactionsForName) {
                this.removeNameFromTransaction(xidBranchesPair, name, false);
            }
        }
    }

    private void commit(NamedXAResource xaResource, Xid xid) {
        this.doCommitOrRollback(xaResource, xid, true);
    }

    private void rollback(NamedXAResource xaResource, Xid xid) {
        this.doCommitOrRollback(xaResource, xid, false);
    }

    private void doCommitOrRollback(NamedXAResource xaResource, Xid xid, boolean commit) {
        block12: {
            try {
                if (commit) {
                    xaResource.commit(xid, false);
                } else {
                    xaResource.rollback(xid);
                }
            }
            catch (XAException e) {
                try {
                    if (e.errorCode == 6) {
                        log.info("Transaction has been heuristically rolled back");
                        xaResource.forget(xid);
                    } else if (e.errorCode == 5) {
                        log.info("Transaction has been heuristically committed and rolled back");
                        xaResource.forget(xid);
                    } else if (e.errorCode == 7) {
                        log.info("Transaction has been heuristically committed");
                        xaResource.forget(xid);
                    } else {
                        this.recoveryErrors.add(e);
                        log.error("Could not roll back", (Throwable)e);
                    }
                }
                catch (XAException e2) {
                    if (e2.errorCode == -4) break block12;
                    this.recoveryErrors.add(e);
                    log.error("Could not roll back", (Throwable)e);
                }
            }
        }
    }

    private boolean isNameInTransaction(Recovery.XidBranchesPair xidBranchesPair, String name, Xid xid) {
        for (TransactionBranchInfo transactionBranchInfo : xidBranchesPair.getBranches()) {
            if (!name.equals(transactionBranchInfo.getResourceName()) || !this.equals(xid, transactionBranchInfo.getBranchXid())) continue;
            return true;
        }
        return false;
    }

    private boolean equals(Xid xid1, Xid xid2) {
        return xid1.getFormatId() == xid1.getFormatId() && Arrays.equals(xid1.getBranchQualifier(), xid2.getBranchQualifier()) && Arrays.equals(xid1.getGlobalTransactionId(), xid2.getGlobalTransactionId());
    }

    private void removeNameFromTransaction(Recovery.XidBranchesPair xidBranchesPair, String name, boolean warn) {
        int removed = 0;
        Iterator<TransactionBranchInfo> branches = xidBranchesPair.getBranches().iterator();
        while (branches.hasNext()) {
            TransactionBranchInfo transactionBranchInfo = branches.next();
            if (!name.equals(transactionBranchInfo.getResourceName())) continue;
            branches.remove();
            ++removed;
        }
        if (warn && removed == 0) {
            log.error("XAResource named: " + name + " returned branch xid for xid: " + xidBranchesPair.getXid() + " but was not registered with that transaction!");
        }
        if (xidBranchesPair.getBranches().isEmpty() && 0 != removed) {
            try {
                this.ourXids.remove(new ByteArrayWrapper(xidBranchesPair.getXid().getGlobalTransactionId()));
                this.txManager.getTransactionLog().commit(xidBranchesPair.getXid(), xidBranchesPair.getMark());
            }
            catch (LogException e) {
                this.recoveryErrors.add(e);
                log.error("Could not commit", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized boolean hasRecoveryErrors() {
        return !this.recoveryErrors.isEmpty();
    }

    @Override
    public synchronized List<Exception> getRecoveryErrors() {
        return Collections.unmodifiableList(this.recoveryErrors);
    }

    @Override
    public synchronized boolean localRecoveryComplete() {
        return this.ourXids.isEmpty();
    }

    @Override
    public synchronized int localUnrecoveredCount() {
        return this.ourXids.size();
    }

    @Override
    public synchronized Map<Xid, TransactionImpl> getExternalXids() {
        return new HashMap<Xid, TransactionImpl>(this.externalXids);
    }

    private static String toString(Xid xid) {
        if (xid instanceof XidImpl) {
            return xid.toString();
        }
        StringBuilder s = new StringBuilder();
        s.append("[Xid:class=").append(xid.getClass().getSimpleName()).append(":globalId=");
        byte[] globalId = xid.getGlobalTransactionId();
        if (globalId == null) {
            s.append("null");
        } else {
            for (int i = 0; i < globalId.length; ++i) {
                s.append(Integer.toHexString(globalId[i]));
            }
            s.append(",length=").append(globalId.length);
        }
        s.append(",branchId=");
        byte[] branchId = xid.getBranchQualifier();
        if (branchId == null) {
            s.append("null");
        } else {
            for (int i = 0; i < branchId.length; ++i) {
                s.append(Integer.toHexString(branchId[i]));
            }
            s.append(",length=").append(branchId.length);
        }
        s.append("]");
        return s.toString();
    }

    private static class ExternalTransaction
    extends TransactionImpl {
        private final Set<String> resourceNames = new HashSet<String>();

        public ExternalTransaction(Xid xid, TransactionManagerImpl txManager, Set<TransactionBranchInfo> resourceNames) {
            super(xid, txManager);
            for (TransactionBranchInfo info : resourceNames) {
                this.resourceNames.add(info.getResourceName());
            }
        }

        public boolean hasName(String name) {
            return this.resourceNames.contains(name);
        }

        public void removeName(String name) {
            this.resourceNames.remove(name);
        }

        @Override
        public void preparedCommit() throws HeuristicRollbackException, HeuristicMixedException, SystemException {
            if (!this.resourceNames.isEmpty()) {
                throw new SystemException("This tx does not have all resource managers online, commit not allowed yet");
            }
            super.preparedCommit();
        }

        @Override
        public void rollback() throws SystemException {
            if (!this.resourceNames.isEmpty()) {
                throw new SystemException("This tx does not have all resource managers online, rollback not allowed yet");
            }
            super.rollback();
        }
    }

    private static class ByteArrayWrapper {
        private final byte[] bytes;
        private final int hashCode;

        public ByteArrayWrapper(byte[] bytes) {
            assert (bytes != null);
            this.bytes = bytes;
            int hash = 0;
            for (byte aByte : bytes) {
                hash += 37 * aByte;
            }
            this.hashCode = hash;
        }

        public boolean equals(Object other) {
            if (other instanceof ByteArrayWrapper) {
                return Arrays.equals(this.bytes, ((ByteArrayWrapper)other).bytes);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

