/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.JavaTypeResolver;
import org.jooq.meta.SchemaDefinition;

public class DefaultDataTypeDefinition
implements DataTypeDefinition {
    private final Database database;
    private final SchemaDefinition schema;
    private final String type;
    private final Name userType;
    private final String javaType;
    private final String converter;
    private final String binding;
    private final boolean nullable;
    private boolean isIdentity;
    private final String defaultValue;
    private final int length;
    private final int precision;
    private final int scale;

    private static final String defaultValue(Boolean defaultable) {
        return defaultable != null && defaultable != false ? "NULL" : null;
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName) {
        this(database, schema, typeName, null, null, null, null, (String)null, (Name)null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, Boolean defaultable) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultable, typeName, null);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, typeName, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, Boolean defaultable, String userType) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultable, userType, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, String userType) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, DSL.name((String)userType));
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, Boolean defaultValue, Name userType) {
        this(database, schema, typeName, length, precision, scale, nullable, DefaultDataTypeDefinition.defaultValue(defaultValue), userType);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, Name userType) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, userType, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, Boolean defaultable, String userType, String converter) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultable, userType, converter, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, String userType, String converter) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, DSL.name((String)userType), converter);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, Name userType, String converter) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, userType, converter, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, Boolean defaultable, String userType, String converter, String binding) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultable, userType, converter, binding, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, String userType, String converter, String binding) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, DSL.name((String)userType), converter, binding, null);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, Name userType, String converter, String binding) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, userType, converter, binding, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, Boolean defaultable, String userType, String converter, String binding, String javaType) {
        this(database, schema, typeName, length, precision, scale, nullable, DefaultDataTypeDefinition.defaultValue(defaultable), userType, converter, binding, javaType);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, String userType, String converter, String binding, String javaType) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, DSL.name((String)userType), converter, binding, javaType);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, Name userType, String converter, String binding, String javaType) {
        this.database = database;
        this.schema = schema;
        this.type = typeName == null ? "OTHER" : typeName;
        this.userType = userType;
        this.javaType = javaType;
        this.converter = converter;
        this.binding = binding;
        if (length != null && precision != null && length.intValue() != 0 && precision.intValue() != 0) {
            if (this.type.toLowerCase().matches(".*?(char|text|lob|xml|graphic|string).*?")) {
                precision = null;
                scale = null;
            } else {
                length = null;
            }
        }
        this.length = length == null ? 0 : length.intValue();
        this.precision = precision == null ? 0 : precision.intValue();
        this.scale = scale == null ? 0 : scale.intValue();
        this.nullable = nullable == null ? true : nullable;
        this.defaultValue = defaultValue;
    }

    @Override
    public final Database getDatabase() {
        return this.database;
    }

    @Override
    public final SchemaDefinition getSchema() {
        return this.schema;
    }

    private final SQLDialect getDialect() {
        return this.getDatabase().getDialect();
    }

    @Override
    public final boolean isNullable() {
        return this.nullable;
    }

    public final DefaultDataTypeDefinition identity(boolean identity) {
        this.isIdentity = identity;
        return this;
    }

    @Override
    public final boolean isIdentity() {
        return this.isIdentity;
    }

    @Override
    public final boolean isDefaulted() {
        return this.getDefaultValue() != null;
    }

    @Override
    public final String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public final boolean isUDT() {
        if (this.userType == null) {
            return false;
        }
        return this.getDatabase().getUDT(this.schema, this.userType) != null;
    }

    @Override
    public final boolean isArray() {
        if (this.userType == null) {
            return false;
        }
        return this.getDatabase().getArray(this.schema, this.userType) != null;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getConverter() {
        return this.converter;
    }

    @Override
    public final String getBinding() {
        return this.binding;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final int getPrecision() {
        return this.precision;
    }

    @Override
    public final int getScale() {
        return this.scale;
    }

    @Override
    public final String getUserType() {
        return this.userType != null ? this.userType.last() : null;
    }

    @Override
    public final Name getQualifiedUserType() {
        return this.userType;
    }

    @Override
    public final String getJavaType() {
        return this.javaType;
    }

    @Override
    public final String getJavaType(JavaTypeResolver resolver) {
        if (resolver == null) {
            return this.getJavaType();
        }
        return resolver.resolve(this);
    }

    @Override
    public final boolean isGenericNumberType() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userType == null ? 0 : this.userType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDataTypeDefinition) {
            DefaultDataTypeDefinition other = (DefaultDataTypeDefinition)obj;
            if (!DefaultDataType.normalise((String)this.type).equals(DefaultDataType.normalise((String)other.type))) {
                return false;
            }
            if (this.userType == null && other.userType == null) {
                return true;
            }
            if (this.userType == null || other.userType == null) {
                return false;
            }
            return DefaultDataType.normalise((String)this.userType.last()).equals(DefaultDataType.normalise((String)other.userType.last()));
        }
        return false;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataType [ t=");
        sb.append(this.type);
        sb.append("; p=");
        sb.append(this.precision);
        sb.append("; s=");
        sb.append(this.scale);
        sb.append("; u=");
        sb.append(this.userType);
        sb.append("; j=");
        sb.append(this.javaType);
        sb.append(" ]");
        return sb.toString();
    }
}

