/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.time.Duration;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.fs.DUFactory;
import org.apache.hadoop.hdds.fs.DUOptimized;
import org.apache.hadoop.hdds.fs.SaveSpaceUsageToFile;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;

public class DUOptimizedFactory
implements SpaceUsageCheckFactory {
    private static final String DU_CACHE_FILE = "scmUsed";
    private DUFactory.Conf conf;

    @Override
    public SpaceUsageCheckFactory setConfiguration(ConfigurationSource configuration) {
        this.conf = (DUFactory.Conf)configuration.getObject(DUFactory.Conf.class);
        return this;
    }

    @Override
    public SpaceUsageCheckParams paramsFor(File dir) {
        return null;
    }

    @Override
    public SpaceUsageCheckParams paramsFor(File dir, Supplier<File> exclusionProvider) {
        Duration refreshPeriod = this.conf.getRefreshPeriod();
        DUOptimized source = new DUOptimized(dir, exclusionProvider);
        SaveSpaceUsageToFile persistence = new SaveSpaceUsageToFile(new File(dir, DU_CACHE_FILE), refreshPeriod);
        SpaceUsageCheckParams params = new SpaceUsageCheckParams(dir, source, refreshPeriod, persistence);
        source.setContainerUsedSpaceProvider(params::getContainerUsedSpace);
        return params;
    }
}

