/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security;

import com.google.common.base.Preconditions;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OzoneSecretKey {
    private int keyId;
    private long expiryDate;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private String certSerialId;

    public OzoneSecretKey(int keyId, long expiryDate, KeyPair keyPair, String certificateSerialId) {
        Preconditions.checkNotNull((Object)keyId);
        this.keyId = keyId;
        this.expiryDate = expiryDate;
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        this.certSerialId = certificateSerialId;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getCertSerialId() {
        return this.certSerialId;
    }

    public byte[] getEncodedPrivateKey() {
        return this.privateKey.getEncoded();
    }

    public byte[] getEncodedPubliceKey() {
        return this.publicKey.getEncoded();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(537, 963);
        hashCodeBuilder.append(this.getExpiryDate()).append(this.getKeyId()).append(this.getEncodedPrivateKey()).append(this.getEncodedPubliceKey());
        return hashCodeBuilder.build();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OzoneSecretKey) {
            OzoneSecretKey that = (OzoneSecretKey)obj;
            return new EqualsBuilder().append(this.keyId, that.keyId).append(this.expiryDate, that.expiryDate).append((Object)this.privateKey, (Object)that.privateKey).append((Object)this.publicKey, (Object)that.publicKey).build();
        }
        return false;
    }
}

