/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.ratis.thirdparty.io.netty.util.internal.PlatformDependent;

public final class NettyMetrics
implements MetricsSource {
    public static final String SOURCE_NAME = NettyMetrics.class.getSimpleName();

    public static NettyMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        NettyMetrics metrics = new NettyMetrics();
        return (NettyMetrics)ms.register(SOURCE_NAME, "Netty metrics", (Object)metrics);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME).setContext("Netty metrics");
        recordBuilder.addGauge((MetricsInfo)MetricsInfos.USED_DIRECT_MEM, PlatformDependent.usedDirectMemory()).addGauge((MetricsInfo)MetricsInfos.MAX_DIRECT_MEM, PlatformDependent.maxDirectMemory());
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    private static enum MetricsInfos implements MetricsInfo
    {
        USED_DIRECT_MEM("Used direct memory."),
        MAX_DIRECT_MEM("Max direct memory.");

        private final String desc;

        private MetricsInfos(String desc) {
            this.desc = desc;
        }

        public String description() {
            return this.desc;
        }
    }
}

