/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.FinalizeNewLayoutVersionCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeNewLayoutVersionCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FinalizeNewLayoutVersionCommandHandler.class);
    private AtomicLong invocationCount = new AtomicLong(0L);
    private final MutableRate opsLatencyMs;

    public FinalizeNewLayoutVersionCommandHandler() {
        MetricsRegistry registry = new MetricsRegistry(FinalizeNewLayoutVersionCommandHandler.class.getSimpleName());
        this.opsLatencyMs = registry.newRate(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.finalizeNewLayoutVersionCommand + "Ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SCMCommand<?> command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        LOG.info("Processing FinalizeNewLayoutVersionCommandHandler command.");
        this.invocationCount.incrementAndGet();
        long startTime = Time.monotonicNow();
        DatanodeStateMachine dsm = context.getParent();
        StorageContainerDatanodeProtocolProtos.FinalizeNewLayoutVersionCommandProto finalizeCommand = ((FinalizeNewLayoutVersionCommand)command).getProto();
        try {
            if (finalizeCommand.getFinalizeNewLayoutVersion() && dsm.getLayoutVersionManager().getUpgradeState() == UpgradeFinalization.Status.FINALIZATION_REQUIRED) {
                LOG.info("Finalize Upgrade called!");
                dsm.finalizeUpgrade();
            }
        }
        catch (Exception e) {
            LOG.error("Exception during finalization.", (Throwable)e);
        }
        finally {
            long endTime = Time.monotonicNow();
            this.opsLatencyMs.add(endTime - startTime);
        }
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.finalizeNewLayoutVersionCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        return (long)this.opsLatencyMs.lastStat().mean();
    }

    @Override
    public long getTotalRunTime() {
        return (long)this.opsLatencyMs.lastStat().total();
    }

    @Override
    public int getQueuedCount() {
        return 0;
    }
}

