/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.admin.scm.ScmAdmin;
import picocli.CommandLine;

@CommandLine.Command(name="decommission", description={"Decommission SCM <scmid>.  Includes removing from ratis ring and removing its certificate from certStore"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DecommissionScmSubcommand
extends ScmSubcommand {
    @CommandLine.ParentCommand
    private ScmAdmin parent;
    @CommandLine.Option(names={"-nodeid", "--nodeid"}, description={"NodeID of the SCM to be decommissioned."}, required=true)
    private String nodeId;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        StorageContainerLocationProtocolProtos.DecommissionScmResponseProto response = scmClient.decommissionScm(this.nodeId);
        if (!response.getSuccess()) {
            String errorMsg = "Error decommissioning Scm " + this.nodeId;
            if (response.hasErrorMsg()) {
                errorMsg = errorMsg + ", " + response.getErrorMsg();
            }
            throw new IOException(errorMsg);
        }
        System.out.println("Decommissioned Scm " + this.nodeId);
    }
}

