/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.execution;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OMAuditLogger;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.util.MetricUtil;

public class OMExecutionFlow {
    private final OzoneManager ozoneManager;
    private final OMPerformanceMetrics perfMetrics;

    public OMExecutionFlow(OzoneManager om) {
        this.ozoneManager = om;
        this.perfMetrics = this.ozoneManager.getPerfMetrics();
    }

    public OzoneManagerProtocolProtos.OMResponse submit(OzoneManagerProtocolProtos.OMRequest omRequest) throws ServiceException {
        return this.submitExecutionToRatis(omRequest);
    }

    private OzoneManagerProtocolProtos.OMResponse submitExecutionToRatis(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.OMRequest requestToSubmit;
        OMClientRequest omClientRequest = null;
        try {
            omClientRequest = OzoneManagerRatisUtils.createClientRequest(request, this.ozoneManager);
            assert (omClientRequest != null);
            OMClientRequest finalOmClientRequest = omClientRequest;
            requestToSubmit = (OzoneManagerProtocolProtos.OMRequest)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getPreExecuteLatencyNs(), () -> finalOmClientRequest.preExecute(this.ozoneManager));
        }
        catch (IOException ex) {
            if (omClientRequest != null) {
                OMAuditLogger.log(omClientRequest.getAuditBuilder());
                omClientRequest.handleRequestFailure(this.ozoneManager);
            }
            return OzoneManagerRatisUtils.createErrorResponse(request, ex);
        }
        OzoneManagerProtocolProtos.OMResponse response = this.ozoneManager.getOmRatisServer().submitRequest(requestToSubmit);
        if (!response.getSuccess()) {
            omClientRequest.handleRequestFailure(this.ozoneManager);
        }
        return response;
    }
}

