/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmFSOFile;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest;
import org.apache.hadoop.ozone.om.request.util.OmKeyHSyncUtil;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCommitResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCommitRequestWithFSO
extends OMKeyCommitRequest {
    @VisibleForTesting
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyCommitRequestWithFSO.class);

    public OMKeyCommitRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        boolean isHSync;
        OMClientResponse omClientResponse;
        OmKeyInfo omKeyInfo;
        Exception exception;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest;
        block35: {
            boolean isRecovery;
            long trxnLogIndex = context.getIndex();
            commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs commitKeyArgs = commitKeyRequest.getKeyArgs();
            volumeName = commitKeyArgs.getVolumeName();
            bucketName = commitKeyArgs.getBucketName();
            keyName = commitKeyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildKeyArgsAuditMap(commitKeyArgs);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            omKeyInfo = null;
            omClientResponse = null;
            boolean bucketLockAcquired = false;
            isHSync = commitKeyRequest.hasHsync() && commitKeyRequest.getHsync();
            boolean bl = isRecovery = commitKeyRequest.hasRecovery() && commitKeyRequest.getRecovery();
            if (isHSync) {
                omMetrics.incNumKeyHSyncs();
            } else {
                omMetrics.incNumKeyCommits();
            }
            LOG.debug("isHSync = {}, isRecovery = {}, volumeName = {}, bucketName = {}, keyName = {}", new Object[]{isHSync, isRecovery, volumeName, bucketName, keyName});
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            try {
                try {
                    OmKeyInfo pseudoKeyInfo;
                    long pseudoObjId;
                    String delKeyName;
                    String dbOpenFileKey = null;
                    List<OmKeyLocationInfo> locationInfoList = this.getOmKeyLocationInfos(ozoneManager, commitKeyArgs);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    bucketLockAcquired = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OmBucketInfo omBucketInfo = OMKeyCommitRequestWithFSO.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    String errMsg = "Cannot create file : " + keyName + " as parent directory doesn't exist";
                    OmFSOFile fsoFile = new OmFSOFile.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setOmMetadataManager(omMetadataManager).setErrMsg(errMsg).build();
                    String fileName = fsoFile.getFileName();
                    long volumeId = fsoFile.getVolumeId();
                    String dbFileKey = fsoFile.getOzonePathKey();
                    OmKeyInfo keyToDelete = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbFileKey);
                    long writerClientId = commitKeyRequest.getClientID();
                    boolean isSameHsyncKey = false;
                    boolean isOverwrittenHsyncKey = false;
                    String clientIdString = String.valueOf(writerClientId);
                    if (keyToDelete != null && !(isSameHsyncKey = Optional.of(keyToDelete).map(WithMetadata::getMetadata).map(meta -> (String)meta.get("hsyncClientId")).filter(id -> id.equals(clientIdString)).isPresent())) {
                        boolean bl2 = isOverwrittenHsyncKey = Optional.of(keyToDelete).map(WithMetadata::getMetadata).map(meta -> (String)meta.get("hsyncClientId")).filter(id -> !id.equals(clientIdString)).isPresent() && !isRecovery;
                    }
                    if (isRecovery && keyToDelete != null) {
                        String clientId = (String)keyToDelete.getMetadata().get("hsyncClientId");
                        if (clientId == null) {
                            throw new OMException("Failed to recovery key, as " + dbFileKey + " is already closed", OMException.ResultCodes.KEY_ALREADY_CLOSED);
                        }
                        writerClientId = Long.parseLong(clientId);
                    }
                    if ((omKeyInfo = OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, dbOpenFileKey = fsoFile.getOpenFileName(writerClientId), keyName)) == null) {
                        String action = isRecovery ? "recovery" : (isHSync ? "hsync" : "commit");
                        throw new OMException("Failed to " + action + " key, as " + dbOpenFileKey + " entry is not found in the OpenKey table", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    if (omKeyInfo.getMetadata().containsKey("deletedHsyncKey") || omKeyInfo.getMetadata().containsKey("overwrittenHsyncKey")) {
                        throw new OMException("Open Key " + keyName + " is already deleted/overwritten", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    if (omKeyInfo.getMetadata().containsKey("leaseRecovery") && omKeyInfo.getMetadata().containsKey("hsyncClientId") && !isRecovery) {
                        throw new OMException("Cannot commit key " + dbOpenFileKey + " with " + "leaseRecovery" + " metadata while recovery flag is not set in request", OMException.ResultCodes.KEY_UNDER_LEASE_RECOVERY);
                    }
                    OmKeyInfo openKeyToDelete = null;
                    String dbOpenKeyToDeleteKey = null;
                    if (isOverwrittenHsyncKey) {
                        dbOpenKeyToDeleteKey = fsoFile.getOpenFileName(Long.parseLong((String)keyToDelete.getMetadata().get("hsyncClientId")));
                        openKeyToDelete = OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, dbOpenKeyToDeleteKey, keyName);
                        openKeyToDelete.getMetadata().put("overwrittenHsyncKey", "true");
                        openKeyToDelete.setModificationTime(Time.now());
                        openKeyToDelete.setUpdateID(trxnLogIndex);
                        OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, dbOpenKeyToDeleteKey, openKeyToDelete, keyName, fileName, trxnLogIndex);
                    }
                    omKeyInfo.setModificationTime(commitKeyArgs.getModificationTime());
                    OmKeyInfo newOpenKeyInfo = null;
                    if (isHSync && !OmKeyHSyncUtil.isHSyncedPreviously(omKeyInfo, clientIdString, dbOpenFileKey)) {
                        omKeyInfo.getMetadata().put("hsyncClientId", clientIdString);
                        newOpenKeyInfo = omKeyInfo.copyObject();
                    }
                    omKeyInfo.getMetadata().putAll(KeyValueUtil.getFromProtobuf((List)commitKeyArgs.getMetadataList()));
                    omKeyInfo.setDataSize(commitKeyArgs.getDataSize());
                    List uncommitted = omKeyInfo.updateLocationInfoList(locationInfoList, false);
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    HashMap<String, RepeatedOmKeyInfo> oldKeyVersionsToDeleteMap = null;
                    this.validateAtomicRewrite(keyToDelete, omKeyInfo, auditMap);
                    omKeyInfo.setExpectedDataGeneration(null);
                    long correctedSpace = omKeyInfo.getReplicatedSize();
                    if (keyToDelete != null && isSameHsyncKey) {
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace -= keyToDelete.getReplicatedSize());
                    } else if (keyToDelete != null && !omBucketInfo.getIsVersionEnabled()) {
                        RepeatedOmKeyInfo oldVerKeyInfo = this.getOldVersionsToCleanUp(keyToDelete, omBucketInfo.getObjectID(), trxnLogIndex);
                        delKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, fileName);
                        pseudoObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
                        delKeyName = omMetadataManager.getOzoneDeletePathKey(pseudoObjId, delKeyName);
                        if (oldKeyVersionsToDeleteMap == null) {
                            oldKeyVersionsToDeleteMap = new HashMap<String, RepeatedOmKeyInfo>();
                        }
                        Pair<Map<OmKeyInfo, List<OmKeyLocationInfo>>, Integer> filteredUsedBlockCnt = this.filterOutBlocksStillInUse(omKeyInfo, oldVerKeyInfo);
                        Map blocks = (Map)filteredUsedBlockCnt.getLeft();
                        correctedSpace -= blocks.entrySet().stream().mapToLong(filteredKeyBlocks -> ((List)filteredKeyBlocks.getValue()).stream().mapToLong(block -> QuotaUtil.getReplicatedSize((long)block.getLength(), (ReplicationConfig)((OmKeyInfo)filteredKeyBlocks.getKey()).getReplicationConfig())).sum()).sum();
                        long totalSize = 0L;
                        long totalNamespace = 0L;
                        if (!oldVerKeyInfo.getOmKeyInfoList().isEmpty()) {
                            oldKeyVersionsToDeleteMap.put(delKeyName, oldVerKeyInfo);
                            for (OmKeyInfo olderKeyVersions : oldVerKeyInfo.getOmKeyInfoList()) {
                                olderKeyVersions.setCommittedKeyDeletedFlag(true);
                                totalSize += OMKeyCommitRequestWithFSO.sumBlockLengths(olderKeyVersions);
                                ++totalNamespace;
                            }
                        }
                        this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace);
                        omBucketInfo.decrUsedNamespace(totalNamespace, true);
                        omBucketInfo.decrUsedNamespace((long)((Integer)filteredUsedBlockCnt.getRight()).intValue(), false);
                        omBucketInfo.decrUsedBytes(totalSize, true);
                    } else {
                        this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace);
                    }
                    omBucketInfo.incrUsedNamespace(1L);
                    OmKeyInfo omKeyInfo2 = pseudoKeyInfo = isHSync ? null : this.wrapUncommittedBlocksAsPseudoKey(uncommitted, omKeyInfo);
                    if (pseudoKeyInfo != null) {
                        delKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, fileName);
                        pseudoObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
                        delKeyName = omMetadataManager.getOzoneDeletePathKey(pseudoObjId, delKeyName);
                        if (oldKeyVersionsToDeleteMap == null) {
                            oldKeyVersionsToDeleteMap = new HashMap();
                        }
                        oldKeyVersionsToDeleteMap.computeIfAbsent(delKeyName, key -> new RepeatedOmKeyInfo(omBucketInfo.getObjectID())).addOmKeyInfo(pseudoKeyInfo);
                    }
                    if (!isHSync) {
                        OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, dbOpenFileKey, null, fileName, keyName, trxnLogIndex);
                        omKeyInfo.getMetadata().remove("hsyncClientId");
                        if (isRecovery) {
                            omKeyInfo.getMetadata().remove("leaseRecovery");
                        }
                    } else if (newOpenKeyInfo != null) {
                        OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, dbOpenFileKey, newOpenKeyInfo, fileName, keyName, trxnLogIndex);
                    }
                    OMFileRequest.addFileTableCacheEntry(omMetadataManager, dbFileKey, omKeyInfo, fileName, trxnLogIndex);
                    omBucketInfo.incrUsedBytes(correctedSpace);
                    omClientResponse = new OMKeyCommitResponseWithFSO(omResponse.build(), omKeyInfo, dbFileKey, dbOpenFileKey, omBucketInfo.copyObject(), oldKeyVersionsToDeleteMap, volumeId, isHSync, newOpenKeyInfo, dbOpenKeyToDeleteKey, openKeyToDelete);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyCommitResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (bucketLockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                if (bucketLockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (bucketLockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        LOG.debug("Key commit {} with isHSync = {}, omKeyInfo = {}", new Object[]{result == OMClientRequest.Result.SUCCESS ? "succeeded" : "failed", isHSync, omKeyInfo});
        if (!isHSync) {
            this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.COMMIT_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
            this.processResult(commitKeyRequest, volumeName, bucketName, keyName, omMetrics, exception, omKeyInfo, result);
        }
        return omClientResponse;
    }
}

