/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.validation;

import java.lang.annotation.Annotation;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.Versioned;
import org.apache.hadoop.ozone.om.request.validation.OMClientVersionValidator;
import org.apache.hadoop.ozone.om.request.validation.OMLayoutVersionValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;

public enum VersionExtractor {
    LAYOUT_VERSION_EXTRACTOR{

        @Override
        public Versioned extractVersion(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) {
            LayoutVersionManager layoutVersionManager = ctx.versionManager();
            return ctx.versionManager().getFeature(layoutVersionManager.getMetadataLayoutVersion());
        }

        @Override
        public Class<? extends Annotation> getValidatorClass() {
            return OMLayoutVersionValidator.class;
        }
    }
    ,
    CLIENT_VERSION_EXTRACTOR{

        @Override
        public Versioned extractVersion(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) {
            return req.getVersion() > ClientVersion.CURRENT_VERSION ? ClientVersion.FUTURE_VERSION : ClientVersion.fromProtoValue((int)req.getVersion());
        }

        @Override
        public Class<? extends Annotation> getValidatorClass() {
            return OMClientVersionValidator.class;
        }
    };


    private VersionExtractor() {
    }

    public abstract Versioned extractVersion(OzoneManagerProtocolProtos.OMRequest var1, ValidationContext var2);

    public abstract Class<? extends Annotation> getValidatorClass();

    /* synthetic */ VersionExtractor(String string, int n, VersionExtractor versionExtractor) {
        this();
    }
}

