/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PendingKeysDeletion;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.om.snapshot.filter.ReclaimableKeyFilter;
import org.apache.hadoop.ozone.om.snapshot.filter.ReclaimableRenameEntryFilter;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.util.ProtobufUtils;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDeletingService
extends AbstractKeyDeletingService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDeletingService.class);
    private final ScmBlockLocationProtocol scmClient;
    private int keyLimitPerTask;
    private final AtomicLong deletedKeyCount;
    private final boolean deepCleanSnapshots;
    private final SnapshotChainManager snapshotChainManager;
    private int ratisByteLimit;
    private static final double RATIS_LIMIT_FACTOR = 0.9;
    private long latestRunTimestamp = 0L;
    private final DeletionStats aosDeletionStats = new DeletionStats();
    private final DeletionStats snapshotDeletionStats = new DeletionStats();

    public KeyDeletingService(OzoneManager ozoneManager, ScmBlockLocationProtocol scmClient, long serviceInterval, long serviceTimeout, ConfigurationSource conf, int keyDeletionCorePoolSize, boolean deepCleanSnapshots) {
        super(KeyDeletingService.class.getSimpleName(), serviceInterval, TimeUnit.MILLISECONDS, keyDeletionCorePoolSize, serviceTimeout, ozoneManager);
        this.keyLimitPerTask = conf.getInt("ozone.key.deleting.limit.per.task", 50000);
        Preconditions.checkArgument((this.keyLimitPerTask >= 0 ? 1 : 0) != 0, (Object)"ozone.key.deleting.limit.per.task cannot be negative.");
        this.deletedKeyCount = new AtomicLong(0L);
        this.deepCleanSnapshots = deepCleanSnapshots;
        this.snapshotChainManager = ((OmMetadataManagerImpl)ozoneManager.getMetadataManager()).getSnapshotChainManager();
        this.scmClient = scmClient;
        int limit = (int)ozoneManager.getConfiguration().getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        this.ratisByteLimit = (int)Math.max((double)limit * 0.9, 1.0);
    }

    @VisibleForTesting
    public AtomicLong getDeletedKeyCount() {
        return this.deletedKeyCount;
    }

    Pair<Pair<Integer, Long>, Boolean> processKeyDeletes(Map<String, PendingKeysDeletion.PurgedKey> keyBlocksList, Map<String, RepeatedOmKeyInfo> keysToModify, List<String> renameEntries, String snapTableKey, UUID expectedPreviousSnapshotId) throws IOException {
        long startTime = Time.monotonicNow();
        Pair<Pair<Integer, Long>, Boolean> purgeResult = Pair.of((Object)Pair.of((Object)0, (Object)0L), (Object)false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send {} key(s) to SCM: {}", (Object)keyBlocksList.size(), keyBlocksList);
        } else if (LOG.isInfoEnabled()) {
            int logSize = 10;
            if (keyBlocksList.size() < logSize) {
                logSize = keyBlocksList.size();
            }
            LOG.info("Send {} key(s) to SCM, first {} keys: {}", new Object[]{keyBlocksList.size(), logSize, keyBlocksList.entrySet().stream().limit(logSize).map(Map.Entry::getValue).collect(Collectors.toSet())});
        }
        List blockDeletionResults = this.scmClient.deleteKeyBlocks(keyBlocksList.values().stream().map(PendingKeysDeletion.PurgedKey::getBlockGroup).collect(Collectors.toList()));
        LOG.info("{} BlockGroup deletion are acked by SCM in {} ms", (Object)keyBlocksList.size(), (Object)(Time.monotonicNow() - startTime));
        if (blockDeletionResults != null) {
            long purgeStartTime = Time.monotonicNow();
            purgeResult = this.submitPurgeKeysRequest(blockDeletionResults, keyBlocksList, keysToModify, renameEntries, snapTableKey, expectedPreviousSnapshotId, this.ratisByteLimit);
            int limit = this.getOzoneManager().getConfiguration().getInt("ozone.key.deleting.limit.per.task", 50000);
            LOG.info("Blocks for {} (out of {}) keys are deleted from DB in {} ms. Limit per task is {}.", new Object[]{((Pair)purgeResult.getKey()).getKey(), blockDeletionResults.size(), Time.monotonicNow() - purgeStartTime, limit});
        }
        this.getPerfMetrics().setKeyDeletingServiceLatencyMs(Time.monotonicNow() - startTime);
        return purgeResult;
    }

    private int increaseBucketPurgeSize(Map<Long, BucketPurgeSize> bucketPurgeSizeMap, PendingKeysDeletion.PurgedKey purgedKey) {
        BucketPurgeSize bucketPurgeSize;
        int estimatedSize = 0;
        if (!bucketPurgeSizeMap.containsKey(purgedKey.getBucketId())) {
            bucketPurgeSize = bucketPurgeSizeMap.computeIfAbsent(purgedKey.getBucketId(), bucketId -> new BucketPurgeSize(purgedKey.getVolume(), purgedKey.getBucket(), purgedKey.getBucketId()));
            estimatedSize = bucketPurgeSize.getEstimatedSize();
        } else {
            bucketPurgeSize = bucketPurgeSizeMap.get(purgedKey.getBucketId());
        }
        bucketPurgeSize.incrementPurgedBytes(purgedKey.getPurgedBytes()).incrementPurgedNamespace(1L);
        return estimatedSize;
    }

    /*
     * WARNING - void declaration
     */
    private Pair<Pair<Integer, Long>, Boolean> submitPurgeKeysRequest(List<DeleteBlockGroupResult> results, Map<String, PendingKeysDeletion.PurgedKey> purgedKeys, Map<String, RepeatedOmKeyInfo> keysToModify, List<String> renameEntriesToBeDeleted, String snapTableKey, UUID expectedPreviousSnapshotId, int ratisLimit) {
        void var16_19;
        int currSize;
        Set<Object> completePurgedKeys = new HashSet();
        int deletedCount = 0;
        long deletedReplSize = 0L;
        HashSet<String> failedDeletedKeys = new HashSet<String>();
        boolean purgeSuccess = true;
        for (DeleteBlockGroupResult result : results) {
            String string = result.getObjectKey();
            PendingKeysDeletion.PurgedKey purgedKey2 = purgedKeys.get(string);
            if (purgedKey2 != null) {
                String deletedKeyName = purgedKey2.getDeleteKeyName();
                if (result.isSuccess()) {
                    if (keysToModify == null || !keysToModify.containsKey(deletedKeyName)) {
                        completePurgedKeys.add(deletedKeyName);
                        LOG.debug("Key {} set to be purged from OM DB", (Object)deletedKeyName);
                    } else {
                        LOG.debug("Key {} set to be updated in OM DB, Other versions of the key that are reclaimable are reclaimed.", (Object)deletedKeyName);
                    }
                    deletedReplSize += purgedKey2.getPurgedBytes();
                    ++deletedCount;
                    continue;
                }
                failedDeletedKeys.add(deletedKeyName);
                purgeSuccess = false;
                if (LOG.isDebugEnabled()) {
                    LOG.error("Failed Block Delete corresponding to Key {} with block result : {}.", (Object)deletedKeyName, (Object)result.getBlockResultList());
                    continue;
                }
                LOG.error("Failed Block Delete corresponding to Key {}.", (Object)deletedKeyName);
                continue;
            }
            LOG.error("Key {} not found in the list of keys to be purged. Skipping purge for this entry. Result of delete blocks : {}", (Object)string, (Object)result.isSuccess());
        }
        completePurgedKeys = completePurgedKeys.stream().filter(i -> !failedDeletedKeys.contains(i)).collect(Collectors.toSet());
        List purgedKeyList = purgedKeys.values().stream().filter(purgedKey -> !failedDeletedKeys.contains(purgedKey.getDeleteKeyName())).collect(Collectors.toList());
        ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> keysToUpdateList = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>();
        if (keysToModify != null) {
            for (Map.Entry entry : keysToModify.entrySet()) {
                if (failedDeletedKeys.contains(entry.getKey())) continue;
                OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.Builder keyToUpdate = OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.newBuilder();
                keyToUpdate.setKey((String)entry.getKey());
                List keyInfos = ((RepeatedOmKeyInfo)entry.getValue()).getOmKeyInfoList().stream().map(k -> k.getProtobuf(ClientVersion.CURRENT_VERSION)).collect(Collectors.toList());
                keyToUpdate.addAllKeyInfos(keyInfos);
                keyToUpdate.setBucketId(((RepeatedOmKeyInfo)entry.getValue()).getBucketId());
                keysToUpdateList.add(keyToUpdate.build());
            }
        }
        if (purgedKeyList.isEmpty() && keysToUpdateList.isEmpty() && (renameEntriesToBeDeleted == null || renameEntriesToBeDeleted.isEmpty())) {
            return Pair.of((Object)Pair.of((Object)deletedCount, (Object)deletedReplSize), (Object)purgeSuccess);
        }
        boolean bl = false;
        int updateIndex = 0;
        int renameIndex = 0;
        OzoneManagerProtocolProtos.PurgeKeysRequest.Builder requestBuilder = KeyDeletingService.getPurgeKeysRequest(snapTableKey, expectedPreviousSnapshotId);
        int baseSize = currSize = requestBuilder.build().getSerializedSize();
        OzoneManagerProtocolProtos.DeletedKeys.Builder bucketDeleteKeys = null;
        HashMap<Long, BucketPurgeSize> bucketPurgeKeysSizeMap = new HashMap<Long, BucketPurgeSize>();
        HashMap<String, List> modifiedKeyPurgedKeys = new HashMap<String, List>();
        while (var16_19 < purgedKeyList.size() || updateIndex < keysToUpdateList.size() || renameEntriesToBeDeleted != null && renameIndex < renameEntriesToBeDeleted.size()) {
            boolean allDone;
            if (var16_19 < purgedKeyList.size()) {
                String deletedKey;
                PendingKeysDeletion.PurgedKey purgedKey3 = (PendingKeysDeletion.PurgedKey)purgedKeyList.get((int)var16_19);
                if (bucketDeleteKeys == null) {
                    bucketDeleteKeys = OzoneManagerProtocolProtos.DeletedKeys.newBuilder().setVolumeName("").setBucketName("");
                    currSize += bucketDeleteKeys.buildPartial().getSerializedSize();
                }
                if (completePurgedKeys.contains(deletedKey = purgedKey3.getDeleteKeyName())) {
                    bucketDeleteKeys.addKeys(deletedKey);
                    int estimatedKeySize = ProtobufUtils.computeRepeatedStringSize((String)deletedKey);
                    currSize += estimatedKeySize;
                    if (purgedKey3.isCommittedKey()) {
                        currSize += this.increaseBucketPurgeSize(bucketPurgeKeysSizeMap, purgedKey3);
                    }
                } else if (purgedKey3.isCommittedKey()) {
                    modifiedKeyPurgedKeys.computeIfAbsent(deletedKey, k -> new ArrayList()).add(purgedKey3);
                }
                ++var16_19;
            } else if (updateIndex < keysToUpdateList.size()) {
                OzoneManagerProtocolProtos.SnapshotMoveKeyInfos nextUpdate = (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos)keysToUpdateList.get(updateIndex);
                int estimatedSize = nextUpdate.getSerializedSize();
                requestBuilder.addKeysToUpdate(nextUpdate);
                if (modifiedKeyPurgedKeys.containsKey(nextUpdate.getKey())) {
                    for (PendingKeysDeletion.PurgedKey purgedKey4 : (List)modifiedKeyPurgedKeys.get(nextUpdate.getKey())) {
                        if (!purgedKey4.isCommittedKey()) continue;
                        currSize += this.increaseBucketPurgeSize(bucketPurgeKeysSizeMap, purgedKey4);
                    }
                }
                currSize += estimatedSize;
                ++updateIndex;
            } else if (renameEntriesToBeDeleted != null && renameIndex < renameEntriesToBeDeleted.size()) {
                String nextRename = renameEntriesToBeDeleted.get(renameIndex);
                int estimatedSize = ProtobufUtils.computeRepeatedStringSize((String)nextRename);
                requestBuilder.addRenamedKeys(nextRename);
                currSize += estimatedSize;
                ++renameIndex;
            }
            boolean bl2 = allDone = var16_19 == purgedKeyList.size() && updateIndex == keysToUpdateList.size() && (renameEntriesToBeDeleted == null || renameIndex == renameEntriesToBeDeleted.size());
            if (currSize < ratisLimit && (!allDone || !this.hasPendingItems(requestBuilder) && bucketDeleteKeys == null)) continue;
            if (bucketDeleteKeys != null) {
                requestBuilder.addDeletedKeys(bucketDeleteKeys.build());
                bucketDeleteKeys = null;
            }
            bucketPurgeKeysSizeMap.values().stream().map(BucketPurgeSize::access$4).forEach(arg_0 -> ((OzoneManagerProtocolProtos.PurgeKeysRequest.Builder)requestBuilder).addBucketPurgeKeysSize(arg_0));
            bucketPurgeKeysSizeMap.clear();
            purgeSuccess = this.submitPurgeRequest(snapTableKey, purgeSuccess, requestBuilder);
            requestBuilder = KeyDeletingService.getPurgeKeysRequest(snapTableKey, expectedPreviousSnapshotId);
            currSize = baseSize;
        }
        return Pair.of((Object)Pair.of((Object)deletedCount, (Object)deletedReplSize), (Object)purgeSuccess);
    }

    private boolean hasPendingItems(OzoneManagerProtocolProtos.PurgeKeysRequest.Builder builder) {
        return builder.getDeletedKeysCount() > 0 || builder.getKeysToUpdateCount() > 0 || builder.getRenamedKeysCount() > 0;
    }

    private static OzoneManagerProtocolProtos.PurgeKeysRequest.Builder getPurgeKeysRequest(String snapTableKey, UUID expectedPreviousSnapshotId) {
        OzoneManagerProtocolProtos.PurgeKeysRequest.Builder requestBuilder = OzoneManagerProtocolProtos.PurgeKeysRequest.newBuilder();
        if (snapTableKey != null) {
            requestBuilder.setSnapshotTableKey(snapTableKey);
        }
        OzoneManagerProtocolProtos.NullableUUID.Builder expectedPreviousSnapshotNullableUUID = OzoneManagerProtocolProtos.NullableUUID.newBuilder();
        if (expectedPreviousSnapshotId != null) {
            expectedPreviousSnapshotNullableUUID.setUuid(HddsUtils.toProtobuf((UUID)expectedPreviousSnapshotId));
        }
        requestBuilder.setExpectedPreviousSnapshotID(expectedPreviousSnapshotNullableUUID.build());
        return requestBuilder;
    }

    private boolean submitPurgeRequest(String snapTableKey, boolean purgeSuccess, OzoneManagerProtocolProtos.PurgeKeysRequest.Builder requestBuilder) {
        OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgeKeys).setPurgeKeysRequest(requestBuilder.build()).setClientId(this.getClientId().toString()).build();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BootstrapStateHandler.Lock lock = snapTableKey != null ? this.getBootstrapStateLock().lock() : null;){
                OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
                if (omResponse != null) {
                    purgeSuccess = purgeSuccess && omResponse.getSuccess();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ServiceException | InterruptedException e) {
            LOG.error("PurgeKey request failed in batch. Will retry at next run.", e);
            purgeSuccess = false;
        }
        return purgeSuccess;
    }

    protected void execTaskCompletion() {
        this.getMetrics().updateIntervalCumulativeMetrics(this.aosDeletionStats.reclaimedKeyCount.get() + this.snapshotDeletionStats.reclaimedKeyCount.get(), this.aosDeletionStats.reclaimedKeySize.get() + this.snapshotDeletionStats.reclaimedKeySize.get());
        this.getMetrics().updateAosLastRunMetrics(this.aosDeletionStats.reclaimedKeyCount.get(), this.aosDeletionStats.reclaimedKeySize.get(), this.aosDeletionStats.iteratedKeyCount.get(), this.aosDeletionStats.notReclaimableKeyCount.get());
        this.getMetrics().updateSnapLastRunMetrics(this.snapshotDeletionStats.reclaimedKeyCount.get(), this.snapshotDeletionStats.reclaimedKeySize.get(), this.snapshotDeletionStats.iteratedKeyCount.get(), this.snapshotDeletionStats.notReclaimableKeyCount.get());
        this.getMetrics().setKdsLastRunTimestamp(this.latestRunTimestamp);
    }

    private void resetMetrics() {
        this.aosDeletionStats.reset();
        this.snapshotDeletionStats.reset();
        this.latestRunTimestamp = System.currentTimeMillis();
        this.getMetrics().setKdsCurRunTimestamp(this.latestRunTimestamp);
    }

    /*
     * Unable to fully structure code
     */
    public BackgroundTaskQueue getTasks() {
        block3: {
            this.resetMetrics();
            queue = new BackgroundTaskQueue();
            queue.add((BackgroundTask)new KeyDeletingTask(null));
            if (!this.deepCleanSnapshots) break block3;
            iterator = null;
            try {
                iterator = this.snapshotChainManager.iterator(true);
                if (true) ** GOTO lbl15
            }
            catch (IOException v0) {
                KeyDeletingService.LOG.error("Error while initializing snapshot chain iterator. DirDeletingTask will only process AOS this run.");
                return queue;
            }
            do {
                snapshotId = iterator.next();
                queue.add((BackgroundTask)new KeyDeletingTask(snapshotId));
lbl15:
                // 2 sources

            } while (iterator.hasNext());
        }
        return queue;
    }

    public int getKeyLimitPerTask() {
        return this.keyLimitPerTask;
    }

    public void setKeyLimitPerTask(int keyLimitPerTask) {
        this.keyLimitPerTask = keyLimitPerTask;
    }

    private static final class BucketPurgeSize {
        private OzoneManagerProtocolProtos.BucketNameInfo bucket;
        private long purgedBytes;
        private long purgedNamespace;

        private BucketPurgeSize(String volume, String bucket, long bucketId) {
            this.bucket = OzoneManagerProtocolProtos.BucketNameInfo.newBuilder().setBucketId(bucketId).setVolumeName(volume).setBucketName(bucket).build();
            this.purgedBytes = 0L;
            this.purgedNamespace = 0L;
        }

        private BucketPurgeSize incrementPurgedBytes(long bytes) {
            this.purgedBytes += bytes;
            return this;
        }

        private BucketPurgeSize incrementPurgedNamespace(long namespace) {
            this.purgedNamespace += namespace;
            return this;
        }

        private OzoneManagerProtocolProtos.BucketPurgeKeysSize toProtobuf() {
            return OzoneManagerProtocolProtos.BucketPurgeKeysSize.newBuilder().setBucketNameInfo(this.bucket).setPurgedBytes(this.purgedBytes).setPurgedNamespace(this.purgedNamespace).build();
        }

        private int getEstimatedSize() {
            return this.bucket.getSerializedSize() + ProtobufUtils.computeLongSizeWithTag((int)2, (long)-10L) + ProtobufUtils.computeLongSizeWithTag((int)3, (long)-10L);
        }

        static /* synthetic */ OzoneManagerProtocolProtos.BucketPurgeKeysSize access$4(BucketPurgeSize bucketPurgeSize) {
            return bucketPurgeSize.toProtobuf();
        }
    }

    private static class DeletionStats {
        private final AtomicLong reclaimedKeyCount = new AtomicLong(0L);
        private final AtomicLong reclaimedKeySize = new AtomicLong(0L);
        private final AtomicLong iteratedKeyCount = new AtomicLong(0L);
        private final AtomicLong notReclaimableKeyCount = new AtomicLong(0L);

        private DeletionStats() {
        }

        private void updateDeletionStats(long reclaimedKeys, long reclaimedSize, long iteratedKeys, long notReclaimableKeys) {
            this.reclaimedKeyCount.addAndGet(reclaimedKeys);
            this.reclaimedKeySize.addAndGet(reclaimedSize);
            this.iteratedKeyCount.addAndGet(iteratedKeys);
            this.notReclaimableKeyCount.addAndGet(notReclaimableKeys);
        }

        private void reset() {
            this.reclaimedKeyCount.set(0L);
            this.reclaimedKeySize.set(0L);
            this.iteratedKeyCount.set(0L);
            this.notReclaimableKeyCount.set(0L);
        }
    }

    @VisibleForTesting
    final class KeyDeletingTask
    implements BackgroundTask {
        private final UUID snapshotId;

        KeyDeletingTask(UUID snapshotId) {
            this.snapshotId = snapshotId;
        }

        private OzoneManagerProtocolProtos.SetSnapshotPropertyRequest getSetSnapshotRequestUpdatingExclusiveSize(Map<UUID, Long> exclusiveSizeMap, Map<UUID, Long> exclusiveReplicatedSizeMap, UUID snapshotID) {
            OzoneManagerProtocolProtos.SnapshotSize snapshotSize = OzoneManagerProtocolProtos.SnapshotSize.newBuilder().setExclusiveSize(exclusiveSizeMap.getOrDefault(snapshotID, 0L).longValue()).setExclusiveReplicatedSize(exclusiveReplicatedSizeMap.getOrDefault(snapshotID, 0L).longValue()).build();
            return OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotKey(KeyDeletingService.this.snapshotChainManager.getTableKey(snapshotID)).setSnapshotSize(snapshotSize).build();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processDeletedKeysForStore(SnapshotInfo currentSnapshotInfo, KeyManager keyManager, int remainNum) throws IOException, InterruptedException {
            String volume = null;
            String bucket = null;
            String snapshotTableKey = null;
            if (currentSnapshotInfo != null) {
                volume = currentSnapshotInfo.getVolumeName();
                bucket = currentSnapshotInfo.getBucketName();
                snapshotTableKey = currentSnapshotInfo.getTableKey();
            }
            boolean successStatus = true;
            try {
                OmSnapshotManager omSnapshotManager = KeyDeletingService.this.getOzoneManager().getOmSnapshotManager();
                UUID expectedPreviousSnapshotId = currentSnapshotInfo == null ? KeyDeletingService.this.snapshotChainManager.getLatestGlobalSnapshotId() : SnapshotUtils.getPreviousSnapshotId(currentSnapshotInfo, KeyDeletingService.this.snapshotChainManager);
                IOzoneManagerLock lock = KeyDeletingService.this.getOzoneManager().getMetadataManager().getLock();
                Throwable throwable = null;
                Object var12_14 = null;
                try {
                    ReclaimableKeyFilter reclaimableKeyFilter = new ReclaimableKeyFilter(KeyDeletingService.this.getOzoneManager(), omSnapshotManager, KeyDeletingService.this.snapshotChainManager, currentSnapshotInfo, keyManager, lock);
                    try {
                        try (ReclaimableRenameEntryFilter renameEntryFilter = new ReclaimableRenameEntryFilter(KeyDeletingService.this.getOzoneManager(), omSnapshotManager, KeyDeletingService.this.snapshotChainManager, currentSnapshotInfo, keyManager, lock);){
                            List<String> renamedTableEntries = keyManager.getRenamesKeyEntries(volume, bucket, null, renameEntryFilter, remainNum).stream().map(Table.KeyValue::getKey).collect(Collectors.toList());
                            PendingKeysDeletion pendingKeysDeletion = currentSnapshotInfo == null ? keyManager.getPendingDeletionKeys(reclaimableKeyFilter, remainNum) : keyManager.getPendingDeletionKeys(volume, bucket, null, reclaimableKeyFilter, remainNum -= renamedTableEntries.size());
                            Map<String, PendingKeysDeletion.PurgedKey> purgedKeys = pendingKeysDeletion.getPurgedKeys();
                            if (!renamedTableEntries.isEmpty() || purgedKeys != null && !purgedKeys.isEmpty()) {
                                SnapshotUtils.validatePreviousSnapshotId(currentSnapshotInfo, KeyDeletingService.this.snapshotChainManager, expectedPreviousSnapshotId);
                                Pair<Pair<Integer, Long>, Boolean> purgeResult = KeyDeletingService.this.processKeyDeletes(purgedKeys, pendingKeysDeletion.getKeysToModify(), renamedTableEntries, snapshotTableKey, expectedPreviousSnapshotId);
                                remainNum -= ((Integer)((Pair)purgeResult.getKey()).getKey()).intValue();
                                successStatus = (Boolean)purgeResult.getValue();
                                KeyDeletingService.this.getMetrics().incrNumKeysProcessed(purgedKeys.size());
                                KeyDeletingService.this.getMetrics().incrNumKeysSentForPurge(((Integer)((Pair)purgeResult.getKey()).getKey()).intValue());
                                DeletionStats statsToUpdate = currentSnapshotInfo == null ? KeyDeletingService.this.aosDeletionStats : KeyDeletingService.this.snapshotDeletionStats;
                                statsToUpdate.updateDeletionStats(((Integer)((Pair)purgeResult.getKey()).getKey()).intValue(), (Long)((Pair)purgeResult.getKey()).getValue(), purgedKeys.size() + pendingKeysDeletion.getNotReclaimableKeyCount(), pendingKeysDeletion.getNotReclaimableKeyCount());
                                if (successStatus) {
                                    KeyDeletingService.this.deletedKeyCount.addAndGet(((Integer)((Pair)purgeResult.getKey()).getKey()).intValue());
                                }
                            }
                            if (remainNum > 0 && successStatus) {
                                ArrayList<OzoneManagerProtocolProtos.SetSnapshotPropertyRequest> setSnapshotPropertyRequests = new ArrayList<OzoneManagerProtocolProtos.SetSnapshotPropertyRequest>();
                                Map<UUID, Long> exclusiveReplicatedSizeMap = reclaimableKeyFilter.getExclusiveReplicatedSizeMap();
                                Map<UUID, Long> exclusiveSizeMap = reclaimableKeyFilter.getExclusiveSizeMap();
                                List previousPathSnapshotsInChain = Stream.of(exclusiveSizeMap.keySet(), exclusiveReplicatedSizeMap.keySet()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                                for (UUID snapshot : previousPathSnapshotsInChain) {
                                    setSnapshotPropertyRequests.add(this.getSetSnapshotRequestUpdatingExclusiveSize(exclusiveSizeMap, exclusiveReplicatedSizeMap, snapshot));
                                }
                                if (currentSnapshotInfo != null) {
                                    setSnapshotPropertyRequests.add(OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotKey(snapshotTableKey).setDeepCleanedDeletedKey(true).build());
                                }
                                KeyDeletingService.this.submitSetSnapshotRequests(setSnapshotPropertyRequests);
                            }
                        }
                        if (reclaimableKeyFilter == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (reclaimableKeyFilter == null) throw throwable;
                        reclaimableKeyFilter.close();
                        throw throwable;
                    }
                    reclaimableKeyFilter.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() {
            if (KeyDeletingService.this.shouldRun()) {
                long run = KeyDeletingService.this.getRunCount().incrementAndGet();
                if (this.snapshotId == null) {
                    LOG.debug("Running KeyDeletingService for active object store, {}", (Object)run);
                } else {
                    LOG.debug("Running KeyDeletingService for snapshot : {}, {}", (Object)this.snapshotId, (Object)run);
                }
                int remainNum = KeyDeletingService.this.keyLimitPerTask;
                OmSnapshotManager omSnapshotManager = KeyDeletingService.this.getOzoneManager().getOmSnapshotManager();
                SnapshotInfo snapInfo = null;
                try {
                    SnapshotInfo snapshotInfo = snapInfo = this.snapshotId == null ? null : SnapshotUtils.getSnapshotInfo(KeyDeletingService.this.getOzoneManager(), KeyDeletingService.this.snapshotChainManager, this.snapshotId);
                    if (snapInfo != null) {
                        if (snapInfo.isDeepCleaned()) {
                            LOG.info("Snapshot '{}' ({}) has already been deep cleaned. Skipping the snapshot in this iteration.", (Object)snapInfo.getTableKey(), (Object)snapInfo.getSnapshotId());
                            return BackgroundTaskResult.EmptyTaskResult.newResult();
                        }
                        if (!OmSnapshotManager.areSnapshotChangesFlushedToDB(KeyDeletingService.this.getOzoneManager().getMetadataManager(), snapInfo)) {
                            LOG.info("Skipping snapshot processing since changes to snapshot {} have not been flushed to disk", (Object)snapInfo);
                            return BackgroundTaskResult.EmptyTaskResult.newResult();
                        }
                        if (!snapInfo.isDeepCleanedDeletedDir()) {
                            LOG.debug("Snapshot {} hasn't done deleted directory deep cleaning yet. Skipping the snapshot in this iteration.", (Object)snapInfo);
                            return BackgroundTaskResult.EmptyTaskResult.newResult();
                        }
                    } else if (!KeyDeletingService.this.isPreviousPurgeTransactionFlushed()) {
                        return BackgroundTaskResult.EmptyTaskResult.newResult();
                    }
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (UncheckedAutoCloseableSupplier<OmSnapshot> omSnapshot = snapInfo == null ? null : omSnapshotManager.getActiveSnapshot(snapInfo.getVolumeName(), snapInfo.getBucketName(), snapInfo.getName());){
                        KeyManager keyManager = snapInfo == null ? KeyDeletingService.this.getOzoneManager().getKeyManager() : ((OmSnapshot)omSnapshot.get()).getKeyManager();
                        this.processDeletedKeysForStore(snapInfo, keyManager, remainNum);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOG.error("Error while running delete files background task for store {}. Will retry at next run.", snapInfo, (Object)e);
                }
                catch (InterruptedException e) {
                    LOG.error("Interruption while running delete files background task for store {}.", snapInfo, (Object)e);
                    Thread.currentThread().interrupt();
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

