/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DatePart;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractFunction;
import org.jooq.impl.DSL;
import org.jooq.impl.DateAdd;
import org.jooq.impl.ExpressionOperator;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.types.DayToSecond;
import org.jooq.types.Interval;
import org.jooq.types.YearToMonth;

final class Expression<T>
extends AbstractFunction<T> {
    private static final long serialVersionUID = -5522799070693019771L;
    private static final EnumSet<SQLDialect> SUPPORT_BIT_AND = EnumSet.of(SQLDialect.H2, SQLDialect.HSQLDB);
    private static final EnumSet<SQLDialect> SUPPORT_BIT_OR_XOR = EnumSet.of(SQLDialect.H2, SQLDialect.HSQLDB);
    private static final EnumSet<SQLDialect> EMULATE_BIT_XOR = EnumSet.of(SQLDialect.SQLITE);
    private static final EnumSet<SQLDialect> EMULATE_SHR_SHL = EnumSet.of(SQLDialect.H2, SQLDialect.HSQLDB);
    private static final EnumSet<SQLDialect> HASH_OP_FOR_BIT_XOR = EnumSet.of(SQLDialect.POSTGRES);
    private final Field<T> lhs;
    private final QueryPartList<Field<?>> rhs;
    private final ExpressionOperator operator;
    private static final Pattern TRUNC_TO_MICROS = Pattern.compile("([^.]*\\.\\d{0,6})\\d{0,3}");

    Expression(ExpressionOperator operator, Field<T> lhs, Field<?> ... rhs) {
        super(operator.toSQL(), lhs.getDataType(), Tools.combine(lhs, rhs));
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = new QueryPartList((QueryPart[])rhs);
    }

    @Override
    public final Field<T> add(Field<?> value) {
        if (this.operator == ExpressionOperator.ADD) {
            this.rhs.add(value);
            return this;
        }
        return super.add(value);
    }

    @Override
    public final Field<T> mul(Field<? extends Number> value) {
        if (this.operator == ExpressionOperator.MULTIPLY) {
            this.rhs.add(value);
            return this;
        }
        return super.mul(value);
    }

    @Override
    final Field<T> getFunction0(Configuration configuration) {
        SQLDialect family = configuration.dialect().family();
        if (ExpressionOperator.BIT_AND == this.operator && SUPPORT_BIT_AND.contains((Object)family)) {
            return DSL.function("bitand", this.getDataType(), this.getArguments());
        }
        if (ExpressionOperator.BIT_AND == this.operator && SQLDialect.FIREBIRD == family) {
            return DSL.function("bin_and", this.getDataType(), this.getArguments());
        }
        if (ExpressionOperator.BIT_XOR == this.operator && SUPPORT_BIT_OR_XOR.contains((Object)family)) {
            return DSL.function("bitxor", this.getDataType(), this.getArguments());
        }
        if (ExpressionOperator.BIT_XOR == this.operator && SQLDialect.FIREBIRD == family) {
            return DSL.function("bin_xor", this.getDataType(), this.getArguments());
        }
        if (ExpressionOperator.BIT_OR == this.operator && SUPPORT_BIT_OR_XOR.contains((Object)family)) {
            return DSL.function("bitor", this.getDataType(), this.getArguments());
        }
        if (ExpressionOperator.BIT_OR == this.operator && SQLDialect.FIREBIRD == family) {
            return DSL.function("bin_or", this.getDataType(), this.getArguments());
        }
        if (ExpressionOperator.BIT_XOR == this.operator && EMULATE_BIT_XOR.contains((Object)family)) {
            return DSL.bitAnd(DSL.bitNot(DSL.bitAnd(this.lhsAsNumber(), this.rhsAsNumber())), DSL.bitOr(this.lhsAsNumber(), this.rhsAsNumber()));
        }
        if (ExpressionOperator.SHL == this.operator && EMULATE_SHR_SHL.contains((Object)family)) {
            return this.lhs.mul(DSL.power(DSL.two(), this.rhsAsNumber()).cast(this.lhs));
        }
        if (ExpressionOperator.SHR == this.operator && EMULATE_SHR_SHL.contains((Object)family)) {
            return this.lhs.div(DSL.power(DSL.two(), this.rhsAsNumber()).cast(this.lhs));
        }
        if (ExpressionOperator.SHL == this.operator && SQLDialect.FIREBIRD == family) {
            return DSL.function("bin_shl", this.getDataType(), this.getArguments());
        }
        if (ExpressionOperator.SHR == this.operator && SQLDialect.FIREBIRD == family) {
            return DSL.function("bin_shr", this.getDataType(), this.getArguments());
        }
        if (ExpressionOperator.BIT_NAND == this.operator) {
            return DSL.bitNot(DSL.bitAnd(this.lhsAsNumber(), this.rhsAsNumber()));
        }
        if (ExpressionOperator.BIT_NOR == this.operator) {
            return DSL.bitNot(DSL.bitOr(this.lhsAsNumber(), this.rhsAsNumber()));
        }
        if (ExpressionOperator.BIT_XNOR == this.operator) {
            return DSL.bitNot(DSL.bitXor(this.lhsAsNumber(), this.rhsAsNumber()));
        }
        if ((ExpressionOperator.ADD == this.operator || ExpressionOperator.SUBTRACT == this.operator) && this.lhs.getDataType().isDateTime() && (((Field)this.rhs.get(0)).getDataType().isNumeric() || ((Field)this.rhs.get(0)).getDataType().isInterval())) {
            return new DateExpression();
        }
        return new DefaultExpression();
    }

    private final Field<Number> lhsAsNumber() {
        return this.lhs;
    }

    private final Field<Number> rhsAsNumber() {
        return (Field)this.rhs.get(0);
    }

    private final YearToMonth rhsAsYTM() {
        try {
            return (YearToMonth)((Param)this.rhs.get(0)).getValue();
        }
        catch (ClassCastException e) {
            throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs.get(0));
        }
    }

    private final DayToSecond rhsAsDTS() {
        try {
            return (DayToSecond)((Param)this.rhs.get(0)).getValue();
        }
        catch (ClassCastException e) {
            throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs.get(0));
        }
    }

    private final Interval rhsAsInterval() {
        try {
            return (Interval)((Param)this.rhs.get(0)).getValue();
        }
        catch (ClassCastException e) {
            throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs.get(0));
        }
    }

    private class DefaultExpression
    extends AbstractField<T> {
        private static final long serialVersionUID = -5105004317793995419L;

        private DefaultExpression() {
            super(Expression.this.operator.toName(), Expression.this.lhs.getDataType());
        }

        @Override
        public final void accept(Context<?> ctx) {
            String op = Expression.this.operator.toSQL();
            if (Expression.this.operator == ExpressionOperator.BIT_XOR && HASH_OP_FOR_BIT_XOR.contains((Object)ctx.family())) {
                op = "#";
            }
            ctx.sql('(');
            ctx.visit(Expression.this.lhs);
            for (Field field : Expression.this.rhs) {
                ctx.sql(' ').sql(op).sql(' ').visit(field);
            }
            ctx.sql(')');
        }
    }

    private class DateExpression
    extends AbstractFunction<T> {
        private static final long serialVersionUID = 3160679741902222262L;

        DateExpression() {
            super(Expression.this.operator.toSQL(), Expression.this.lhs.getDataType(), new Field[0]);
        }

        @Override
        final Field<T> getFunction0(Configuration configuration) {
            if (((Field)Expression.this.rhs.get(0)).getDataType().isInterval()) {
                return this.getIntervalExpression(configuration);
            }
            return this.getNumberExpression(configuration);
        }

        private final Field<T> getIntervalExpression(Configuration configuration) {
            SQLDialect dialect = configuration.dialect();
            int sign = Expression.this.operator == ExpressionOperator.ADD ? 1 : -1;
            switch (dialect.family()) {
                case CUBRID: 
                case MARIADB: 
                case MYSQL: {
                    Interval interval = Expression.this.rhsAsInterval();
                    if (Expression.this.operator == ExpressionOperator.SUBTRACT) {
                        interval = interval.neg();
                    }
                    if (((Field)Expression.this.rhs.get(0)).getType() == YearToMonth.class) {
                        return DSL.field("{date_add}({0}, {interval} {1} {year_month})", this.getDataType(), Expression.this.lhs, Tools.field((Object)interval, SQLDataType.VARCHAR));
                    }
                    if (dialect == SQLDialect.CUBRID) {
                        return DSL.field("{date_add}({0}, {interval} {1} {day_millisecond})", this.getDataType(), Expression.this.lhs, Tools.field((Object)interval, SQLDataType.VARCHAR));
                    }
                    return DSL.field("{date_add}({0}, {interval} {1} {day_microsecond})", this.getDataType(), Expression.this.lhs, Tools.field((Object)TRUNC_TO_MICROS.matcher("" + interval).replaceAll("$1"), SQLDataType.VARCHAR));
                }
                case DERBY: 
                case HSQLDB: {
                    Field result = ((Field)Expression.this.rhs.get(0)).getType() == YearToMonth.class ? DSL.field("{fn {timestampadd}({sql_tsi_month}, {0}, {1}) }", this.getDataType(), DSL.val(sign * Expression.this.rhsAsYTM().intValue()), Expression.this.lhs) : DSL.field("{fn {timestampadd}({sql_tsi_second}, {0}, {fn {timestampadd}({sql_tsi_milli_second}, {1}, {2}) }) }", this.getDataType(), DSL.val((long)sign * (long)Expression.this.rhsAsDTS().getTotalSeconds()), DSL.val((long)sign * (long)Expression.this.rhsAsDTS().getMilli()), Expression.this.lhs);
                    return this.castNonTimestamps(configuration, result);
                }
                case FIREBIRD: {
                    if (((Field)Expression.this.rhs.get(0)).getType() == YearToMonth.class) {
                        return DSL.field("{dateadd}({month}, {0}, {1})", this.getDataType(), DSL.val(sign * Expression.this.rhsAsYTM().intValue()), Expression.this.lhs);
                    }
                    return DSL.field("{dateadd}({millisecond}, {0}, {1})", this.getDataType(), DSL.val((long)sign * (long)Expression.this.rhsAsDTS().getTotalMilli()), Expression.this.lhs);
                }
                case H2: {
                    if (((Field)Expression.this.rhs.get(0)).getType() == YearToMonth.class) {
                        return DSL.field("{dateadd}('month', {0}, {1})", this.getDataType(), DSL.val(sign * Expression.this.rhsAsYTM().intValue()), Expression.this.lhs);
                    }
                    return DSL.field("{dateadd}('ms', {0}, {1})", this.getDataType(), DSL.val((long)sign * (long)Expression.this.rhsAsDTS().getTotalMilli()), Expression.this.lhs);
                }
                case SQLITE: {
                    boolean ytm = ((Field)Expression.this.rhs.get(0)).getType() == YearToMonth.class;
                    Field<Object> interval = DSL.val(ytm ? (double)Expression.this.rhsAsYTM().intValue() : Expression.this.rhsAsDTS().getTotalSeconds());
                    if (sign < 0) {
                        interval = interval.neg();
                    }
                    interval = interval.concat(DSL.inline(ytm ? " months" : " seconds"));
                    return DSL.field("{datetime}({0}, {1})", this.getDataType(), Expression.this.lhs, interval);
                }
            }
            return new DefaultExpression();
        }

        private final Field<T> castNonTimestamps(Configuration configuration, Field<T> result) {
            if (this.getDataType().getType() != Timestamp.class) {
                return DSL.field("{cast}({0} {as} " + this.getDataType().getCastTypeName(configuration) + ")", this.getDataType(), result);
            }
            return result;
        }

        private final Field<T> getNumberExpression(Configuration configuration) {
            switch (configuration.family()) {
                case FIREBIRD: {
                    if (Expression.this.operator == ExpressionOperator.ADD) {
                        return DSL.field("{dateadd}(day, {0}, {1})", this.getDataType(), Expression.this.rhsAsNumber(), Expression.this.lhs);
                    }
                    return DSL.field("{dateadd}(day, {0}, {1})", this.getDataType(), Expression.this.rhsAsNumber().neg(), Expression.this.lhs);
                }
                case HSQLDB: {
                    if (Expression.this.operator == ExpressionOperator.ADD) {
                        return Expression.this.lhs.add(DSL.field("{0} day", Expression.this.rhsAsNumber()));
                    }
                    return Expression.this.lhs.sub(DSL.field("{0} day", Expression.this.rhsAsNumber()));
                }
                case DERBY: {
                    Field result = Expression.this.operator == ExpressionOperator.ADD ? DSL.field("{fn {timestampadd}({sql_tsi_day}, {0}, {1}) }", this.getDataType(), Expression.this.rhsAsNumber(), Expression.this.lhs) : DSL.field("{fn {timestampadd}({sql_tsi_day}, {0}, {1}) }", this.getDataType(), Expression.this.rhsAsNumber().neg(), Expression.this.lhs);
                    return this.castNonTimestamps(configuration, result);
                }
                case CUBRID: 
                case MARIADB: 
                case MYSQL: {
                    if (Expression.this.operator == ExpressionOperator.ADD) {
                        return DSL.field("{date_add}({0}, {interval} {1} {day})", this.getDataType(), Expression.this.lhs, Expression.this.rhsAsNumber());
                    }
                    return DSL.field("{date_add}({0}, {interval} {1} {day})", this.getDataType(), Expression.this.lhs, Expression.this.rhsAsNumber().neg());
                }
                case POSTGRES: {
                    if (Expression.this.operator == ExpressionOperator.ADD) {
                        return new DateAdd(Expression.this.lhs, Expression.this.rhsAsNumber(), DatePart.DAY);
                    }
                    return new DateAdd(Expression.this.lhs, Expression.this.rhsAsNumber().neg(), DatePart.DAY);
                }
                case SQLITE: {
                    if (Expression.this.operator == ExpressionOperator.ADD) {
                        return DSL.field("{datetime}({0}, {1})", this.getDataType(), Expression.this.lhs, Expression.this.rhsAsNumber().concat(DSL.inline(" day")));
                    }
                    return DSL.field("{datetime}({0}, {1})", this.getDataType(), Expression.this.lhs, Expression.this.rhsAsNumber().neg().concat(DSL.inline(" day")));
                }
            }
            return new DefaultExpression();
        }
    }
}

