/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.conf;

import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.conf.OzoneManagersCommandHandler;
import org.apache.hadoop.ozone.conf.PrintConfKeyCommandHandler;
import org.apache.hadoop.ozone.conf.StorageContainerManagersCommandHandler;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import picocli.CommandLine;

@CommandLine.Command(name="ozone getconf", description={"ozone getconf is utility for getting configuration information from the config file."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={PrintConfKeyCommandHandler.class, StorageContainerManagersCommandHandler.class, OzoneManagersCommandHandler.class})
public class OzoneGetConf
extends GenericCli {
    void printError(String message) {
        this.err().println(message);
    }

    void printOut(String message) {
        this.out().println(message);
    }

    OzoneConfiguration getConf() {
        return this.getOzoneConf();
    }

    public static void main(String[] argv) {
        LogManager.resetConfiguration();
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        Logger.getLogger(NativeCodeLoader.class).setLevel(Level.ERROR);
        new OzoneGetConf().run(argv);
    }
}

