/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.KeyGeneratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ockrw", aliases={"ozone-client-key-read-write-list-ops"}, description={"Generate keys with a fixed name and ranges that can be written, read and listed as sub-ranges from multiple clients."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OzoneClientKeyReadWriteListOps
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the volume which contains the test data. Will be created if missing."}, defaultValue="ockrwvolume")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data."}, defaultValue="ockrwbucket")
    private String bucketName;
    @CommandLine.Option(names={"-m", "--read-metadata-only"}, description={"If only read key's metadata."}, defaultValue="false")
    private boolean readMetadataOnly;
    @CommandLine.Option(names={"-s", "--start-index"}, description={"Start index of keys of read/write operation.This can allow adding keys incrementally or parallel from multiple clients. Example: Write keys 0-1000000 followed by keys 1000001-2000000."}, defaultValue="0")
    private long startIndex;
    @CommandLine.Option(names={"-r", "--range"}, description={"Range of read/write operations. This in co-ordination with --start-index can specify the range to read. Example: Read from --start-index 1000 and read --range 1000 keys."}, defaultValue="1")
    private long range;
    @CommandLine.Option(names={"--size"}, description={"Object size (in bytes) to read/write. If user sets a read size which is larger than the key size, it only reads bytes up to key size."}, defaultValue="1")
    private int objectSizeInBytes;
    @CommandLine.Option(names={"--contiguous"}, description={"By default, the keys are randomized lexically by calculating the md5 of the key name. If this option is set, the keys are written lexically contiguously."}, defaultValue="false")
    private boolean keySorted;
    @CommandLine.Option(names={"--linear"}, description={"Generate key names in a linear manner, there is no randomselection of keys"}, defaultValue="false")
    private boolean linear;
    @CommandLine.Option(names={"--percentage-read"}, description={"Percentage of read tasks in mix workload. The remainder of the percentage will be divided between write and list tasks. By default this is 0%, to populate a range."}, required=false, defaultValue="0")
    private int percentageRead;
    @CommandLine.Option(names={"--percentage-list"}, description={"Percentage of list tasks in mix workload. The remainder of the percentage will be divided between write and read tasks."}, required=false, defaultValue="0")
    private int percentageList;
    @CommandLine.Option(names={"--max-list-result"}, description={"Maximum number of keys to be fetched during the list task. It ensures the size of the result will not exceed this limit."}, defaultValue="1000")
    private int maxListResult;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    private Timer timer;
    private OzoneClient[] ozoneClients;
    private int clientCount;
    private byte[] keyContent;
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientKeyReadWriteListOps.class);
    private static final AtomicLong NEXT_NUMBER = new AtomicLong();
    private KeyGeneratorUtil kg;

    @Override
    public Void call() throws Exception {
        int i;
        this.init();
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        this.clientCount = this.getThreadNo();
        this.ozoneClients = new OzoneClient[this.clientCount];
        try {
            for (i = 0; i < this.clientCount; ++i) {
                this.ozoneClients[i] = this.createOzoneClient(this.omServiceID, ozoneConfiguration);
            }
            this.ensureVolumeAndBucketExist(this.ozoneClients[0], this.volumeName, this.bucketName);
            this.timer = this.getMetrics().timer("key-read-write-list");
            if (this.objectSizeInBytes >= 0) {
                this.keyContent = RandomUtils.secure().randomBytes(this.objectSizeInBytes);
            }
            if (this.kg == null) {
                this.kg = new KeyGeneratorUtil();
            }
            this.runTests(this::readWriteListKeys);
        }
        finally {
            for (i = 0; i < this.clientCount; ++i) {
                if (this.ozoneClients[i] == null) continue;
                this.ozoneClients[i].close();
            }
        }
        return null;
    }

    private void readWriteListKeys(long counter) throws RuntimeException {
        int clientIndex = (int)(counter % (long)this.clientCount);
        TaskType taskType = this.decideReadWriteOrListTask();
        String keyName = this.getKeyName();
        this.timer.time(() -> {
            try {
                switch (taskType.ordinal()) {
                    case 0: {
                        this.processReadTasks(keyName, this.ozoneClients[clientIndex]);
                        break;
                    }
                    case 1: {
                        this.processWriteTasks(keyName, this.ozoneClients[clientIndex]);
                        break;
                    }
                    case 2: {
                        this.processListTasks(this.ozoneClients[clientIndex]);
                        break;
                    }
                }
            }
            catch (RuntimeException ex) {
                LOG.error(ex.getMessage());
                throw ex;
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage());
                throw new RuntimeException(ex.getMessage());
            }
        });
    }

    public void processReadTasks(String keyName, OzoneClient client) throws RuntimeException, IOException {
        OzoneKeyDetails keyDetails = client.getProxy().getKeyDetails(this.volumeName, this.bucketName, keyName);
        if (!this.readMetadataOnly) {
            try (OzoneInputStream input = keyDetails.getContent();){
                byte[] byArray = IOUtils.readFully((InputStream)input, (int)this.objectSizeInBytes);
            }
        }
    }

    public void processWriteTasks(String keyName, OzoneClient ozoneClient) throws RuntimeException, IOException {
        try (OzoneOutputStream out = ozoneClient.getProxy().createKey(this.volumeName, this.bucketName, keyName, (long)this.objectSizeInBytes, null, new HashMap());){
            out.write(this.keyContent);
        }
    }

    public void processListTasks(OzoneClient ozoneClient) throws RuntimeException, IOException {
        ozoneClient.getProxy().listKeys(this.volumeName, this.bucketName, this.getPrefix(), null, this.maxListResult);
    }

    public TaskType decideReadWriteOrListTask() {
        int tmp = ThreadLocalRandom.current().nextInt(1, 101);
        if (tmp <= this.percentageRead) {
            return TaskType.READ_TASK;
        }
        if (tmp <= this.percentageRead + this.percentageList) {
            return TaskType.LIST_TASK;
        }
        return TaskType.WRITE_TASK;
    }

    public String getKeyName() {
        StringBuilder keyNameSb = new StringBuilder();
        long next = this.linear ? this.startIndex + NEXT_NUMBER.getAndUpdate(x -> (x + 1L) % this.range) : ThreadLocalRandom.current().nextLong(this.startIndex, this.startIndex + this.range);
        if (this.keySorted) {
            keyNameSb.append(this.getPrefix()).append("/").append(next);
        } else {
            keyNameSb.append(this.getPrefix()).append("/").append(this.kg.generateMd5KeyName(next));
        }
        return keyNameSb.toString();
    }

    @Override
    public boolean allowEmptyPrefix() {
        return true;
    }

    public static enum TaskType {
        READ_TASK,
        WRITE_TASK,
        LIST_TASK;

    }
}

