/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.AbstractPathElement;

final class RankingPathElement<V, E>
extends AbstractPathElement<V, E>
implements GraphPath<V, E> {
    private double weight;
    private Graph<V, E> graph;

    RankingPathElement(Graph<V, E> graph, RankingPathElement<V, E> pathElement, E edge, double weight) {
        super(graph, pathElement, edge);
        this.weight = weight;
        this.graph = graph;
    }

    RankingPathElement(V vertex) {
        super(vertex);
        this.weight = 0.0;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public RankingPathElement<V, E> getPrevPathElement() {
        return (RankingPathElement)super.getPrevPathElement();
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public V getStartVertex() {
        if (this.getPrevPathElement() == null) {
            return super.getVertex();
        }
        return ((RankingPathElement)this.getPrevPathElement()).getStartVertex();
    }

    @Override
    public V getEndVertex() {
        return super.getVertex();
    }

    @Override
    public List<E> getEdgeList() {
        return super.createEdgeListPath();
    }
}

