/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;

class DatanodeDeletedBlockTransactions {
    private final Map<DatanodeID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> transactions = new HashMap<DatanodeID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>>();
    private int blocksDeleted = 0;

    DatanodeDeletedBlockTransactions() {
    }

    void addTransactionToDN(DatanodeID dnID, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx) {
        this.transactions.computeIfAbsent(dnID, k -> new LinkedList()).add(tx);
        this.blocksDeleted += tx.getLocalIDCount();
        if (SCMBlockDeletingService.LOG.isDebugEnabled()) {
            SCMBlockDeletingService.LOG.debug("Transaction added: {} <- TX({}), DN {} <- blocksDeleted Add {}.", new Object[]{dnID, tx.getTxID(), dnID, tx.getLocalIDCount()});
        }
    }

    Map<DatanodeID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> getDatanodeTransactionMap() {
        return this.transactions;
    }

    int getBlocksDeleted() {
        return this.blocksDeleted;
    }

    List<String> getTransactionIDList(DatanodeID dnId) {
        return ((List)Optional.ofNullable(this.transactions.get(dnId)).orElse(new LinkedList())).stream().map(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction::getTxID).map(String::valueOf).collect(Collectors.toList());
    }

    public int getNumberOfBlocksForDatanode(DatanodeID dnId) {
        return ((List)Optional.ofNullable(this.transactions.get(dnId)).orElse(new LinkedList())).stream().mapToInt(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction::getLocalIDCount).sum();
    }

    boolean isEmpty() {
        return this.transactions.isEmpty();
    }
}

