/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.network.security.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;

public class QpidServerX509KeyManager
extends X509ExtendedKeyManager {
    private final X509ExtendedKeyManager _delegate;
    private final String _alias;

    public QpidServerX509KeyManager(String alias, URL keyStoreUrl, String keyStoreType, String keyStorePassword, String keyManagerFactoryAlgorithmName) throws GeneralSecurityException, IOException {
        this._alias = alias;
        KeyStore ks = SSLUtil.getInitializedKeyStore(keyStoreUrl, keyStorePassword, keyStoreType);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithmName);
        kmf.init(ks, keyStorePassword.toCharArray());
        this._delegate = (X509ExtendedKeyManager)kmf.getKeyManagers()[0];
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this._alias != null ? this._alias : this._delegate.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this._alias != null ? this._alias : this._delegate.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this._delegate.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] stringArray;
        if (this._alias != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this._alias;
        } else {
            stringArray = this._delegate.getClientAliases(keyType, issuers);
        }
        return stringArray;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        String[] stringArray;
        if (this._alias != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this._alias;
        } else {
            stringArray = this._delegate.getServerAliases(keyType, issuers);
        }
        return stringArray;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this._delegate.getPrivateKey(alias);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this._alias != null ? this._alias : this._delegate.chooseEngineClientAlias(keyType, issuers, engine);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this._alias != null ? this._alias : this._delegate.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

