/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v7_0;

import java.util.List;
import java.util.Map;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.controller.AbstractLegacyConfiguredObjectController;
import org.apache.qpid.server.management.plugin.controller.ConverterHelper;

public class LegacyManagementController
extends AbstractLegacyConfiguredObjectController {
    private static final String DEPTH_PARAM = "depth";
    private static final String OVERSIZE_PARAM = "oversize";
    private static final String ACTUALS_PARAM = "actuals";
    private static final String EXCLUDE_INHERITED_CONTEXT_PARAM = "excludeInheritedContext";
    private static final String SINGLETON_MODEL_OBJECT_RESPONSE_AS_LIST = "singletonModelObjectResponseAsList";
    private static final int DEFAULT_DEPTH = 0;
    private static final int DEFAULT_OVERSIZE = 120;

    public LegacyManagementController(ManagementController nextVersionManagementController, String modelVersion) {
        super(modelVersion, nextVersionManagementController);
    }

    @Override
    protected Map<String, List<String>> convertQueryParameters(Map<String, List<String>> parameters) {
        return parameters;
    }

    @Override
    public Object formatConfiguredObject(Object content, Map<String, List<String>> parameters, boolean isSecureOrAllowedOnInsecureChannel) {
        int depth = ConverterHelper.getIntParameterFromRequest(parameters, DEPTH_PARAM, 0);
        int oversizeThreshold = ConverterHelper.getIntParameterFromRequest(parameters, OVERSIZE_PARAM, 120);
        boolean actuals = Boolean.parseBoolean(ConverterHelper.getParameter(ACTUALS_PARAM, parameters));
        String excludeInheritedContextParameter = ConverterHelper.getParameter(EXCLUDE_INHERITED_CONTEXT_PARAM, parameters);
        boolean excludeInheritedContext = excludeInheritedContextParameter == null || Boolean.parseBoolean(excludeInheritedContextParameter);
        boolean responseAsList = Boolean.parseBoolean(ConverterHelper.getParameter(SINGLETON_MODEL_OBJECT_RESPONSE_AS_LIST, parameters));
        return this.formatConfiguredObject(content, isSecureOrAllowedOnInsecureChannel, depth, oversizeThreshold, actuals, excludeInheritedContext, responseAsList);
    }
}

