/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;

public class IntegerBinding
extends TupleBinding<Integer> {
    private static final int INT_SIZE = 4;

    @Override
    public Integer entryToObject(TupleInput input) {
        return input.readInt();
    }

    @Override
    public void objectToEntry(Integer object, TupleOutput output) {
        output.writeInt(object);
    }

    @Override
    protected TupleOutput getTupleOutput(Integer object) {
        return IntegerBinding.sizedOutput();
    }

    public static int entryToInt(DatabaseEntry entry) {
        return IntegerBinding.entryToInput(entry).readInt();
    }

    public static void intToEntry(int val, DatabaseEntry entry) {
        IntegerBinding.outputToEntry(IntegerBinding.sizedOutput().writeInt(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

