/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.lmq;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;

public class LMQProducer {
    public static final String PRODUCER_GROUP = "ProducerGroupName";
    public static final String DEFAULT_NAMESRVADDR = "127.0.0.1:9876";
    public static final String TOPIC = "TopicLMQParent";
    public static final String TAG = "TagA";
    public static final String LMQ_TOPIC_1 = "%LMQ%123";
    public static final String LMQ_TOPIC_2 = "%LMQ%456";

    public static void main(String[] args) throws MQClientException, InterruptedException {
        DefaultMQProducer producer = new DefaultMQProducer(PRODUCER_GROUP);
        producer.setNamesrvAddr(DEFAULT_NAMESRVADDR);
        producer.start();
        for (int i = 0; i < 128; ++i) {
            try {
                Message msg = new Message(TOPIC, TAG, ("Hello RocketMQ " + i).getBytes("UTF-8"));
                msg.setKeys("Key" + i);
                msg.putUserProperty("INNER_MULTI_DISPATCH", String.join((CharSequence)",", LMQ_TOPIC_1, LMQ_TOPIC_2));
                SendResult sendResult = producer.send(msg);
                System.out.printf("%s%n", sendResult);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        producer.shutdown();
    }
}

