/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.nio.ByteBuffer;
import org.apache.rocketmq.store.ConsumeQueueExt;

public class CqUnit {
    private final long queueOffset;
    private final int size;
    private final long pos;
    private final short batchNum;
    private long tagsCode;
    private ConsumeQueueExt.CqExtUnit cqExtUnit;
    private final ByteBuffer nativeBuffer;
    private final int compactedOffset;

    public CqUnit(long queueOffset, long pos, int size, long tagsCode) {
        this(queueOffset, pos, size, tagsCode, 1, 0, null);
    }

    public CqUnit(long queueOffset, long pos, int size, long tagsCode, short batchNum, int compactedOffset, ByteBuffer buffer) {
        this.queueOffset = queueOffset;
        this.pos = pos;
        this.size = size;
        this.tagsCode = tagsCode;
        this.batchNum = batchNum;
        this.nativeBuffer = buffer;
        this.compactedOffset = compactedOffset;
    }

    public int getSize() {
        return this.size;
    }

    public long getPos() {
        return this.pos;
    }

    public long getTagsCode() {
        return this.tagsCode;
    }

    public Long getValidTagsCodeAsLong() {
        if (!this.isTagsCodeValid()) {
            return null;
        }
        return this.tagsCode;
    }

    public boolean isTagsCodeValid() {
        return !ConsumeQueueExt.isExtAddr(this.tagsCode);
    }

    public ConsumeQueueExt.CqExtUnit getCqExtUnit() {
        return this.cqExtUnit;
    }

    public void setCqExtUnit(ConsumeQueueExt.CqExtUnit cqExtUnit) {
        this.cqExtUnit = cqExtUnit;
    }

    public void setTagsCode(long tagsCode) {
        this.tagsCode = tagsCode;
    }

    public long getQueueOffset() {
        return this.queueOffset;
    }

    public short getBatchNum() {
        return this.batchNum;
    }

    public void correctCompactOffset(int correctedOffset) {
        this.nativeBuffer.putInt(correctedOffset);
    }

    public int getCompactedOffset() {
        return this.compactedOffset;
    }

    public String toString() {
        return "CqUnit{queueOffset=" + this.queueOffset + ", size=" + this.size + ", pos=" + this.pos + ", batchNum=" + this.batchNum + ", tagsCode=" + this.tagsCode + ", compactedOffset=" + this.compactedOffset + '}';
    }
}

