/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception.converter;

import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.TimeoutException;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionConverter;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutExceptionConverter
implements ExceptionConverter<TimeoutException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutExceptionConverter.class);
    public static final int ORDER = Short.MAX_VALUE;

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean canConvert(Throwable throwable) {
        return throwable instanceof TimeoutException;
    }

    @Override
    public InvocationException convert(@Nullable Invocation invocation, TimeoutException throwable, Response.StatusType genericStatus) {
        LOGGER.info("Request timeout, Details: {}.", (Object)throwable.getMessage());
        return new InvocationException((Response.StatusType)Response.Status.REQUEST_TIMEOUT, ExceptionConverter.getGenericCode(genericStatus), "Request Timeout.", (Throwable)throwable);
    }
}

