/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey3;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.EurekaClientIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.decorator.MetricsCollectingEurekaHttpClient;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import com.netflix.discovery.shared.transport.jersey3.Jersey3ApplicationClientFactory;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.util.Collection;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class Jersey3TransportClientFactories
implements TransportClientFactories<ClientRequestFilter> {
    private static final Jersey3TransportClientFactories INSTANCE = new Jersey3TransportClientFactories();

    public static Jersey3TransportClientFactories getInstance() {
        return INSTANCE;
    }

    public TransportClientFactory newTransportClientFactory(EurekaClientConfig clientConfig, Collection<ClientRequestFilter> additionalFilters, InstanceInfo myInstanceInfo) {
        return this.newTransportClientFactory(clientConfig, additionalFilters, myInstanceInfo, Optional.empty(), Optional.empty());
    }

    public TransportClientFactory newTransportClientFactory(EurekaClientConfig clientConfig, Collection<ClientRequestFilter> additionalFilters, InstanceInfo myInstanceInfo, Optional<SSLContext> sslContext, Optional<HostnameVerifier> hostnameVerifier) {
        final Jersey3ApplicationClientFactory jerseyFactory = Jersey3ApplicationClientFactory.create(clientConfig, additionalFilters, myInstanceInfo, (AbstractEurekaIdentity)new EurekaClientIdentity(myInstanceInfo.getIPAddr(), "Jersey3DefaultClient"), sslContext, hostnameVerifier);
        final TransportClientFactory metricsFactory = MetricsCollectingEurekaHttpClient.createFactory((TransportClientFactory)jerseyFactory);
        return new TransportClientFactory(){

            public EurekaHttpClient newClient(EurekaEndpoint serviceUrl) {
                return metricsFactory.newClient(serviceUrl);
            }

            public void shutdown() {
                metricsFactory.shutdown();
                jerseyFactory.shutdown();
            }
        };
    }
}

