/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store.channel;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.integration.support.converter.AllowListDeserializingConverter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.messaging.Message;

public class MessageRowMapper
implements RowMapper<Message<?>> {
    private final AllowListDeserializingConverter deserializer;
    private final LobHandler lobHandler;

    public MessageRowMapper(AllowListDeserializingConverter deserializer, LobHandler lobHandler) {
        this.deserializer = deserializer;
        this.lobHandler = lobHandler;
    }

    public Message<?> mapRow(ResultSet rs, int rowNum) throws SQLException {
        byte[] blobAsBytes = this.lobHandler.getBlobAsBytes(rs, "MESSAGE_BYTES");
        if (blobAsBytes == null) {
            return null;
        }
        return (Message)this.deserializer.convert(blobAsBytes);
    }
}

