/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.plugin;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class PluginChangedEvent
extends AdminDataModelChangedEvent {
    public PluginChangedEvent(PluginDO source, PluginDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        PluginDO after = (PluginDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the plugin [%s] is %s", after.getName(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the plugin [%s] is %s : %s", after.getName(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        PluginDO before = (PluginDO)this.getBefore();
        Objects.requireNonNull(before);
        PluginDO after = (PluginDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getName(), after.getName())) {
            builder.append(String.format("name[%s => %s] ", before.getName(), after.getName()));
        }
        if (!Objects.equals(before.getConfig(), after.getConfig())) {
            builder.append(String.format("config[%s => %s] ", before.getConfig(), after.getConfig()));
        }
        if (!Objects.equals(before.getRole(), after.getRole())) {
            builder.append(String.format("role[%s => %s] ", before.getRole(), after.getRole()));
        }
        if (!Objects.equals(before.getEnabled(), after.getEnabled())) {
            builder.append(String.format("enable[%s => %s] ", before.getEnabled(), after.getEnabled()));
        }
        if (!Objects.equals(before.getSort(), after.getSort())) {
            builder.append(String.format("sort[%s => %s] ", before.getSort(), after.getSort()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "plugin";
    }
}

