/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.transfer;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.model.dto.MetaDataDTO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.vo.MetaDataVO;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;

public enum MetaDataTransfer {
    INSTANCE;


    public MetaDataDO mapToEntity(MetaDataDTO metaDataDTO) {
        return Optional.ofNullable(metaDataDTO).map(dto -> MetaDataDO.builder().id(dto.getId()).appName(dto.getAppName()).path(dto.getPath()).pathDesc(dto.getPathDesc()).rpcType(dto.getRpcType()).serviceName(dto.getServiceName()).methodName(dto.getMethodName()).parameterTypes(dto.getParameterTypes()).rpcExt(dto.getRpcExt()).enabled(dto.getEnabled()).namespaceId(metaDataDTO.getNamespaceId()).build()).orElse(null);
    }

    public MetaDataDO mapRegisterDTOToEntity(MetaDataRegisterDTO metaDataDTO) {
        return Optional.ofNullable(metaDataDTO).map(dto -> MetaDataDO.builder().appName(dto.getAppName()).path(dto.getPath()).pathDesc(dto.getPathDesc()).rpcType(dto.getRpcType()).serviceName(dto.getServiceName()).methodName(dto.getMethodName()).parameterTypes(dto.getParameterTypes()).rpcExt(dto.getRpcExt()).enabled(dto.isEnabled()).namespaceId(dto.getNamespaceId()).build()).orElse(null);
    }

    public MetaDataDO copy(MetaDataDO metaDataDO) {
        return Optional.ofNullable(metaDataDO).map(source -> MetaDataDO.builder().id(source.getId()).appName(source.getAppName()).path(source.getPath()).pathDesc(source.getPathDesc()).rpcType(source.getRpcType()).serviceName(source.getServiceName()).methodName(source.getMethodName()).parameterTypes(source.getParameterTypes()).rpcExt(source.getRpcExt()).enabled(source.getEnabled()).build()).orElse(null);
    }

    public MetaData mapToData(MetaDataDTO metaDataDTO) {
        return Optional.ofNullable(metaDataDTO).map(v -> MetaData.builder().id(v.getId()).appName(v.getAppName()).contextPath(v.getContextPath()).path(v.getPath()).rpcType(v.getRpcType()).serviceName(v.getServiceName()).methodName(v.getMethodName()).parameterTypes(v.getParameterTypes()).rpcExt(v.getRpcExt()).enabled(v.getEnabled()).build()).orElse(null);
    }

    public MetaData mapToData(MetaDataDO metaDataDO) {
        return Optional.ofNullable(metaDataDO).map(v -> MetaData.builder().id(v.getId()).appName(v.getAppName()).path(v.getPath()).rpcType(v.getRpcType()).serviceName(v.getServiceName()).methodName(v.getMethodName()).parameterTypes(v.getParameterTypes()).rpcExt(v.getRpcExt()).enabled(v.getEnabled()).namespaceId(v.getNamespaceId()).build()).orElse(null);
    }

    public List<MetaData> mapToDataAll(List<MetaDataDO> metaDataDOList) {
        return Optional.ofNullable(metaDataDOList).map(v -> v.stream().map(this::mapToData).collect(Collectors.toList())).orElse(null);
    }

    public MetaDataVO mapToVO(MetaDataDO metaDataDO) {
        return Optional.ofNullable(metaDataDO).map(v -> {
            MetaDataVO metaDataVO = new MetaDataVO();
            metaDataVO.setAppName(metaDataDO.getAppName());
            metaDataVO.setPath(metaDataDO.getPath());
            metaDataVO.setPathDesc(metaDataDO.getPathDesc());
            metaDataVO.setRpcType(metaDataDO.getRpcType());
            metaDataVO.setServiceName(metaDataDO.getServiceName());
            metaDataVO.setMethodName(metaDataDO.getMethodName());
            metaDataVO.setParameterTypes(metaDataDO.getParameterTypes());
            metaDataVO.setRpcExt(metaDataDO.getRpcExt());
            metaDataVO.setId(metaDataDO.getId());
            metaDataVO.setEnabled(metaDataDO.getEnabled());
            metaDataVO.setDateCreated(Optional.ofNullable(metaDataDO.getDateCreated()).map(u -> DateUtils.localDateTimeToString((LocalDateTime)u.toLocalDateTime())).orElse(null));
            metaDataVO.setDateUpdated(Optional.ofNullable(metaDataDO.getDateUpdated()).map(u -> DateUtils.localDateTimeToString((LocalDateTime)u.toLocalDateTime())).orElse(null));
            return metaDataVO;
        }).orElse(null);
    }

    public List<MetaDataVO> mapToVOList(List<MetaDataDO> metaDataDOList) {
        return Optional.ofNullable(metaDataDOList).map(v -> v.stream().map(this::mapToVO).collect(Collectors.toList())).orElse(null);
    }
}

