/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.Http2ServerRequest;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class Http2ServerConnection
extends Http2ConnectionBase
implements HttpServerConnection {
    final HttpServerOptions options;
    private final String serverOrigin;
    private final HttpServerMetrics metrics;
    private final Function<String, String> encodingDetector;
    private final Supplier<ContextInternal> streamContextSupplier;
    Handler<HttpServerRequest> requestHandler;
    private int concurrentStreams;
    private final ArrayDeque<Push> pendingPushes = new ArrayDeque(8);

    Http2ServerConnection(EventLoopContext context, Supplier<ContextInternal> streamContextSupplier, String serverOrigin, VertxHttp2ConnectionHandler connHandler, Function<String, String> encodingDetector, HttpServerOptions options, HttpServerMetrics metrics) {
        super(context, connHandler);
        this.options = options;
        this.serverOrigin = serverOrigin;
        this.encodingDetector = encodingDetector;
        this.streamContextSupplier = streamContextSupplier;
        this.metrics = metrics;
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerConnection invalidRequestHandler(Handler<HttpServerRequest> handler) {
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    private static boolean isMalformedRequest(Http2Headers headers) {
        if (headers.method() == null) {
            return true;
        }
        String method = headers.method().toString();
        if (method.equals("CONNECT") ? headers.scheme() != null || headers.path() != null || headers.authority() == null : headers.method() == null || headers.scheme() == null || headers.path() == null) {
            return true;
        }
        if (headers.authority() != null) {
            URI uri;
            try {
                uri = new URI(null, headers.authority().toString(), null, null, null);
            }
            catch (URISyntaxException e) {
                return true;
            }
            if (uri.getRawUserInfo() != null) {
                return true;
            }
        }
        return false;
    }

    String determineContentEncoding(Http2Headers headers) {
        String acceptEncoding;
        String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && this.encodingDetector != null) {
            return this.encodingDetector.apply(acceptEncoding);
        }
        return null;
    }

    private Http2ServerRequest createRequest(int streamId, Http2Headers headers, boolean streamEnded) {
        Http2Stream stream = this.handler.connection().stream(streamId);
        String contentEncoding = this.options.isCompressionSupported() ? this.determineContentEncoding(headers) : null;
        Http2ServerRequest request = new Http2ServerRequest(this, this.options.getTracingPolicy(), this.streamContextSupplier.get(), this.serverOrigin, headers, contentEncoding, streamEnded);
        request.isConnect = request.method() == HttpMethod.CONNECT;
        request.init(stream);
        return request;
    }

    @Override
    protected synchronized void onHeadersRead(int streamId, Http2Headers headers, StreamPriority streamPriority, boolean endOfStream) {
        Http2ServerRequest stream = this.stream(streamId);
        if (stream == null) {
            if (Http2ServerConnection.isMalformedRequest(headers)) {
                this.handler.writeReset(streamId, Http2Error.PROTOCOL_ERROR.code());
                return;
            }
            stream = this.createRequest(streamId, headers, endOfStream);
            ((VertxHttp2Stream)stream).onHeaders(headers, streamPriority);
        }
        if (endOfStream) {
            stream.onEnd();
        }
    }

    void sendPush(int streamId, String host, HttpMethod method, MultiMap headers, String path, StreamPriority streamPriority, Promise<HttpServerResponse> promise) {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doSendPush(streamId, host, method, headers, path, streamPriority, promise);
        } else {
            eventLoop.execute(() -> this.doSendPush(streamId, host, method, headers, path, streamPriority, promise));
        }
    }

    private synchronized void doSendPush(int streamId, String host, HttpMethod method, MultiMap headers, String path, StreamPriority streamPriority, Promise<HttpServerResponse> promise) {
        DefaultHttp2Headers headers_ = new DefaultHttp2Headers();
        headers_.method((CharSequence)method.name());
        headers_.path((CharSequence)path);
        headers_.scheme((CharSequence)(this.isSsl() ? "https" : "http"));
        if (host != null) {
            headers_.authority((CharSequence)host);
        }
        if (headers != null) {
            headers.forEach(arg_0 -> Http2ServerConnection.lambda$doSendPush$1((Http2Headers)headers_, arg_0));
        }
        Future<Integer> fut = this.handler.writePushPromise(streamId, (Http2Headers)headers_);
        fut.addListener((GenericFutureListener)((FutureListener)arg_0 -> this.lambda$doSendPush$2((Http2Headers)headers_, method, path, promise, streamPriority, arg_0)));
    }

    @Override
    protected void updateSettings(Http2Settings settingsUpdate, Handler<AsyncResult<Void>> completionHandler) {
        settingsUpdate.remove('\u0002');
        super.updateSettings(settingsUpdate, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$doSendPush$2(Http2Headers headers_, HttpMethod method, String path, Promise promise, StreamPriority streamPriority, Future future) throws Exception {
        if (future.isSuccess()) {
            Http2ServerConnection http2ServerConnection = this;
            synchronized (http2ServerConnection) {
                int promisedStreamId = (Integer)future.getNow();
                String contentEncoding = this.determineContentEncoding(headers_);
                Http2Stream promisedStream = this.handler.connection().stream(promisedStreamId);
                Push push = new Push(this.context, contentEncoding, method, path, promise);
                push.priority(streamPriority);
                push.init(promisedStream);
                int maxConcurrentStreams = this.handler.maxConcurrentStreams();
                if (this.concurrentStreams < maxConcurrentStreams) {
                    ++this.concurrentStreams;
                    push.complete();
                } else {
                    this.pendingPushes.add(push);
                }
            }
        } else {
            promise.fail(future.cause());
        }
    }

    private static /* synthetic */ void lambda$doSendPush$1(Http2Headers headers_, Map.Entry header) {
        Http2Headers cfr_ignored_0 = (Http2Headers)headers_.add(header.getKey(), header.getValue());
    }

    private class Push
    extends Http2ServerStream {
        private final Promise<HttpServerResponse> promise;

        public Push(ContextInternal context, String contentEncoding, HttpMethod method, String uri, Promise<HttpServerResponse> promise) {
            super(Http2ServerConnection.this, context, contentEncoding, method, uri);
            this.promise = promise;
        }

        @Override
        void dispatch(Handler<HttpServerRequest> handler) {
            throw new UnsupportedOperationException();
        }

        @Override
        void handleWritabilityChanged(boolean writable) {
            this.response.handlerWritabilityChanged(writable);
        }

        @Override
        void handleReset(long errorCode) {
            if (!this.promise.tryFail(new StreamResetException(errorCode))) {
                this.response.handleReset(errorCode);
            }
        }

        @Override
        void handleException(Throwable cause) {
            if (this.response != null) {
                this.response.handleException(cause);
            }
        }

        @Override
        void handleClose(HttpClosedException ex) {
            super.handleClose(ex);
            if (Http2ServerConnection.this.pendingPushes.remove(this)) {
                this.promise.fail("Push reset by client");
            } else {
                Http2ServerConnection.this.concurrentStreams--;
                int maxConcurrentStreams = Http2ServerConnection.this.handler.maxConcurrentStreams();
                while (Http2ServerConnection.this.concurrentStreams < maxConcurrentStreams && Http2ServerConnection.this.pendingPushes.size() > 0) {
                    Push push = (Push)Http2ServerConnection.this.pendingPushes.pop();
                    Http2ServerConnection.this.concurrentStreams++;
                    push.complete();
                }
                this.response.handleClose(ex);
            }
        }

        void complete() {
            this.registerMetrics();
            this.promise.complete(this.response);
        }
    }

    private static class EncodingDetector
    extends HttpContentCompressor {
        private EncodingDetector(CompressionOptions[] compressionOptions) {
            super(compressionOptions);
        }

        protected String determineEncoding(String acceptEncoding) {
            return super.determineEncoding(acceptEncoding);
        }
    }
}

