/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.rpc.protocol.tup;

import com.qq.tars.rpc.protocol.tup.ObjectCreateException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicClassTypeUtil {
    private static void addType(ArrayList<String> list, String type) {
        int point = type.length();
        while (type.charAt(point - 1) == '>' && --point != 0) {
        }
        list.add(0, BasicClassTypeUtil.uni2JavaType(type.substring(0, point)));
    }

    public static ArrayList<String> getTypeList(String fullType) {
        ArrayList<String> type = new ArrayList<String>();
        int point = 0;
        int splitPoint = fullType.indexOf("<");
        int mapPoint = -1;
        while (point < splitPoint) {
            BasicClassTypeUtil.addType(type, fullType.substring(point, splitPoint));
            point = splitPoint + 1;
            splitPoint = fullType.indexOf("<", point);
            mapPoint = fullType.indexOf(",", point);
            if (splitPoint == -1) {
                splitPoint = mapPoint;
            }
            if (mapPoint == -1 || mapPoint >= splitPoint) continue;
            splitPoint = mapPoint;
        }
        BasicClassTypeUtil.addType(type, fullType.substring(point, fullType.length()));
        return type;
    }

    public static void main(String[] args) {
        ArrayList<String> src = new ArrayList<String>();
        src.add("char");
        src.add("list<char>");
        src.add("list<list<char>>");
        src.add("map<short,string>");
        src.add("map<double,map<float,list<bool>>>");
        src.add("map<int64,list<Test.UserInfo>>");
        src.add("map<short,Test.FriendInfo>");
        for (String ss : src) {
            ArrayList<String> list = BasicClassTypeUtil.getTypeList(ss);
            for (String s : list) {
                System.out.println(s);
            }
            Collections.reverse(list);
            System.out.println("-------------finished " + BasicClassTypeUtil.transTypeList(list));
        }
    }

    public static String transTypeList(ArrayList<String> listType) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < listType.size(); ++i) {
            listType.set(i, BasicClassTypeUtil.java2UniType(listType.get(i)));
        }
        Collections.reverse(listType);
        block11: for (i = 0; i < listType.size(); ++i) {
            String type;
            switch (type = listType.get(i)) {
                case "list": {
                    listType.set(i - 1, "<" + listType.get(i - 1));
                    listType.set(0, listType.get(0) + ">");
                    continue block11;
                }
                case "map": {
                    listType.set(i - 1, "<" + listType.get(i - 1) + ",");
                    listType.set(0, listType.get(0) + ">");
                    continue block11;
                }
                case "Array": {
                    listType.set(i - 1, "<" + listType.get(i - 1));
                    listType.set(0, listType.get(0) + ">");
                }
            }
        }
        Collections.reverse(listType);
        for (String s : listType) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static Object createClassByUni(String className) throws ObjectCreateException {
        ArrayList<String> list = BasicClassTypeUtil.getTypeList(className);
        Object last = null;
        Object last2 = null;
        Object returnObject = null;
        for (String name : list) {
            returnObject = BasicClassTypeUtil.createClassByName(name);
            if (returnObject instanceof String) {
                if ("Array".equals((String)returnObject)) {
                    if (last != null) continue;
                    returnObject = Array.newInstance(Byte.class, 0);
                    continue;
                }
                if ("?".equals((String)returnObject)) continue;
                if (last == null) {
                    last = returnObject;
                    continue;
                }
                last2 = last;
                last = returnObject;
                continue;
            }
            if (returnObject instanceof List) {
                if (null != last && last instanceof Byte) {
                    returnObject = Array.newInstance(Byte.class, 1);
                    Array.set(returnObject, 0, last);
                    continue;
                }
                if (last != null) {
                    ((List)returnObject).add(last);
                }
                last = null;
                continue;
            }
            if (returnObject instanceof Map) {
                if (last != null & last2 != null) {
                    ((Map)returnObject).put(last, last2);
                }
                last = null;
                last2 = null;
                continue;
            }
            if (last == null) {
                last = returnObject;
                continue;
            }
            last2 = last;
            last = returnObject;
        }
        return returnObject;
    }

    public static Object createClassByName(String name) throws ObjectCreateException {
        switch (name) {
            case "java.lang.Integer": {
                return 0;
            }
            case "java.lang.Boolean": {
                return false;
            }
            case "java.lang.Byte": {
                return (byte)0;
            }
            case "java.lang.Double": {
                return 0.0;
            }
            case "java.lang.Float": {
                return Float.valueOf(0.0f);
            }
            case "java.lang.Long": {
                return 0L;
            }
            case "java.lang.Short": {
                return (short)0;
            }
            case "java.lang.Character": {
                throw new IllegalArgumentException("can not support java.lang.Character");
            }
            case "java.lang.String": {
                return "";
            }
            case "java.util.List": {
                return new ArrayList();
            }
            case "java.util.Map": {
                return new HashMap();
            }
            case "Array": {
                return "Array";
            }
            case "?": {
                return name;
            }
        }
        Object result = null;
        try {
            Class<?> newoneClass = Class.forName(name);
            Constructor<?> cons = newoneClass.getConstructor(new Class[0]);
            result = cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ObjectCreateException(e);
        }
        return result;
    }

    public static String java2UniType(String srcType) {
        switch (srcType) {
            case "java.lang.Integer": 
            case "int": {
                return "int32";
            }
            case "java.lang.Boolean": 
            case "boolean": {
                return "bool";
            }
            case "java.lang.Byte": 
            case "byte": {
                return "char";
            }
            case "java.lang.Double": 
            case "double": {
                return "double";
            }
            case "java.lang.Float": 
            case "float": {
                return "float";
            }
            case "java.lang.Long": 
            case "long": {
                return "int64";
            }
            case "java.lang.Short": 
            case "short": {
                return "short";
            }
            case "java.lang.Character": {
                throw new IllegalArgumentException("can not support java.lang.Character");
            }
            case "java.lang.String": {
                return "string";
            }
            case "java.util.List": {
                return "list";
            }
            case "java.util.Map": {
                return "map";
            }
        }
        return srcType;
    }

    public static String uni2JavaType(String srcType) {
        switch (srcType) {
            case "int32": {
                return "java.lang.Integer";
            }
            case "bool": {
                return "java.lang.Boolean";
            }
            case "char": {
                return "java.lang.Byte";
            }
            case "double": {
                return "java.lang.Double";
            }
            case "float": {
                return "java.lang.Float";
            }
            case "int64": {
                return "java.lang.Long";
            }
            case "short": {
                return "java.lang.Short";
            }
            case "string": {
                return "java.lang.String";
            }
            case "list": {
                return "java.util.List";
            }
            case "map": {
                return "java.util.Map";
            }
        }
        return srcType;
    }

    public static boolean isBasicType(String name) {
        switch (name) {
            case "int": 
            case "boolean": 
            case "byte": 
            case "double": 
            case "float": 
            case "long": 
            case "short": 
            case "char": 
            case "Integer": 
            case "Boolean": 
            case "Byte": 
            case "Double": 
            case "Float": 
            case "Long": 
            case "Short": 
            case "Char": {
                return true;
            }
        }
        return false;
    }

    public static String getClassTransName(String name) {
        switch (name) {
            case "int": {
                return "Integer";
            }
            case "boolean": {
                return "Boolean";
            }
            case "byte": {
                return "Byte";
            }
            case "double": {
                return "Double";
            }
            case "float": {
                return "Float";
            }
            case "long": {
                return "Long";
            }
            case "short": {
                return "Short";
            }
            case "char": {
                return "Character";
            }
        }
        return name;
    }

    public static String getVariableInit(String name, String type) {
        switch (type) {
            case "int": 
            case "double": 
            case "float": 
            case "long": 
            case "short": {
                return type + " " + name + "=0 ;\n";
            }
            case "boolean": {
                return type + " " + name + "=false ;\n";
            }
            case "byte": 
            case "char": {
                return type + " " + name + " ;\n";
            }
        }
        return type + " " + name + " = null ;\n";
    }
}

