/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.common.policies.data.NonPersistentPublisherStats;
import org.apache.pulsar.common.policies.data.NonPersistentReplicatorStats;
import org.apache.pulsar.common.policies.data.NonPersistentSubscriptionStats;
import org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.policies.data.stats.NonPersistentPublisherStatsImpl;
import org.apache.pulsar.common.policies.data.stats.NonPersistentReplicatorStatsImpl;
import org.apache.pulsar.common.policies.data.stats.NonPersistentSubscriptionStatsImpl;
import org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.common.policies.data.stats.SubscriptionStatsImpl;
import org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class NonPersistentTopicStatsImpl
extends TopicStatsImpl
implements NonPersistentTopicStats {
    public double msgDropRate;
    @JsonIgnore
    public List<PublisherStatsImpl> publishers;
    @JsonIgnore
    public Map<String, SubscriptionStatsImpl> subscriptions;
    @JsonIgnore
    public Map<String, ReplicatorStatsImpl> replication;
    private List<NonPersistentPublisherStats> nonPersistentPublishers = new ArrayList<NonPersistentPublisherStats>();
    private Map<String, NonPersistentPublisherStats> nonPersistentPublishersMap = new ConcurrentHashMap<String, NonPersistentPublisherStats>();
    public Map<String, ? extends NonPersistentSubscriptionStats> nonPersistentSubscriptions = new HashMap<String, NonPersistentSubscriptionStats>();
    public Map<String, ? extends NonPersistentReplicatorStats> nonPersistentReplicators = new TreeMap<String, NonPersistentReplicatorStats>();

    @JsonProperty(value="publishers")
    public List<NonPersistentPublisherStats> getNonPersistentPublishers() {
        return Stream.concat(this.nonPersistentPublishers.stream().sorted(Comparator.comparing(PublisherStats::getProducerName, Comparator.nullsLast(Comparator.naturalOrder()))), this.nonPersistentPublishersMap.values().stream().sorted(Comparator.comparing(PublisherStats::getProducerName, Comparator.nullsLast(Comparator.naturalOrder())))).collect(Collectors.toList());
    }

    @JsonProperty(value="subscriptions")
    public Map<String, NonPersistentSubscriptionStats> getNonPersistentSubscriptions() {
        return this.nonPersistentSubscriptions;
    }

    @JsonProperty(value="replication")
    public Map<String, NonPersistentReplicatorStats> getNonPersistentReplicators() {
        return this.nonPersistentReplicators;
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public List<NonPersistentPublisherStats> getPublishers() {
        return Stream.concat(this.nonPersistentPublishers.stream().sorted(Comparator.comparing(PublisherStats::getProducerName, Comparator.nullsLast(Comparator.naturalOrder()))), this.nonPersistentPublishersMap.values().stream().sorted(Comparator.comparing(PublisherStats::getProducerName, Comparator.nullsLast(Comparator.naturalOrder())))).collect(Collectors.toList());
    }

    @Override
    public void setPublishers(List<? extends PublisherStats> statsList) {
        this.nonPersistentPublishers.clear();
        this.nonPersistentPublishersMap.clear();
        statsList.forEach(s2 -> this.addPublisher((NonPersistentPublisherStatsImpl)s2));
    }

    public void addPublisher(NonPersistentPublisherStatsImpl stats) {
        if (stats.isSupportsPartialProducer() && stats.getProducerName() != null) {
            this.nonPersistentPublishersMap.put(stats.getProducerName(), stats);
        } else {
            stats.setSupportsPartialProducer(false);
            this.nonPersistentPublishers.add(stats);
        }
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public Map<String, NonPersistentSubscriptionStats> getSubscriptions() {
        return this.nonPersistentSubscriptions;
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public Map<String, NonPersistentReplicatorStats> getReplication() {
        return this.nonPersistentReplicators;
    }

    public double getMsgDropRate() {
        return this.msgDropRate;
    }

    @Override
    public void reset() {
        super.reset();
        this.nonPersistentPublishers.clear();
        this.nonPersistentPublishersMap.clear();
        this.nonPersistentSubscriptions.clear();
        this.nonPersistentReplicators.clear();
        this.msgDropRate = 0.0;
    }

    public NonPersistentTopicStatsImpl add(NonPersistentTopicStats ts) {
        NonPersistentTopicStatsImpl stats = (NonPersistentTopicStatsImpl)ts;
        Objects.requireNonNull(stats);
        super.add(stats);
        this.msgDropRate += stats.msgDropRate;
        List<NonPersistentPublisherStats> publisherStats = stats.getNonPersistentPublishers();
        for (int index = 0; index < publisherStats.size(); ++index) {
            NonPersistentPublisherStats nonPersistentPublisherStats = publisherStats.get(index);
            if (nonPersistentPublisherStats.isSupportsPartialProducer() && nonPersistentPublisherStats.getProducerName() != null) {
                ((NonPersistentPublisherStatsImpl)this.nonPersistentPublishersMap.computeIfAbsent(nonPersistentPublisherStats.getProducerName(), key -> {
                    NonPersistentPublisherStatsImpl newStats = new NonPersistentPublisherStatsImpl();
                    newStats.setSupportsPartialProducer(true);
                    newStats.setProducerName(s2.getProducerName());
                    return newStats;
                })).add((NonPersistentPublisherStatsImpl)nonPersistentPublisherStats);
                continue;
            }
            if (index == this.nonPersistentPublishers.size()) {
                NonPersistentPublisherStatsImpl newStats = new NonPersistentPublisherStatsImpl();
                newStats.setSupportsPartialProducer(false);
                this.nonPersistentPublishers.add(newStats);
            }
            ((NonPersistentPublisherStatsImpl)this.nonPersistentPublishers.get(index)).add((NonPersistentPublisherStatsImpl)nonPersistentPublisherStats);
        }
        for (Map.Entry<String, NonPersistentSubscriptionStats> entry : stats.getNonPersistentSubscriptions().entrySet()) {
            NonPersistentSubscriptionStatsImpl subscriptionStats = (NonPersistentSubscriptionStatsImpl)this.getNonPersistentSubscriptions().computeIfAbsent(entry.getKey(), k -> new NonPersistentSubscriptionStatsImpl());
            subscriptionStats.add((NonPersistentSubscriptionStatsImpl)entry.getValue());
        }
        for (Map.Entry<String, NonPersistentSubscriptionStats> entry : stats.getNonPersistentReplicators().entrySet()) {
            NonPersistentReplicatorStatsImpl replStats = (NonPersistentReplicatorStatsImpl)this.getNonPersistentReplicators().computeIfAbsent(entry.getKey(), k -> {
                NonPersistentReplicatorStatsImpl r = new NonPersistentReplicatorStatsImpl();
                return r;
            });
            replStats.add((NonPersistentReplicatorStatsImpl)entry.getValue());
        }
        return this;
    }
}

