/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.tcp.handler;

import java.util.Collections;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.base.handler.ProxySelectorDataHandler;
import org.apache.shenyu.plugin.tcp.handler.TcpBootstrapFactory;
import org.apache.shenyu.protocol.tcp.BootstrapServer;
import org.apache.shenyu.protocol.tcp.TcpServerConfiguration;
import org.apache.shenyu.protocol.tcp.UpstreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpProxySelectorDataHandler
implements ProxySelectorDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TcpProxySelectorDataHandler.class);

    public void handlerProxySelector(ProxySelectorData proxySelectorData) {
        String name = proxySelectorData.getName();
        if (!TcpBootstrapFactory.getSingleton().inCache(name).booleanValue()) {
            Integer forwardPort = proxySelectorData.getForwardPort();
            TcpServerConfiguration tcpServerConfiguration = new TcpServerConfiguration();
            tcpServerConfiguration.setPort(forwardPort.intValue());
            tcpServerConfiguration.setProps(proxySelectorData.getProps());
            tcpServerConfiguration.setPluginSelectorName(name);
            UpstreamProvider.getSingleton().createUpstreams(name, Collections.emptyList());
            BootstrapServer bootstrapServer = TcpBootstrapFactory.getSingleton().createBootstrapServer(tcpServerConfiguration);
            TcpBootstrapFactory.getSingleton().cache(name, bootstrapServer);
            LOG.info("shenyu create TcpBootstrapServer success name is {} port is {}", (Object)proxySelectorData.getName(), (Object)forwardPort);
        } else {
            LOG.info("shenyu already created TcpBootstrapServer name is {} port is {}", (Object)proxySelectorData.getName(), (Object)proxySelectorData.getForwardPort());
        }
    }

    public void removeProxySelector(String proxySelectorName) {
        if (TcpBootstrapFactory.getSingleton().inCache(proxySelectorName).booleanValue()) {
            TcpBootstrapFactory.getSingleton().removeCache(proxySelectorName).shutdown();
            LOG.info("shenyu shutdown {}", (Object)proxySelectorName);
        }
    }

    public String pluginName() {
        return PluginEnum.TCP.getName();
    }
}

