/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    public static final int MILLISECONDS_PER_SECONDE = 1000;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final String DATE_FORMAT_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_MILLS_TIME = "yyyy-MM-dd HH:mm:ss.SSS";

    public static int getDelayToNextMinute(long rightnow) {
        return (int)(60000L - rightnow % 60000L);
    }

    public static long getPreMinuteMills(long rightnow) {
        return rightnow - rightnow % 60000L - 1L;
    }

    public static String dateToStr(Date date) {
        return DateUtils.dateToStr(date, DATE_FORMAT_TIME);
    }

    public static String dateToStr(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Date strToDate(String dateStr) throws ParseException {
        return DateUtils.strToDate(dateStr, DATE_FORMAT_TIME);
    }

    public static Long strToLong(String dateStr) throws ParseException {
        return DateUtils.strToDate(dateStr).getTime();
    }

    public static Date strToDate(String dateStr, String format) throws ParseException {
        return new SimpleDateFormat(format).parse(dateStr);
    }

    public static String dateToMillisStr(Date date) {
        return DateUtils.dateToStr(date, DATE_FORMAT_MILLS_TIME);
    }

    public static Date millisStrToDate(String millisDateStr) throws ParseException {
        return DateUtils.strToDate(millisDateStr, DATE_FORMAT_MILLS_TIME);
    }
}

