/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.message.triple.stream;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import com.alipay.sofa.rpc.transport.SofaStreamObserver;
import io.grpc.stub.StreamObserver;
import triple.Response;

public class ClientStreamObserverAdapter
implements StreamObserver<Response> {
    private final SofaStreamObserver<Object> sofaStreamObserver;
    private final Serializer serializer;
    private volatile Class<?> returnType;

    public ClientStreamObserverAdapter(SofaStreamObserver<Object> sofaStreamObserver, byte serializeType) {
        this.sofaStreamObserver = sofaStreamObserver;
        this.serializer = SerializerFactory.getSerializer(serializeType);
    }

    public void onNext(Response response) {
        byte[] responseData = response.getData().toByteArray();
        Object appResponse = null;
        String returnTypeName = response.getType();
        if (responseData != null && responseData.length > 0) {
            if (this.returnType == null && !returnTypeName.isEmpty()) {
                try {
                    this.returnType = Class.forName(returnTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw new SofaRpcException(220, "Can not find return type :" + this.returnType);
                }
            }
            appResponse = this.serializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(responseData), this.returnType, null);
        }
        this.sofaStreamObserver.onNext(appResponse);
    }

    public void onError(Throwable t) {
        this.sofaStreamObserver.onError(t);
    }

    public void onCompleted() {
        this.sofaStreamObserver.onCompleted();
    }
}

