/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log;

import com.alibaba.csp.sentinel.log.LogTarget;
import com.alibaba.csp.sentinel.log.Logger;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class LoggerSpiProvider {
    private static final Map<String, Logger> LOGGER_MAP = new HashMap<String, Logger>();

    public static Logger getLogger(String name) {
        if (name == null) {
            return null;
        }
        return LOGGER_MAP.get(name);
    }

    private static void resolveLoggers() {
        ServiceLoader<Logger> loggerLoader = ServiceLoader.load(Logger.class);
        for (Logger logger : loggerLoader) {
            String name;
            LogTarget annotation = logger.getClass().getAnnotation(LogTarget.class);
            if (annotation == null || !StringUtil.isNotBlank(name = annotation.value()) || LOGGER_MAP.containsKey(name)) continue;
            LOGGER_MAP.put(name, logger);
            System.out.println("Sentinel Logger SPI loaded for <" + name + ">: " + logger.getClass().getCanonicalName());
        }
    }

    private LoggerSpiProvider() {
    }

    static {
        try {
            LoggerSpiProvider.resolveLoggers();
        }
        catch (Throwable t) {
            System.err.println("Failed to resolve Sentinel Logger SPI");
            t.printStackTrace();
        }
    }
}

