/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.dubbo.metrics.aggregate.Pane;
import org.apache.dubbo.metrics.aggregate.SlidingWindow;

public class TimeWindowCounter {
    private final LongAdderSlidingWindow slidingWindow;

    public TimeWindowCounter(int bucketNum, long timeWindowSeconds) {
        this.slidingWindow = new LongAdderSlidingWindow(bucketNum, TimeUnit.SECONDS.toMillis(timeWindowSeconds));
    }

    public double get() {
        double result = 0.0;
        List windows = this.slidingWindow.values();
        for (LongAdder window : windows) {
            result += (double)window.sum();
        }
        return result;
    }

    public long bucketLivedSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds((long)this.slidingWindow.values().size() * this.slidingWindow.getPaneIntervalInMs());
    }

    public long bucketLivedMillSeconds() {
        return this.slidingWindow.getIntervalInMs() - (System.currentTimeMillis() - this.slidingWindow.currentPane().getEndInMs());
    }

    public void increment() {
        this.increment(1L);
    }

    public void increment(Long step) {
        ((LongAdder)this.slidingWindow.currentPane().getValue()).add(step);
    }

    public void decrement() {
        this.decrement(1L);
    }

    public void decrement(Long step) {
        ((LongAdder)this.slidingWindow.currentPane().getValue()).add(-step.longValue());
    }

    private static class LongAdderSlidingWindow
    extends SlidingWindow<LongAdder> {
        public LongAdderSlidingWindow(int sampleCount, long intervalInMs) {
            super(sampleCount, intervalInMs);
        }

        @Override
        public LongAdder newEmptyValue(long timeMillis) {
            return new LongAdder();
        }

        @Override
        protected Pane<LongAdder> resetPaneTo(Pane<LongAdder> pane, long startTime) {
            pane.setStartInMs(startTime);
            pane.getValue().reset();
            return pane;
        }
    }
}

