/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RequestEvent;
import org.apache.dubbo.metrics.event.SimpleMetricsEventMulticaster;
import org.apache.dubbo.metrics.listener.AbstractMetricsKeyListener;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.CategoryOverall;
import org.apache.dubbo.metrics.model.key.MetricsCat;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;

public final class DefaultSubDispatcher
extends SimpleMetricsEventMulticaster {
    public DefaultSubDispatcher(final DefaultMetricsCollector collector) {
        CategoryOverall categoryOverall = this.initMethodRequest();
        super.addListener(categoryOverall.getPost().getEventFunc().apply(collector));
        super.addListener(categoryOverall.getFinish().getEventFunc().apply(collector));
        super.addListener(categoryOverall.getError().getEventFunc().apply(collector));
        super.addListener(new MetricsListener<RequestEvent>(){
            private final MetricsPlaceValue dynamicPlaceType = MetricsPlaceValue.of("consumer", MetricsLevel.METHOD);

            @Override
            public boolean isSupport(MetricsEvent event) {
                return event instanceof RequestEvent && ((RequestEvent)event).isRequestErrorEvent();
            }

            @Override
            public void onEvent(RequestEvent event) {
                MetricsSupport.increment(MetricsKey.METRIC_REQUESTS_SERVICE_UNAVAILABLE_FAILED, this.dynamicPlaceType, collector, (MetricsEvent)event);
            }
        });
    }

    private CategoryOverall initMethodRequest() {
        return new CategoryOverall(null, new MetricsCat(MetricsKey.METRIC_REQUESTS, (key, placeType, collector) -> AbstractMetricsKeyListener.onEvent(key, event -> {
            MetricsPlaceValue dynamicPlaceType = MetricsPlaceValue.of((String)event.getAttachmentValue("metric_filter_side"), MetricsLevel.METHOD);
            MetricsSupport.increment(key, dynamicPlaceType, collector, (MetricsEvent)event);
            MetricsSupport.increment(MetricsKey.METRIC_REQUESTS_PROCESSING, dynamicPlaceType, collector, (MetricsEvent)event);
        })), new MetricsCat(MetricsKey.METRIC_REQUESTS_SUCCEED, (key, placeType, collector) -> AbstractMetricsKeyListener.onFinish(key, event -> {
            MetricsKey targetKey;
            MetricsPlaceValue dynamicPlaceType = MetricsPlaceValue.of((String)event.getAttachmentValue("metric_filter_side"), MetricsLevel.METHOD);
            MetricsSupport.dec(MetricsKey.METRIC_REQUESTS_PROCESSING, dynamicPlaceType, collector, event);
            Object throwableObj = event.getAttachmentValue("metric_filter_throwable");
            if (throwableObj == null) {
                targetKey = key;
            } else {
                targetKey = MetricsSupport.getMetricsKey((Throwable)throwableObj);
                MetricsSupport.increment(MetricsKey.METRIC_REQUESTS_TOTAL_FAILED, dynamicPlaceType, collector, (MetricsEvent)event);
            }
            MetricsSupport.incrAndAddRt(targetKey, dynamicPlaceType, collector, event);
        })), new MetricsCat(MetricsKey.METRIC_REQUEST_BUSINESS_FAILED, (key, placeType, collector) -> AbstractMetricsKeyListener.onError(key, event -> {
            MetricsKey targetKey = MetricsSupport.getMetricsKey((Throwable)event.getAttachmentValue("metric_filter_throwable"));
            MetricsPlaceValue dynamicPlaceType = MetricsPlaceValue.of((String)event.getAttachmentValue("metric_filter_side"), MetricsLevel.METHOD);
            MetricsSupport.increment(MetricsKey.METRIC_REQUESTS_TOTAL_FAILED, dynamicPlaceType, collector, (MetricsEvent)event);
            MetricsSupport.dec(MetricsKey.METRIC_REQUESTS_PROCESSING, dynamicPlaceType, collector, event);
            MetricsSupport.incrAndAddRt(targetKey, dynamicPlaceType, collector, event);
        })));
    }
}

